/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.explanations.drup;

import java.util.ArrayList;
import java.util.HashMap;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;

public final class DRUPTrim {
    private static final int BIGINIT = 1000000;
    private static final int UNSAT = 0;
    private static final int SAT = 1;
    private static final int EXTRA = 2;
    private static final int MARK = 3;

    private static int getHash(int[] _marks, int mark, LNGIntVector input) {
        int sum = 0;
        int xor = 0;
        int prod = 1;
        for (int i = 0; i < input.size(); ++i) {
            prod *= input.get(i);
            sum += input.get(i);
            xor ^= input.get(i);
            _marks[DRUPTrim.index((int)input.get((int)i))] = mark;
        }
        return Math.abs((1023 * sum + prod ^ 31 * xor) % 1000000);
    }

    private static int index(int lit) {
        return lit > 0 ? lit * 2 : -lit * 2 ^ 1;
    }

    public DRUPResult compute(LNGVector<LNGIntVector> originalProblem, LNGVector<LNGIntVector> proof) {
        DRUPResult result = new DRUPResult();
        Solver s = new Solver(originalProblem, proof);
        boolean parseReturnValue = s.parse();
        if (!parseReturnValue) {
            result.trivialUnsat = true;
            result.unsatCore = new LNGVector();
        } else {
            result.trivialUnsat = false;
            result.unsatCore = s.verify();
        }
        return result;
    }

    public static class DRUPResult {
        private boolean trivialUnsat;
        private LNGVector<LNGIntVector> unsatCore;

        public boolean trivialUnsat() {
            return this.trivialUnsat;
        }

        public LNGVector<LNGIntVector> unsatCore() {
            return this.unsatCore;
        }
    }

    private static class Solver {
        private final LNGVector<LNGIntVector> originalProblem;
        private final LNGVector<LNGIntVector> proof;
        private final LNGVector<LNGIntVector> core;
        private final boolean delete;
        private LNGIntVector DB;
        private int nVars;
        private int nClauses;
        private int[] falseStack;
        private int[] reason;
        private int[] internalFalse;
        private int forcedPtr;
        private int processedPtr;
        private int assignedPtr;
        private LNGIntVector adlist;
        private LNGIntVector[] wlist;
        private int count;
        private int adlemmas;
        private int lemmas;
        private int time;

        private Solver(LNGVector<LNGIntVector> originalProblem, LNGVector<LNGIntVector> proof) {
            this.originalProblem = originalProblem;
            this.proof = proof;
            this.core = new LNGVector();
            this.delete = true;
        }

        private void assign(int a) {
            this.internalFalse[DRUPTrim.index((int)(-a))] = 1;
            this.falseStack[this.assignedPtr++] = -a;
        }

        private void addWatch(int cPtr, int index) {
            int lit = this.DB.get(cPtr + index);
            this.wlist[DRUPTrim.index(lit)].push(cPtr << 1);
        }

        private void addWatchLit(int l, int m) {
            this.wlist[DRUPTrim.index(l)].push(m);
        }

        private void removeWatch(int cPtr, int index) {
            int _cPtr;
            int lit = this.DB.get(cPtr + index);
            LNGIntVector watch = this.wlist[DRUPTrim.index(lit)];
            int watchPtr = 0;
            while ((_cPtr = watch.get(watchPtr++) >> 1) != cPtr) {
            }
            watch.set(watchPtr - 1, this.wlist[DRUPTrim.index(lit)].back());
            this.wlist[DRUPTrim.index(lit)].pop();
        }

        private void markWatch(int clausePtr, int index, int offset) {
            int _clause;
            LNGIntVector watch = this.wlist[DRUPTrim.index(this.DB.get(clausePtr + index))];
            int clause = this.DB.get(clausePtr - offset - 1);
            int watchPtr = 0;
            while ((_clause = this.DB.get((watch.get(watchPtr++) >> 1) - 1)) != clause) {
            }
            watch.set(watchPtr - 1, watch.get(watchPtr - 1) | 1);
        }

        private void markClause(int clausePtr, int index) {
            if ((this.DB.get(clausePtr + index - 1) & 1) == 0) {
                this.DB.set(clausePtr + index - 1, this.DB.get(clausePtr + index - 1) | 1);
                if (this.DB.get(clausePtr + 1 + index) == 0) {
                    return;
                }
                this.markWatch(clausePtr, index, -index);
                this.markWatch(clausePtr, 1 + index, -index);
            }
            while (this.DB.get(clausePtr) != 0) {
                this.internalFalse[DRUPTrim.index((int)this.DB.get((int)clausePtr++))] = 3;
            }
        }

        private void analyze(int clausePtr) {
            this.markClause(clausePtr, 0);
            while (this.assignedPtr > 0) {
                int lit;
                if (this.internalFalse[DRUPTrim.index(lit = this.falseStack[--this.assignedPtr])] == 3 && this.reason[Math.abs(lit)] != 0) {
                    this.markClause(this.reason[Math.abs(lit)], -1);
                }
                this.internalFalse[DRUPTrim.index((int)lit)] = this.assignedPtr < this.forcedPtr ? 1 : 0;
            }
            this.processedPtr = this.forcedPtr;
            this.assignedPtr = this.forcedPtr;
        }

        private int propagate() {
            int[] start = new int[2];
            int check = 0;
            int _lit = 0;
            int _watchPtr = 0;
            start[0] = this.processedPtr;
            start[1] = this.processedPtr;
            boolean gotoFlipCheck = true;
            while (gotoFlipCheck) {
                gotoFlipCheck = false;
                check ^= 1;
                block1: while (!gotoFlipCheck && start[check] < this.assignedPtr) {
                    int watchPtr;
                    int n = check;
                    int n2 = start[n];
                    start[n] = n2 + 1;
                    int lit = this.falseStack[n2];
                    LNGIntVector watch = this.wlist[DRUPTrim.index(lit)];
                    int n3 = watchPtr = lit == _lit ? _watchPtr : 0;
                    while (watchPtr < watch.size()) {
                        if ((watch.get(watchPtr) & 1) != check) {
                            ++watchPtr;
                            continue;
                        }
                        int clausePtr = watch.get(watchPtr) / 2;
                        if (this.internalFalse[DRUPTrim.index(-this.DB.get(clausePtr))] != 0 || this.internalFalse[DRUPTrim.index(-this.DB.get(clausePtr + 1))] != 0) {
                            ++watchPtr;
                            continue;
                        }
                        if (this.DB.get(clausePtr) == lit) {
                            this.DB.set(clausePtr, this.DB.get(clausePtr + 1));
                        }
                        boolean gotoNextClause = false;
                        int i = 2;
                        while (this.DB.get(clausePtr + i) != 0) {
                            if (this.internalFalse[DRUPTrim.index(this.DB.get(clausePtr + i))] == 0) {
                                this.DB.set(clausePtr + 1, this.DB.get(clausePtr + i));
                                this.DB.set(clausePtr + i, lit);
                                this.addWatchLit(this.DB.get(clausePtr + 1), watch.get(watchPtr));
                                watch.set(watchPtr, this.wlist[DRUPTrim.index(lit)].back());
                                this.wlist[DRUPTrim.index(lit)].pop();
                                gotoNextClause = true;
                                break;
                            }
                            ++i;
                        }
                        if (gotoNextClause) continue;
                        this.DB.set(clausePtr + 1, lit);
                        ++watchPtr;
                        if (this.internalFalse[DRUPTrim.index(this.DB.get(clausePtr))] == 0) {
                            this.assign(this.DB.get(clausePtr));
                            this.reason[Math.abs((int)this.DB.get((int)clausePtr))] = clausePtr + 1;
                            if (check != 0) continue;
                            start[0] = start[0] - 1;
                            _lit = lit;
                            _watchPtr = watchPtr;
                            gotoFlipCheck = true;
                            continue block1;
                        }
                        this.analyze(clausePtr);
                        return 0;
                    }
                }
                if (check == 0) continue;
                gotoFlipCheck = true;
            }
            this.processedPtr = this.assignedPtr;
            return 1;
        }

        int matchClause(LNGIntVector clauselist, int[] _marks, int mark, LNGIntVector input) {
            for (int i = 0; i < clauselist.size(); ++i) {
                int matchsize = 0;
                boolean aborted = false;
                int l = clauselist.get(i);
                while (this.DB.get(l) != 0) {
                    if (_marks[DRUPTrim.index(this.DB.get(l))] != mark) {
                        aborted = true;
                        break;
                    }
                    ++matchsize;
                    ++l;
                }
                if (aborted || input.size() != matchsize) continue;
                int result = clauselist.get(i);
                clauselist.set(i, clauselist.back());
                return result;
            }
            throw new IllegalStateException("Could not match deleted clause");
        }

        private boolean parse() {
            this.nVars = 0;
            for (LNGIntVector vector : this.originalProblem) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (Math.abs(vector.get(i)) <= this.nVars) continue;
                    this.nVars = Math.abs(vector.get(i));
                }
            }
            this.nClauses = this.originalProblem.size();
            boolean del = false;
            int nZeros = this.nClauses;
            LNGIntVector buffer = new LNGIntVector();
            this.DB = new LNGIntVector();
            this.count = 1;
            this.falseStack = new int[this.nVars + 1];
            this.reason = new int[this.nVars + 1];
            this.internalFalse = new int[2 * this.nVars + 3];
            this.wlist = new LNGIntVector[2 * this.nVars + 3];
            for (int i = 1; i <= this.nVars; ++i) {
                this.wlist[DRUPTrim.index((int)i)] = new LNGIntVector();
                this.wlist[DRUPTrim.index((int)(-i))] = new LNGIntVector();
            }
            this.adlist = new LNGIntVector();
            int[] marks = new int[2 * this.nVars + 3];
            int mark = 0;
            HashMap<Integer, LNGIntVector> hashTable = new HashMap<Integer, LNGIntVector>();
            LNGVector<LNGIntVector> currentFile = this.originalProblem;
            int clauseNr = 0;
            while (true) {
                int i;
                LNGIntVector clause;
                boolean lit = false;
                boolean fileSwitchFlag = nZeros <= 0;
                if ((clause = currentFile.get(clauseNr++)) == null) {
                    this.lemmas = this.DB.size() + 1;
                    break;
                }
                ArrayList<Integer> toks = new ArrayList<Integer>(clause.size() - 1);
                if (fileSwitchFlag && clause.get(0) == -1) {
                    del = true;
                }
                int n = i = fileSwitchFlag ? 1 : 0;
                while (i < clause.size()) {
                    toks.add(clause.get(i));
                    ++i;
                }
                for (Integer l : toks) {
                    buffer.push(l);
                }
                if (clauseNr >= currentFile.size() && !fileSwitchFlag) {
                    fileSwitchFlag = true;
                    clauseNr = 0;
                    currentFile = this.proof;
                }
                if (clauseNr > currentFile.size() && fileSwitchFlag && !currentFile.empty()) break;
                if (Math.abs(0) > this.nVars) {
                    throw new IllegalStateException(String.format("Illegal literal %d due to max var %d", 0, this.nVars));
                }
                int hash = DRUPTrim.getHash(marks, ++mark, buffer);
                if (del) {
                    if (this.delete) {
                        int match = this.matchClause((LNGIntVector)hashTable.get(hash), marks, mark, buffer);
                        ((LNGIntVector)hashTable.get(hash)).pop();
                        this.adlist.push((match << 1) + 1);
                    }
                    del = false;
                    buffer.clear();
                    continue;
                }
                int clausePtr = this.DB.size() + 1;
                this.DB.push(2 * this.count++);
                for (int i2 = 0; i2 < buffer.size(); ++i2) {
                    this.DB.push(buffer.get(i2));
                }
                this.DB.push(0);
                LNGIntVector vec = (LNGIntVector)hashTable.get(hash);
                if (vec == null) {
                    vec = new LNGIntVector();
                    hashTable.put(hash, vec);
                }
                vec.push(clausePtr);
                this.adlist.push(clausePtr << 1);
                if (nZeros == 0) {
                    this.lemmas = clausePtr;
                    this.adlemmas = this.adlist.size() - 1;
                }
                if (nZeros > 0) {
                    if (buffer.empty() || buffer.size() == 1 && this.internalFalse[DRUPTrim.index(this.DB.get(clausePtr))] != 0) {
                        return false;
                    }
                    if (buffer.size() == 1) {
                        if (this.internalFalse[DRUPTrim.index(-this.DB.get(clausePtr))] == 0) {
                            this.reason[Math.abs((int)this.DB.get((int)clausePtr))] = clausePtr + 1;
                            this.assign(this.DB.get(clausePtr));
                        }
                    } else {
                        this.addWatch(clausePtr, 0);
                        this.addWatch(clausePtr, 1);
                    }
                } else if (buffer.empty()) break;
                buffer.clear();
                --nZeros;
            }
            return true;
        }

        private LNGVector<LNGIntVector> verify() {
            int marked;
            boolean flag = false;
            int clausePtr = 0;
            int lemmasPtr = this.lemmas;
            int lastPtr = this.lemmas;
            int endPtr = this.lemmas;
            int checked = this.adlemmas;
            LNGIntVector buffer = new LNGIntVector();
            this.time = this.DB.get(lemmasPtr - 1);
            boolean gotoPostProcess = false;
            if (this.processedPtr < this.assignedPtr && this.propagate() == 0) {
                gotoPostProcess = true;
            }
            this.forcedPtr = this.processedPtr;
            if (!gotoPostProcess) {
                int cPtr;
                int ad;
                long d;
                boolean gotoVerification = false;
                while (!gotoVerification) {
                    flag = false;
                    buffer.clear();
                    this.time = this.DB.get(lemmasPtr - 1);
                    clausePtr = lemmasPtr;
                    do {
                        ad = this.adlist.get(checked++);
                        d = ad & 1;
                        cPtr = ad >> 1;
                        if (d == 0L || this.DB.get(cPtr + 1) == 0 || this.reason[Math.abs(this.DB.get(cPtr))] - 1 == ad >> 1) continue;
                        this.removeWatch(cPtr, 0);
                        this.removeWatch(cPtr, 1);
                    } while (d != 0L);
                    while (this.DB.get(lemmasPtr) != 0) {
                        int lit;
                        if (this.internalFalse[DRUPTrim.index(-(lit = this.DB.get(lemmasPtr++)))] != 0) {
                            flag = true;
                        }
                        if (this.internalFalse[DRUPTrim.index(lit)] != 0) continue;
                        if (buffer.size() <= 1) {
                            this.DB.set(lemmasPtr - 1, this.DB.get(clausePtr + buffer.size()));
                            this.DB.set(clausePtr + buffer.size(), lit);
                        }
                        buffer.push(lit);
                    }
                    if (this.DB.get(clausePtr + 1) != 0) {
                        this.addWatch(clausePtr, 0);
                        this.addWatch(clausePtr, 1);
                    }
                    lemmasPtr += 2;
                    if (flag) {
                        this.adlist.set(checked - 1, 0);
                    }
                    if (flag) continue;
                    if (buffer.empty()) {
                        throw new IllegalStateException("Conflict claimed, but not detected");
                    }
                    if (buffer.size() == 1) {
                        this.assign(buffer.get(0));
                        this.reason[Math.abs((int)buffer.get((int)0))] = clausePtr + 1;
                        this.forcedPtr = this.processedPtr;
                        if (this.propagate() == 0) {
                            gotoVerification = true;
                        }
                    }
                    if (lemmasPtr < this.DB.size()) continue;
                }
                if (!gotoVerification) {
                    throw new IllegalStateException("No conflict");
                }
                this.forcedPtr = this.processedPtr;
                lemmasPtr = clausePtr - 2;
                block3: while (true) {
                    buffer.clear();
                    clausePtr = lemmasPtr + 2;
                    do {
                        ad = this.adlist.get(--checked);
                        d = ad & 1;
                        cPtr = ad >> 1;
                        if (d == 0L || this.DB.get(cPtr + 1) == 0 || this.reason[Math.abs(this.DB.get(cPtr))] - 1 == ad >> 1) continue;
                        this.addWatch(cPtr, 0);
                        this.addWatch(cPtr, 1);
                    } while (d != 0L);
                    this.time = this.DB.get(clausePtr - 1);
                    if (this.DB.get(clausePtr + 1) != 0) {
                        this.removeWatch(clausePtr, 0);
                        this.removeWatch(clausePtr, 1);
                    }
                    boolean gotoNextLemma = false;
                    if (ad == 0) {
                        gotoNextLemma = true;
                    }
                    if (!gotoNextLemma) {
                        while (this.DB.get(clausePtr) != 0) {
                            int lit;
                            if (this.internalFalse[DRUPTrim.index(-(lit = this.DB.get(clausePtr++)))] != 0) {
                                flag = true;
                            }
                            if (this.internalFalse[DRUPTrim.index(lit)] != 0) continue;
                            buffer.push(lit);
                        }
                        if (flag && buffer.size() == 1) {
                            do {
                                this.internalFalse[DRUPTrim.index((int)this.falseStack[--this.forcedPtr])] = 0;
                            } while (this.falseStack[this.forcedPtr] != -buffer.get(0));
                            this.processedPtr = this.forcedPtr;
                            this.assignedPtr = this.forcedPtr;
                        }
                        if ((this.time & 1) != 0) {
                            for (int i = 0; i < buffer.size(); ++i) {
                                this.assign(-buffer.get(i));
                                this.reason[Math.abs((int)buffer.get((int)i))] = 0;
                            }
                            if (this.propagate() == 1) {
                                throw new IllegalStateException("Formula is SAT");
                            }
                        }
                    }
                    if (lemmasPtr + 2 == lastPtr) break;
                    while (true) {
                        if (this.DB.get(--lemmasPtr) == 0) continue block3;
                    }
                    break;
                }
            }
            lemmasPtr = 0;
            while (lemmasPtr + 2 <= lastPtr) {
                if ((this.DB.get(lemmasPtr++) & 1) != 0) {
                    ++this.count;
                }
                while (this.DB.get(lemmasPtr++) != 0) {
                }
            }
            lemmasPtr = 0;
            while (lemmasPtr + 2 <= lastPtr) {
                LNGIntVector coreVec = new LNGIntVector();
                marked = this.DB.get(lemmasPtr++) & 1;
                while (this.DB.get(lemmasPtr) != 0) {
                    if (marked != 0) {
                        coreVec.push(this.DB.get(lemmasPtr));
                    }
                    ++lemmasPtr;
                }
                if (marked != 0) {
                    this.core.push(coreVec);
                }
                ++lemmasPtr;
            }
            this.count = 0;
            while (lemmasPtr + 2 <= endPtr) {
                this.time = this.DB.get(lemmasPtr);
                if ((marked = this.DB.get(lemmasPtr++) & 1) != 0) {
                    ++this.count;
                }
                while (this.DB.get(lemmasPtr) != 0) {
                    ++lemmasPtr;
                }
                ++lemmasPtr;
            }
            return this.core;
        }
    }
}

