/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.datastructures.ubtrees;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.datastructures.ubtrees.UBNode;

public final class UBTree<T extends Comparable<T>> {
    private final SortedMap<T, UBNode<T>> rootNodes = new TreeMap<T, UBNode<T>>();

    public void addSet(SortedSet<T> set) {
        SortedMap<T, UBNode<T>> nodes = this.rootNodes;
        UBNode node = null;
        for (Comparable element : set) {
            node = (UBNode)nodes.get(element);
            if (node == null) {
                node = new UBNode(element);
                nodes.put(element, node);
            }
            nodes = node.children();
        }
        if (node != null) {
            node.setEndSet(set);
        }
    }

    public SortedSet<T> firstSubset(SortedSet<T> set) {
        if (this.rootNodes.isEmpty() || set == null || set.isEmpty()) {
            return null;
        }
        return this.firstSubset(set, this.rootNodes);
    }

    public Set<SortedSet<T>> allSubsets(SortedSet<T> set) {
        LinkedHashSet<SortedSet<T>> subsets = new LinkedHashSet<SortedSet<T>>();
        this.allSubsets(set, this.rootNodes, subsets);
        return subsets;
    }

    public Set<SortedSet<T>> allSupersets(SortedSet<T> set) {
        LinkedHashSet<SortedSet<T>> supersets = new LinkedHashSet<SortedSet<T>>();
        this.allSupersets(set, this.rootNodes, supersets);
        return supersets;
    }

    public Set<SortedSet<T>> allSets() {
        List<UBNode<T>> allEndOfPathNodes = this.getAllEndOfPathNodes(this.rootNodes);
        LinkedHashSet<SortedSet<T>> allSets = new LinkedHashSet<SortedSet<T>>();
        for (UBNode<T> endOfPathNode : allEndOfPathNodes) {
            allSets.add(endOfPathNode.set());
        }
        return allSets;
    }

    SortedMap<T, UBNode<T>> rootNodes() {
        return this.rootNodes;
    }

    private SortedSet<T> firstSubset(SortedSet<T> set, SortedMap<T, UBNode<T>> forest) {
        Set<UBNode<T>> nodes = this.getAllNodesContainingElements(set, forest);
        SortedSet<T> foundSubset = null;
        for (UBNode<T> node : nodes) {
            if (foundSubset != null) {
                return foundSubset;
            }
            if (node.isEndOfPath()) {
                return node.set();
            }
            TreeSet<T> remainingSet = new TreeSet<T>(set);
            remainingSet.remove(set.first());
            foundSubset = this.firstSubset(remainingSet, node.children());
        }
        return foundSubset;
    }

    private void allSubsets(SortedSet<T> set, SortedMap<T, UBNode<T>> forest, Set<SortedSet<T>> subsets) {
        Set<UBNode<T>> nodes = this.getAllNodesContainingElements(set, forest);
        for (UBNode<T> node : nodes) {
            if (node.isEndOfPath()) {
                subsets.add(node.set());
            }
            TreeSet<T> remainingSet = new TreeSet<T>(set);
            remainingSet.remove(set.first());
            this.allSubsets(remainingSet, node.children(), subsets);
        }
    }

    private void allSupersets(SortedSet<T> set, SortedMap<T, UBNode<T>> forest, Set<SortedSet<T>> supersets) {
        Set<UBNode<Comparable>> nodes = this.getAllNodesContainingElementsLessThan(set, forest, (Comparable)set.first());
        for (UBNode<Comparable> uBNode : nodes) {
            this.allSupersets(set, uBNode.children(), supersets);
        }
        for (UBNode uBNode : forest.values()) {
            if (!uBNode.element().equals(set.first())) continue;
            TreeSet<T> remainingSet = new TreeSet<T>(set);
            remainingSet.remove(set.first());
            if (!remainingSet.isEmpty()) {
                this.allSupersets(remainingSet, uBNode.children(), supersets);
                continue;
            }
            List allEndOfPathNodes = this.getAllEndOfPathNodes(uBNode.children());
            if (uBNode.isEndOfPath()) {
                allEndOfPathNodes.add(uBNode);
            }
            for (UBNode endOfPathNode : allEndOfPathNodes) {
                supersets.add(endOfPathNode.set());
            }
        }
    }

    private Set<UBNode<T>> getAllNodesContainingElements(SortedSet<T> set, SortedMap<T, UBNode<T>> forest) {
        LinkedHashSet<UBNode<T>> nodes = new LinkedHashSet<UBNode<T>>();
        for (Comparable element : set) {
            UBNode node = (UBNode)forest.get(element);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private Set<UBNode<T>> getAllNodesContainingElementsLessThan(SortedSet<T> set, SortedMap<T, UBNode<T>> forest, T element) {
        LinkedHashSet<UBNode<T>> nodes = new LinkedHashSet<UBNode<T>>();
        for (UBNode<T> node : forest.values()) {
            if (node == null || node.element().compareTo(element) >= 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private List<UBNode<T>> getAllEndOfPathNodes(SortedMap<T, UBNode<T>> forest) {
        ArrayList<UBNode<T>> endOfPathNodes = new ArrayList<UBNode<T>>();
        this.getAllEndOfPathNodes(forest, endOfPathNodes);
        return endOfPathNodes;
    }

    private void getAllEndOfPathNodes(SortedMap<T, UBNode<T>> forest, List<UBNode<T>> endOfPathNodes) {
        for (UBNode<T> node : forest.values()) {
            if (node.isEndOfPath()) {
                endOfPathNodes.add(node);
            }
            this.getAllEndOfPathNodes(node.children(), endOfPathNodes);
        }
    }
}

