/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.datastructures.ubtrees;

import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public final class UBNode<T extends Comparable<T>> {
    private final T element;
    private final SortedMap<T, UBNode<T>> children;
    private SortedSet<T> set;

    UBNode(T element) {
        this.element = element;
        this.children = new TreeMap<T, UBNode<T>>();
    }

    T element() {
        return this.element;
    }

    SortedSet<T> set() {
        return this.set;
    }

    SortedMap<T, UBNode<T>> children() {
        return this.children;
    }

    boolean isEndOfPath() {
        return this.set != null;
    }

    void setEndSet(SortedSet<T> set) {
        this.set = set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UBNode ubNode = (UBNode)o;
        return Objects.equals(this.element, ubNode.element) && Objects.equals(this.children, ubNode.children) && Objects.equals(this.set, ubNode.set);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.children, this.set);
    }

    public String toString() {
        return "UBNode{element=" + this.element + ", children=" + this.children + ", set=" + this.set + '}';
    }
}

