/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.datastructures;

import java.util.ArrayList;
import java.util.List;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingAuxiliaryVariable;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.MiniSat;

public final class EncodingResult {
    private final FormulaFactory f;
    private final Proposition proposition;
    private final MiniSat miniSat;
    private List<Formula> result;

    private EncodingResult(FormulaFactory f, MiniSat miniSat, Proposition proposition) {
        this.f = f;
        this.proposition = proposition;
        this.miniSat = miniSat;
        this.reset();
    }

    public static EncodingResult resultForFormula(FormulaFactory f) {
        return new EncodingResult(f, null, null);
    }

    public static EncodingResult resultForMiniSat(FormulaFactory f, MiniSat miniSat, Proposition proposition) {
        return new EncodingResult(f, miniSat, proposition);
    }

    public void addClause(Literal ... literals) {
        if (this.miniSat == null) {
            this.result.add(this.f.clause(literals));
        } else {
            LNGIntVector clauseVec = new LNGIntVector(literals.length);
            for (Literal literal : literals) {
                this.addLiteral(clauseVec, literal);
            }
            this.miniSat.underlyingSolver().addClause(clauseVec, this.proposition);
            this.miniSat.setSolverToUndef();
        }
    }

    public void addClause(LNGVector<Literal> literals) {
        if (this.miniSat == null) {
            this.result.add(this.vec2clause(literals));
        } else {
            LNGIntVector clauseVec = new LNGIntVector(literals.size());
            for (Literal l : literals) {
                this.addLiteral(clauseVec, l);
            }
            this.miniSat.underlyingSolver().addClause(clauseVec, this.proposition);
            this.miniSat.setSolverToUndef();
        }
    }

    private void addLiteral(LNGIntVector clauseVec, Literal lit) {
        int index = this.miniSat.underlyingSolver().idxForName(lit.name());
        if (index == -1) {
            index = this.miniSat.underlyingSolver().newVar(!this.miniSat.initialPhase(), true);
            this.miniSat.underlyingSolver().addName(lit.name(), index);
        }
        int litNum = lit instanceof EncodingAuxiliaryVariable ? (!((EncodingAuxiliaryVariable)lit).negated ? index * 2 : index * 2 ^ 1) : (lit.phase() ? index * 2 : index * 2 ^ 1);
        clauseVec.push(litNum);
    }

    private Formula vec2clause(LNGVector<Literal> literals) {
        ArrayList<Literal> lits = new ArrayList<Literal>(literals.size());
        for (Literal l : literals) {
            lits.add(l);
        }
        return this.f.clause(lits);
    }

    public Variable newVariable() {
        if (this.miniSat == null) {
            return this.f.newCCVariable();
        }
        int index = this.miniSat.underlyingSolver().newVar(!this.miniSat.initialPhase(), true);
        String name = "@RESERVED_CC_MINISAT_" + index;
        this.miniSat.underlyingSolver().addName(name, index);
        return new EncodingAuxiliaryVariable(name, false);
    }

    public void reset() {
        this.result = new ArrayList<Formula>();
    }

    public List<Formula> result() {
        return this.result;
    }
}

