/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class Assignment {
    private final List<Variable> negVars;
    private Collection<Variable> pos;
    private Collection<Literal> neg;
    private boolean fastEvaluable;

    public Assignment() {
        this(false);
    }

    public Assignment(boolean fastEvaluable) {
        this.fastEvaluable = fastEvaluable;
        this.negVars = new ArrayList<Variable>();
        if (!fastEvaluable) {
            this.pos = new ArrayList<Variable>();
            this.neg = new ArrayList<Literal>();
        } else {
            this.pos = new HashSet<Variable>();
            this.neg = new HashSet<Literal>();
        }
    }

    public Assignment(Collection<? extends Literal> lits) {
        this(lits, false);
    }

    public Assignment(Literal ... lits) {
        this(false);
        for (Literal lit : lits) {
            this.addLiteral(lit);
        }
    }

    public Assignment(Collection<? extends Literal> lits, boolean fastEvaluable) {
        this(fastEvaluable);
        for (Literal literal : lits) {
            this.addLiteral(literal);
        }
    }

    public Assignment(Literal lit) {
        this(lit, false);
    }

    public Assignment(Literal lit, boolean fastEvaluable) {
        this(fastEvaluable);
        this.addLiteral(lit);
    }

    public void convertToFastEvaluable() {
        if (!this.fastEvaluable) {
            this.pos = new HashSet<Variable>(this.pos);
            this.neg = new HashSet<Literal>(this.neg);
            this.fastEvaluable = true;
        }
    }

    public boolean fastEvaluable() {
        return this.fastEvaluable;
    }

    public int size() {
        return this.pos.size() + this.neg.size();
    }

    public List<Variable> positiveVariables() {
        return this.fastEvaluable ? Collections.unmodifiableList(new ArrayList<Variable>(this.pos)) : Collections.unmodifiableList((List)this.pos);
    }

    public List<Literal> negativeLiterals() {
        return this.fastEvaluable ? Collections.unmodifiableList(new ArrayList<Literal>(this.neg)) : Collections.unmodifiableList((List)this.neg);
    }

    public List<Variable> negativeVariables() {
        return Collections.unmodifiableList(this.negVars);
    }

    public SortedSet<Literal> literals() {
        TreeSet<Literal> set = new TreeSet<Literal>();
        set.addAll(this.pos);
        set.addAll(this.neg);
        return set;
    }

    public void addLiteral(Literal lit) {
        if (lit.phase()) {
            this.pos.add(lit.variable());
        } else {
            this.neg.add(lit);
            this.negVars.add(lit.variable());
        }
    }

    public boolean evaluateLit(Literal lit) {
        return lit.phase() ? this.pos.contains(lit.variable()) : this.neg.contains(lit) || !this.pos.contains(lit.variable());
    }

    public Formula restrictLit(Literal lit) {
        FormulaFactory f = lit.factory();
        Variable var = lit.variable();
        if (this.pos.contains(var)) {
            return f.constant(lit.phase());
        }
        if (this.neg.contains(var.negate())) {
            return f.constant(!lit.phase());
        }
        return lit;
    }

    public Formula formula(FormulaFactory f) {
        return f.and(this.literals());
    }

    public Formula blockingClause(FormulaFactory f) {
        ArrayList<Literal> ops = new ArrayList<Literal>();
        for (Literal literal : this.pos) {
            ops.add(literal.negate());
        }
        for (Literal literal : this.neg) {
            ops.add(literal.negate());
        }
        return f.or(ops);
    }

    public Formula blockingClause(FormulaFactory f, Collection<? extends Literal> literals) {
        if (literals == null) {
            return this.blockingClause(f);
        }
        ArrayList<Literal> ops = new ArrayList<Literal>();
        for (Literal literal : literals) {
            Variable var = literal.variable();
            Literal negatedVar = var.negate();
            if (this.pos.contains(var)) {
                ops.add(negatedVar);
                continue;
            }
            if (!this.neg.contains(negatedVar)) continue;
            ops.add(var);
        }
        return f.or(ops);
    }

    public int hashCode() {
        return Objects.hash(new HashSet<Variable>(this.pos), new HashSet<Literal>(this.neg));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() == other.getClass()) {
            Assignment o = (Assignment)other;
            return Objects.equals(new HashSet<Variable>(this.pos), new HashSet<Variable>(o.pos)) && Objects.equals(new HashSet<Literal>(this.neg), new HashSet<Literal>(o.neg));
        }
        return false;
    }

    public String toString() {
        return String.format("Assignment{pos=%s, neg=%s}", this.pos, this.neg);
    }
}

