/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LNGVector<T>
implements Iterable<T> {
    private T[] elements;
    private int size;

    public LNGVector() {
        this(5);
    }

    public LNGVector(int size) {
        this.elements = new Object[size];
    }

    public LNGVector(int size, T pad) {
        this.elements = new Object[size];
        Arrays.fill(this.elements, pad);
        this.size = size;
    }

    @SafeVarargs
    public LNGVector(T ... elems) {
        this.elements = Arrays.copyOf(elems, elems.length);
        this.size = elems.length;
    }

    public LNGVector(Collection<T> elems) {
        this.elements = new Object[elems.size()];
        int count = 0;
        for (T e : elems) {
            this.elements[count++] = e;
        }
        this.size = elems.size();
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public T back() {
        return this.elements[this.size - 1];
    }

    public void push(T element) {
        int newSize = this.size + 1;
        this.ensure(newSize);
        this.elements[this.size++] = element;
    }

    public void unsafePush(T element) {
        this.elements[this.size++] = element;
    }

    public final T get(int position) {
        return this.elements[position];
    }

    public void set(int position, T element) {
        this.elements[position] = element;
    }

    public void pop() {
        this.elements[--this.size] = null;
    }

    public void shrinkTo(int newSize) {
        if (newSize < this.size) {
            for (int i = this.size; i > newSize; --i) {
                this.elements[i - 1] = null;
            }
            this.size = newSize;
        }
    }

    public void growTo(int size, T pad) {
        if (this.size >= size) {
            return;
        }
        this.ensure(size);
        for (int i = this.size; i < size; ++i) {
            this.elements[i] = pad;
        }
        this.size = size;
    }

    public void growTo(int size) {
        if (this.size >= size) {
            return;
        }
        this.ensure(size);
        this.size = size;
    }

    public void removeElements(int num) {
        int n = num;
        while (n-- > 0) {
            this.elements[--this.size] = null;
        }
    }

    public boolean remove(T element) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].equals(element)) continue;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - (i + 1));
            --this.size;
            return true;
        }
        return false;
    }

    public void replaceInplace(LNGVector<? extends T> other) {
        if (this == other) {
            throw new IllegalArgumentException("cannot replace a vector in-place with itself");
        }
        this.elements = new Object[other.size()];
        for (int i = 0; i < other.size(); ++i) {
            this.elements[i] = other.get(i);
        }
        this.size = other.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void release() {
        Arrays.fill(this.elements, null);
        this.size = 0;
    }

    public void sort(Comparator<T> comparator) {
        Arrays.sort(this.elements, 0, this.size, comparator);
    }

    public void manualSort(Comparator<T> comparator) {
        this.sort(this.elements, 0, this.size, comparator);
    }

    private void selectionSort(T[] array, int start, int end, Comparator<T> lt) {
        for (int i = start; i < end; ++i) {
            int bestI = i;
            for (int j = i + 1; j < end; ++j) {
                if (lt.compare(array[j], array[bestI]) >= 0) continue;
                bestI = j;
            }
            T tmp = array[i];
            array[i] = array[bestI];
            array[bestI] = tmp;
        }
    }

    private void sort(T[] array, int start, int end, Comparator<T> lt) {
        if (start == end) {
            return;
        }
        if (end - start <= 15) {
            this.selectionSort(array, start, end, lt);
        } else {
            T pivot = array[start + (end - start) / 2];
            int i = start - 1;
            int j = end;
            while (true) {
                if (lt.compare(array[++i], pivot) < 0) {
                    continue;
                }
                while (lt.compare(pivot, array[--j]) < 0) {
                }
                if (i >= j) break;
                T tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }
            this.sort(array, start, i, lt);
            this.sort(array, i, end, lt);
        }
    }

    public void sortReverse(Comparator<T> comparator) {
        this.sort(comparator);
        for (int i = 0; i < this.size / 2; ++i) {
            T temp = this.elements[i];
            this.elements[i] = this.elements[this.size - i - 1];
            this.elements[this.size - i - 1] = temp;
        }
    }

    private void ensure(int newSize) {
        if (newSize >= this.elements.length) {
            Object[] newArray = new Object[Math.max(newSize, this.size * 2)];
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
            this.elements = newArray;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < LNGVector.this.size;
            }

            @Override
            public T next() {
                if (this.i == LNGVector.this.size) {
                    throw new NoSuchElementException();
                }
                return LNGVector.this.elements[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

