/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.collections;

import java.util.Arrays;

public final class LNGLongVector {
    private long[] elements;
    private int size;

    public LNGLongVector() {
        this(5);
    }

    public LNGLongVector(int size) {
        this.elements = new long[size];
    }

    public LNGLongVector(int size, long pad) {
        this.elements = new long[size];
        Arrays.fill(this.elements, pad);
        this.size = size;
    }

    public LNGLongVector(LNGLongVector other) {
        this.elements = Arrays.copyOf(other.elements, other.size);
        this.size = other.size;
    }

    public LNGLongVector(long ... elems) {
        this.elements = Arrays.copyOf(elems, elems.length);
        this.size = elems.length;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public long back() {
        return this.elements[this.size - 1];
    }

    public void push(long element) {
        int newSize = this.size + 1;
        this.ensure(newSize);
        this.elements[this.size++] = element;
    }

    public void unsafePush(long element) {
        this.elements[this.size++] = element;
    }

    public long get(int position) {
        return this.elements[position];
    }

    public void set(int position, long element) {
        this.elements[position] = element;
    }

    public void pop() {
        this.elements[--this.size] = -1L;
    }

    public void shrinkTo(int newSize) {
        if (newSize < this.size) {
            this.size = newSize;
        }
    }

    public void growTo(int size, long pad) {
        if (this.size >= size) {
            return;
        }
        this.ensure(size);
        for (int i = this.size; i < size; ++i) {
            this.elements[i] = pad;
        }
        this.size = size;
    }

    public void removeElements(int num) {
        int count = num;
        while (count-- > 0) {
            this.elements[--this.size] = -1L;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public void sort() {
        Arrays.sort(this.elements, 0, this.size);
    }

    public void sortReverse() {
        Arrays.sort(this.elements, 0, this.size);
        for (int i = 0; i < this.size / 2; ++i) {
            long temp = this.elements[i];
            this.elements[i] = this.elements[this.size - i - 1];
            this.elements[this.size - i - 1] = temp;
        }
    }

    public long[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    private void ensure(int newSize) {
        if (newSize >= this.elements.length) {
            long[] newArray = new long[Math.max(newSize, this.size * 2)];
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
            this.elements = newArray;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

