/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.collections;

import java.util.Arrays;

public final class LNGIntVector {
    private int[] elements;
    private int size;

    public LNGIntVector() {
        this(5);
    }

    public LNGIntVector(int size) {
        this.elements = new int[size];
    }

    public LNGIntVector(int size, int pad) {
        this.elements = new int[size];
        Arrays.fill(this.elements, pad);
        this.size = size;
    }

    public LNGIntVector(LNGIntVector other) {
        this.elements = Arrays.copyOf(other.elements, other.size);
        this.size = other.size;
    }

    public LNGIntVector(int ... elems) {
        this.elements = Arrays.copyOf(elems, elems.length);
        this.size = elems.length;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int back() {
        return this.elements[this.size - 1];
    }

    public void push(int element) {
        int newSize = this.size + 1;
        this.ensure(newSize);
        this.elements[this.size++] = element;
    }

    public void unsafePush(int element) {
        this.elements[this.size++] = element;
    }

    public int get(int position) {
        return this.elements[position];
    }

    public void set(int position, int element) {
        this.elements[position] = element;
    }

    public void pop() {
        this.elements[--this.size] = -1;
    }

    public void shrinkTo(int newSize) {
        if (newSize < this.size) {
            this.size = newSize;
        }
    }

    public void growTo(int size, int pad) {
        if (this.size >= size) {
            return;
        }
        this.ensure(size);
        for (int i = this.size; i < size; ++i) {
            this.elements[i] = pad;
        }
        this.size = size;
    }

    public void removeElements(int num) {
        int count = num;
        while (count-- > 0) {
            this.elements[--this.size] = -1;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public void sort() {
        Arrays.sort(this.elements, 0, this.size);
    }

    public void sortReverse() {
        Arrays.sort(this.elements, 0, this.size);
        for (int i = 0; i < this.size / 2; ++i) {
            int temp = this.elements[i];
            this.elements[i] = this.elements[this.size - i - 1];
            this.elements[this.size - i - 1] = temp;
        }
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    private void ensure(int newSize) {
        if (newSize >= this.elements.length) {
            int[] newArray = new int[Math.max(newSize, this.size * 2)];
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
            this.elements = newArray;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

