/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.collections;

import java.util.Locale;
import org.logicng.collections.LNGDoubleVector;
import org.logicng.collections.LNGIntVector;

public final class LNGDoublePriorityQueue {
    private final LNGIntVector heap = new LNGIntVector();
    private final LNGDoubleVector prior = new LNGDoubleVector();
    private final LNGIntVector pos = new LNGIntVector();

    private static int left(int position) {
        return 2 * position + 1;
    }

    private static int right(int position) {
        return 2 * position + 2;
    }

    private static int parent(int position) {
        assert (position > 0);
        return (position - 1) / 2;
    }

    public boolean empty() {
        return this.heap.empty();
    }

    public int size() {
        return this.heap.size();
    }

    public boolean contains(int element) {
        return element >= 0 && this.imported(element) && this.pos.get(Math.abs(element)) >= 0;
    }

    public double priority(int element) {
        assert (this.imported(element));
        return this.prior.get(Math.abs(element));
    }

    public int top() {
        return this.heap.get(0);
    }

    public void push(int element) {
        if (element < 0) {
            throw new IllegalArgumentException("Cannot add negative integers to the priority queue");
        }
        assert (!this.contains(element));
        this.doImport(element);
        this.pos.set(element, this.heap.size());
        this.heap.push(element);
        assert (this.heap.get(this.pos.get(element)) == element);
        this.up(element);
    }

    public void update(int element, double priority) {
        this.doImport(element);
        double q = this.prior.get(element);
        if (Double.compare(q, priority) == 0) {
            return;
        }
        this.prior.set(element, priority);
        if (this.pos.get(element) < 0) {
            return;
        }
        if (priority < q) {
            this.down(element);
        }
        if (q < priority) {
            this.up(element);
        }
    }

    public void pop(int element) {
        assert (this.contains(element));
        int i = this.pos.get(element);
        this.pos.set(element, -1);
        int last = this.heap.back();
        this.heap.pop();
        int j = this.heap.size();
        if (i == j) {
            return;
        }
        assert (i < j);
        this.pos.set(last, i);
        this.heap.set(i, last);
        this.up(last);
        this.down(last);
    }

    public void pop() {
        this.pop(this.top());
    }

    public void rescore(double factor) {
        for (int i = 0; i < this.prior.size(); ++i) {
            this.prior.set(i, this.prior.get(i) * factor);
        }
    }

    private boolean less(int e1, int e2) {
        return this.prior.get(e1) < this.prior.get(e2);
    }

    private void up(int element) {
        int ppos;
        int p;
        int epos = this.pos.get(element);
        while (epos > 0 && this.less(p = this.heap.get(ppos = LNGDoublePriorityQueue.parent(epos)), element)) {
            this.heap.set(epos, p);
            this.heap.set(ppos, element);
            this.pos.set(p, epos);
            epos = ppos;
        }
        this.pos.set(element, epos);
    }

    private void down(int element) {
        int cpos;
        assert (this.contains(element));
        int epos = this.pos.get(element);
        int size = this.heap.size();
        while ((cpos = LNGDoublePriorityQueue.left(epos)) < size) {
            int o;
            int c = this.heap.get(cpos);
            int opos = LNGDoublePriorityQueue.right(epos);
            if (!this.less(element, c)) {
                if (opos >= size || !this.less(element, o = this.heap.get(opos))) break;
                cpos = opos;
                c = o;
            } else if (opos < size && !this.less(o = this.heap.get(opos), c)) {
                cpos = opos;
                c = o;
            }
            this.heap.set(cpos, element);
            this.heap.set(epos, c);
            this.pos.set(c, epos);
            epos = cpos;
        }
        this.pos.set(element, epos);
    }

    private boolean imported(int element) {
        assert (0 <= element);
        return element < this.pos.size();
    }

    private void doImport(int element) {
        while (!this.imported(element)) {
            this.pos.push(-1);
            this.prior.push(0.0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LNGDoublePriorityQueue{");
        for (int i = 0; i < this.heap.size(); ++i) {
            sb.append(String.format(Locale.ENGLISH, "<elem=%d, pos=%d, prio=%f>", this.heap.get(i), this.pos.get(i), this.prior.get(i)));
            if (i == this.heap.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

