/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.collections;

import java.util.Arrays;

public final class LNGBooleanVector {
    private boolean[] elements;
    private int size;

    public LNGBooleanVector() {
        this(5);
    }

    public LNGBooleanVector(int size) {
        this.elements = new boolean[size];
    }

    public LNGBooleanVector(int size, boolean pad) {
        this.elements = new boolean[size];
        Arrays.fill(this.elements, pad);
        this.size = size;
    }

    public LNGBooleanVector(LNGBooleanVector other) {
        this.elements = Arrays.copyOf(other.elements, other.size);
        this.size = other.size;
    }

    public LNGBooleanVector(boolean ... elems) {
        this.elements = Arrays.copyOf(elems, elems.length);
        this.size = elems.length;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean back() {
        return this.elements[this.size - 1];
    }

    public void push(boolean element) {
        int newSize = this.size + 1;
        this.ensure(newSize);
        this.elements[this.size++] = element;
    }

    public void unsafePush(boolean element) {
        this.elements[this.size++] = element;
    }

    public boolean get(int position) {
        return this.elements[position];
    }

    public void set(int position, boolean element) {
        this.elements[position] = element;
    }

    public void pop() {
        this.elements[--this.size] = false;
    }

    public void shrinkTo(int newSize) {
        if (newSize < this.size) {
            this.size = newSize;
        }
    }

    public void growTo(int size, boolean pad) {
        if (this.size >= size) {
            return;
        }
        this.ensure(size);
        for (int i = this.size; i < size; ++i) {
            this.elements[i] = pad;
        }
        this.size = size;
    }

    public void removeElements(int num) {
        int count = num;
        while (count-- > 0) {
            this.elements[--this.size] = false;
        }
    }

    public void reverseInplace() {
        for (int i = 0; i < this.size / 2; ++i) {
            boolean temp = this.elements[i];
            this.elements[i] = this.elements[this.size - i - 1];
            this.elements[this.size() - i - 1] = temp;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    private void ensure(int newSize) {
        if (newSize >= this.elements.length) {
            boolean[] newArray = new boolean[Math.max(newSize, this.size * 2)];
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
            this.elements = newArray;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

