/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Variable;

public final class CCTotalizer {
    private LNGVector<Variable> cardinalityInvars;
    private EncodingResult result;
    private CCIncrementalData incData;

    CCTotalizer() {
    }

    void buildAMK(EncodingResult result, Variable[] vars, int rhs) {
        LNGVector<Variable> cardinalityOutvars = this.initializeConstraint(result, vars);
        this.incData = new CCIncrementalData(result, CCConfig.AMK_ENCODER.TOTALIZER, rhs, cardinalityOutvars);
        this.toCNF(cardinalityOutvars, rhs, Bound.UPPER);
        assert (this.cardinalityInvars.size() == 0);
        for (int i = rhs; i < cardinalityOutvars.size(); ++i) {
            this.result.addClause(cardinalityOutvars.get(i).negate());
        }
    }

    void buildALK(EncodingResult result, Variable[] vars, int rhs) {
        LNGVector<Variable> cardinalityOutvars = this.initializeConstraint(result, vars);
        this.incData = new CCIncrementalData(result, CCConfig.ALK_ENCODER.TOTALIZER, rhs, vars.length, cardinalityOutvars);
        this.toCNF(cardinalityOutvars, rhs, Bound.LOWER);
        assert (this.cardinalityInvars.size() == 0);
        for (int i = 0; i < rhs; ++i) {
            this.result.addClause(cardinalityOutvars.get(i));
        }
    }

    void buildEXK(EncodingResult result, Variable[] vars, int rhs) {
        int i;
        LNGVector<Variable> cardinalityOutvars = this.initializeConstraint(result, vars);
        this.toCNF(cardinalityOutvars, rhs, Bound.BOTH);
        assert (this.cardinalityInvars.size() == 0);
        for (i = 0; i < rhs; ++i) {
            this.result.addClause(cardinalityOutvars.get(i));
        }
        for (i = rhs; i < cardinalityOutvars.size(); ++i) {
            this.result.addClause(cardinalityOutvars.get(i).negate());
        }
    }

    private LNGVector<Variable> initializeConstraint(EncodingResult result, Variable[] vars) {
        result.reset();
        this.result = result;
        this.cardinalityInvars = new LNGVector(vars.length);
        LNGVector<Variable> cardinalityOutvars = new LNGVector<Variable>(vars.length);
        for (Variable var : vars) {
            this.cardinalityInvars.push(var);
            cardinalityOutvars.push(this.result.newVariable());
        }
        return cardinalityOutvars;
    }

    CCIncrementalData incrementalData() {
        return this.incData;
    }

    private void toCNF(LNGVector<Variable> vars, int rhs, Bound bound) {
        LNGVector<Variable> left = new LNGVector<Variable>();
        LNGVector<Variable> right = new LNGVector<Variable>();
        assert (vars.size() > 1);
        int split = vars.size() / 2;
        for (int i = 0; i < vars.size(); ++i) {
            if (i < split) {
                if (split == 1) {
                    assert (this.cardinalityInvars.size() > 0);
                    left.push(this.cardinalityInvars.back());
                    this.cardinalityInvars.pop();
                    continue;
                }
                left.push(this.result.newVariable());
                continue;
            }
            if (vars.size() - split == 1) {
                assert (this.cardinalityInvars.size() > 0);
                right.push(this.cardinalityInvars.back());
                this.cardinalityInvars.pop();
                continue;
            }
            right.push(this.result.newVariable());
        }
        if (bound == Bound.UPPER || bound == Bound.BOTH) {
            this.adderAMK(left, right, vars, rhs);
        }
        if (bound == Bound.LOWER || bound == Bound.BOTH) {
            this.adderALK(left, right, vars);
        }
        if (left.size() > 1) {
            this.toCNF(left, rhs, bound);
        }
        if (right.size() > 1) {
            this.toCNF(right, rhs, bound);
        }
    }

    private void adderAMK(LNGVector<Variable> left, LNGVector<Variable> right, LNGVector<Variable> output, int rhs) {
        assert (output.size() == left.size() + right.size());
        for (int i = 0; i <= left.size(); ++i) {
            for (int j = 0; j <= right.size(); ++j) {
                if (i == 0 && j == 0 || i + j > rhs + 1) continue;
                if (i == 0) {
                    this.result.addClause(right.get(j - 1).negate(), output.get(j - 1));
                    continue;
                }
                if (j == 0) {
                    this.result.addClause(left.get(i - 1).negate(), output.get(i - 1));
                    continue;
                }
                this.result.addClause(left.get(i - 1).negate(), right.get(j - 1).negate(), output.get(i + j - 1));
            }
        }
    }

    private void adderALK(LNGVector<Variable> left, LNGVector<Variable> right, LNGVector<Variable> output) {
        assert (output.size() == left.size() + right.size());
        for (int i = 0; i <= left.size(); ++i) {
            for (int j = 0; j <= right.size(); ++j) {
                if (i == 0 && j == 0) continue;
                if (i == 0) {
                    this.result.addClause(right.get(j - 1), output.get(left.size() + j - 1).negate());
                    continue;
                }
                if (j == 0) {
                    this.result.addClause(left.get(i - 1), output.get(right.size() + i - 1).negate());
                    continue;
                }
                this.result.addClause(left.get(i - 1), right.get(j - 1), output.get(i + j - 2).negate());
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static enum Bound {
        LOWER,
        UPPER,
        BOTH;

    }
}

