/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCSorting {
    private final LNGVector<LNGVector<Literal>> auxVars = new LNGVector();

    private static int counterSorterValue(int m, int n) {
        return 2 * n + (m - 1) * (2 * (n - 1) - 1) - (m - 2) - 2 * ((m - 1) * (m - 2) / 2);
    }

    private static int directSorterValue(int n) {
        if (n > 30) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.pow(2.0, n) - 1;
    }

    public void sort(int m, LNGVector<Literal> input, EncodingResult result, LNGVector<Literal> output, ImplicationDirection direction) {
        int direct;
        assert (m >= 0);
        if (m == 0) {
            output.clear();
            return;
        }
        int m2 = m;
        int n = input.size();
        if (m2 > n) {
            m2 = n;
        }
        if (n == 0) {
            output.clear();
            return;
        }
        if (n == 1) {
            output.clear();
            output.push(input.get(0));
            return;
        }
        if (n == 2) {
            output.clear();
            Variable o1 = result.newVariable();
            if (m2 == 2) {
                Variable o2 = result.newVariable();
                this.comparator(input.get(0), input.get(1), o1, o2, result, direction);
                output.push(o1);
                output.push(o2);
            } else {
                assert (m2 == 1);
                this.comparator(input.get(0), input.get(1), o1, result, direction);
                output.push(o1);
            }
            return;
        }
        if (direction != ImplicationDirection.INPUT_TO_OUTPUT) {
            this.recursiveSorter(m2, input, result, output, direction);
            return;
        }
        int counter = CCSorting.counterSorterValue(m2, n);
        if (counter < (direct = CCSorting.directSorterValue(n))) {
            this.counterSorter(m2, input, result, output, direction);
        } else {
            this.directSorter(m2, input, result, output, direction);
        }
    }

    private void comparator(Literal x1, Literal x2, Literal y, EncodingResult result, ImplicationDirection direction) {
        assert (!x1.equals(x2));
        if (direction == ImplicationDirection.INPUT_TO_OUTPUT || direction == ImplicationDirection.BOTH) {
            result.addClause(x1.negate(), y);
            result.addClause(x2.negate(), y);
        }
        if (direction == ImplicationDirection.OUTPUT_TO_INPUT || direction == ImplicationDirection.BOTH) {
            result.addClause(y.negate(), x1, x2);
        }
    }

    private void comparator(Literal x1, Literal x2, Literal y1, Literal y2, EncodingResult result, ImplicationDirection direction) {
        assert (!x1.equals(x2));
        assert (!y1.equals(y2));
        if (direction == ImplicationDirection.INPUT_TO_OUTPUT || direction == ImplicationDirection.BOTH) {
            result.addClause(x1.negate(), y1);
            result.addClause(x2.negate(), y1);
            result.addClause(x1.negate(), x2.negate(), y2);
        }
        if (direction == ImplicationDirection.OUTPUT_TO_INPUT || direction == ImplicationDirection.BOTH) {
            result.addClause(y1.negate(), x1, x2);
            result.addClause(y2.negate(), x1);
            result.addClause(y2.negate(), x2);
        }
    }

    private void recursiveSorter(int m, int l, LNGVector<Literal> input, EncodingResult result, LNGVector<Literal> output, ImplicationDirection direction) {
        int i;
        int n = input.size();
        assert (output.size() == 0);
        assert (n > 1);
        assert (m <= n);
        LNGVector<Literal> tmpLitsA = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsB = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsO1 = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsO2 = new LNGVector<Literal>();
        for (i = 0; i < l; ++i) {
            tmpLitsA.push(input.get(i));
        }
        for (i = l; i < n; ++i) {
            tmpLitsB.push(input.get(i));
        }
        assert (tmpLitsA.size() + tmpLitsB.size() == n);
        this.sort(m, tmpLitsA, result, tmpLitsO1, direction);
        this.sort(m, tmpLitsB, result, tmpLitsO2, direction);
        this.merge(m, tmpLitsO1, tmpLitsO2, result, output, direction);
        assert (tmpLitsO1.size() == Math.min(l, m));
        assert (tmpLitsO2.size() == Math.min(n - l, m));
        assert (output.size() == m);
    }

    private void recursiveSorter(int m, LNGVector<Literal> input, EncodingResult result, LNGVector<Literal> output, ImplicationDirection direction) {
        assert (m > 0);
        assert (input.size() > 0);
        output.clear();
        int n = input.size();
        assert (n > 1);
        int l = n / 2;
        this.recursiveSorter(m, l, input, result, output, direction);
    }

    private void counterSorter(int k, LNGVector<Literal> x, EncodingResult formula, LNGVector<Literal> output, ImplicationDirection direction) {
        int i;
        int j;
        int i2;
        int n = x.size();
        this.auxVars.clear();
        for (i2 = 0; i2 < n; ++i2) {
            this.auxVars.push(new LNGVector(k));
        }
        for (j = 0; j < k; ++j) {
            for (i = j; i < n; ++i) {
                this.auxVars.get(i).set(j, formula.newVariable());
            }
        }
        if (direction == ImplicationDirection.INPUT_TO_OUTPUT || direction == ImplicationDirection.BOTH) {
            for (i2 = 0; i2 < n; ++i2) {
                formula.addClause(x.get(i2).negate(), this.auxVars.get(i2).get(0));
                if (i2 <= 0) continue;
                formula.addClause(this.auxVars.get(i2 - 1).get(0).negate(), this.auxVars.get(i2).get(0));
            }
            for (j = 1; j < k; ++j) {
                for (i = j; i < n; ++i) {
                    formula.addClause(x.get(i).negate(), this.auxVars.get(i - 1).get(j - 1).negate(), this.auxVars.get(i).get(j));
                    if (i <= j) continue;
                    formula.addClause(this.auxVars.get(i - 1).get(j).negate(), this.auxVars.get(i).get(j));
                }
            }
        }
        assert (direction == ImplicationDirection.INPUT_TO_OUTPUT);
        output.clear();
        for (i2 = 0; i2 < k; ++i2) {
            output.push(this.auxVars.get(n - 1).get(i2));
        }
    }

    private void directSorter(int m, LNGVector<Literal> input, EncodingResult formula, LNGVector<Literal> output, ImplicationDirection direction) {
        assert (direction == ImplicationDirection.INPUT_TO_OUTPUT);
        int n = input.size();
        assert (n < 20);
        int bitmask = 1;
        LNGVector<Literal> clause = new LNGVector<Literal>();
        output.clear();
        for (int i = 0; i < m; ++i) {
            output.push(formula.newVariable());
        }
        while ((double)bitmask < Math.pow(2.0, n)) {
            int count = 0;
            clause.clear();
            for (int i = 0; i < n; ++i) {
                if ((1 << i & bitmask) == 0) continue;
                if (++count > m) break;
                clause.push(input.get(i).negate());
            }
            assert (count > 0);
            if (count <= m) {
                clause.push(output.get(count - 1));
                formula.addClause(clause);
            }
            ++bitmask;
        }
    }

    public void merge(int m, LNGVector<Literal> inputA, LNGVector<Literal> inputB, EncodingResult formula, LNGVector<Literal> output, ImplicationDirection direction) {
        int b;
        assert (m >= 0);
        if (m == 0) {
            output.clear();
            return;
        }
        int m2 = m;
        int a = inputA.size();
        int n = a + (b = inputB.size());
        if (m2 > n) {
            m2 = n;
        }
        if (a == 0 || b == 0) {
            if (a == 0) {
                output.replaceInplace(inputB);
            } else {
                output.replaceInplace(inputA);
            }
            return;
        }
        if (direction != ImplicationDirection.INPUT_TO_OUTPUT) {
            this.recursiveMerger(m2, inputA, inputA.size(), inputB, inputB.size(), formula, output, direction);
            return;
        }
        this.directMerger(m2, inputA, inputB, formula, output, direction);
    }

    private void recursiveMerger(int c, LNGVector<Literal> inputA, int a, LNGVector<Literal> inputB, int b, EncodingResult formula, LNGVector<Literal> output, ImplicationDirection direction) {
        int i;
        assert (inputA.size() > 0);
        assert (inputB.size() > 0);
        assert (c > 0);
        output.clear();
        int a2 = a;
        int b2 = b;
        if (a2 > c) {
            a2 = c;
        }
        if (b2 > c) {
            b2 = c;
        }
        if (c == 1) {
            Variable y = formula.newVariable();
            this.comparator(inputA.get(0), inputB.get(0), y, formula, direction);
            output.push(y);
            return;
        }
        if (a2 == 1 && b2 == 1) {
            assert (c == 2);
            Variable y1 = formula.newVariable();
            Variable y2 = formula.newVariable();
            this.comparator(inputA.get(0), inputB.get(0), y1, y2, formula, direction);
            output.push(y1);
            output.push(y2);
            return;
        }
        LNGVector<Literal> oddMerge = new LNGVector<Literal>();
        LNGVector<Literal> evenMerge = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsOddA = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsOddB = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsEvenA = new LNGVector<Literal>();
        LNGVector<Literal> tmpLitsEvenB = new LNGVector<Literal>();
        for (i = 0; i < a2; i += 2) {
            tmpLitsOddA.push(inputA.get(i));
        }
        for (i = 0; i < b2; i += 2) {
            tmpLitsOddB.push(inputB.get(i));
        }
        for (i = 1; i < a2; i += 2) {
            tmpLitsEvenA.push(inputA.get(i));
        }
        for (i = 1; i < b2; i += 2) {
            tmpLitsEvenB.push(inputB.get(i));
        }
        this.merge(c / 2 + 1, tmpLitsOddA, tmpLitsOddB, formula, oddMerge, direction);
        this.merge(c / 2, tmpLitsEvenA, tmpLitsEvenB, formula, evenMerge, direction);
        assert (oddMerge.size() > 0);
        output.push(oddMerge.get(0));
        i = 1;
        int j = 0;
        while (true) {
            if (i < oddMerge.size() && j < evenMerge.size()) {
                Variable z0;
                if (output.size() + 2 <= c) {
                    z0 = formula.newVariable();
                    Variable z1 = formula.newVariable();
                    this.comparator(oddMerge.get(i), evenMerge.get(j), z0, z1, formula, direction);
                    output.push(z0);
                    output.push(z1);
                    if (output.size() == c) {
                        break;
                    }
                } else if (output.size() + 1 == c) {
                    z0 = formula.newVariable();
                    this.comparator(oddMerge.get(i), evenMerge.get(j), z0, formula, direction);
                    output.push(z0);
                    break;
                }
            } else {
                if (i >= oddMerge.size() && j >= evenMerge.size()) break;
                if (i >= oddMerge.size()) {
                    assert (j == evenMerge.size() - 1);
                    output.push(evenMerge.back());
                    break;
                }
                assert (i == oddMerge.size() - 1);
                output.push(oddMerge.back());
                break;
            }
            ++i;
            ++j;
        }
        assert (output.size() == a2 + b2 || output.size() == c);
    }

    private void directMerger(int m, LNGVector<Literal> inputA, LNGVector<Literal> inputB, EncodingResult formula, LNGVector<Literal> output, ImplicationDirection direction) {
        int i;
        assert (direction == ImplicationDirection.INPUT_TO_OUTPUT);
        int a = inputA.size();
        int b = inputB.size();
        for (int i2 = 0; i2 < m; ++i2) {
            output.push(formula.newVariable());
        }
        int j = Math.min(m, a);
        for (i = 0; i < j; ++i) {
            formula.addClause(inputA.get(i).negate(), output.get(i));
        }
        j = Math.min(m, b);
        for (i = 0; i < j; ++i) {
            formula.addClause(inputB.get(i).negate(), output.get(i));
        }
        for (i = 0; i < a; ++i) {
            for (int k = 0; k < b; ++k) {
                if (i + k + 1 >= m) continue;
                formula.addClause(inputA.get(i).negate(), inputB.get(k).negate(), output.get(i + k + 1));
            }
        }
    }

    public static enum ImplicationDirection {
        INPUT_TO_OUTPUT,
        OUTPUT_TO_INPUT,
        BOTH;

    }
}

