/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCModularTotalizer {
    private final Variable varUndef;
    private final Variable varError;
    private final Variable h0;
    private LNGVector<Literal> inlits;
    private LNGVector<Literal> cardinalityUpOutvars;
    private LNGVector<Literal> cardinalityLwOutvars;
    private int currentCardinalityRhs;
    private EncodingResult result;
    private CCIncrementalData incData;

    CCModularTotalizer(FormulaFactory f) {
        this.varUndef = f.variable("RESERVED@VAR_UNDEF");
        this.varError = f.variable("RESERVED@VAR_ERROR");
        this.h0 = this.varUndef;
        this.currentCardinalityRhs = -1;
        this.inlits = new LNGVector();
    }

    void buildAMK(EncodingResult result, Variable[] vars, int rhs) {
        int mod = this.initialize(result, rhs, vars.length);
        for (Variable var : vars) {
            this.inlits.push(var);
        }
        this.toCNF(mod, this.cardinalityUpOutvars, this.cardinalityLwOutvars, vars.length);
        assert (this.inlits.size() == 0);
        this.encodeOutput(rhs, mod);
        this.currentCardinalityRhs = rhs + 1;
        this.incData = new CCIncrementalData(result, CCConfig.AMK_ENCODER.MODULAR_TOTALIZER, rhs, this.cardinalityUpOutvars, this.cardinalityLwOutvars, mod);
    }

    void buildALK(EncodingResult result, Variable[] vars, int rhs) {
        int newRHS = vars.length - rhs;
        int mod = this.initialize(result, newRHS, vars.length);
        for (Variable var : vars) {
            this.inlits.push(var.negate());
        }
        this.toCNF(mod, this.cardinalityUpOutvars, this.cardinalityLwOutvars, vars.length);
        assert (this.inlits.size() == 0);
        this.encodeOutput(newRHS, mod);
        this.currentCardinalityRhs = newRHS + 1;
        this.incData = new CCIncrementalData(result, CCConfig.ALK_ENCODER.MODULAR_TOTALIZER, rhs, vars.length, this.cardinalityUpOutvars, this.cardinalityLwOutvars, mod);
    }

    CCIncrementalData incrementalData() {
        return this.incData;
    }

    private int initialize(EncodingResult result, int rhs, int n) {
        int i;
        result.reset();
        this.result = result;
        this.cardinalityUpOutvars = new LNGVector();
        this.cardinalityLwOutvars = new LNGVector();
        int mod = (int)Math.ceil(Math.sqrt((double)rhs + 1.0));
        this.cardinalityUpOutvars = new LNGVector(n / mod);
        for (i = 0; i < n / mod; ++i) {
            this.cardinalityUpOutvars.push(this.result.newVariable());
        }
        this.cardinalityLwOutvars = new LNGVector(mod - 1);
        for (i = 0; i < mod - 1; ++i) {
            this.cardinalityLwOutvars.push(this.result.newVariable());
        }
        this.inlits = new LNGVector(n);
        this.currentCardinalityRhs = rhs + 1;
        if (this.cardinalityUpOutvars.size() == 0) {
            this.cardinalityUpOutvars.push(this.h0);
        }
        return mod;
    }

    private void encodeOutput(int rhs, int mod) {
        int i;
        assert (this.cardinalityUpOutvars.size() != 0 || this.cardinalityLwOutvars.size() != 0);
        int ulimit = (rhs + 1) / mod;
        int llimit = rhs + 1 - ulimit * mod;
        assert (ulimit <= this.cardinalityUpOutvars.size());
        assert (llimit <= this.cardinalityLwOutvars.size());
        for (i = ulimit; i < this.cardinalityUpOutvars.size(); ++i) {
            this.result.addClause(this.cardinalityUpOutvars.get(i).negate());
        }
        if (ulimit != 0 && llimit != 0) {
            for (i = llimit - 1; i < this.cardinalityLwOutvars.size(); ++i) {
                this.result.addClause(this.cardinalityUpOutvars.get(ulimit - 1).negate(), this.cardinalityLwOutvars.get(i).negate());
            }
        } else if (ulimit == 0) {
            assert (llimit != 0);
            for (i = llimit - 1; i < this.cardinalityLwOutvars.size(); ++i) {
                this.result.addClause(this.cardinalityLwOutvars.get(i).negate());
            }
        } else {
            this.result.addClause(this.cardinalityUpOutvars.get(ulimit - 1).negate());
        }
    }

    private void toCNF(int mod, LNGVector<Literal> ubvars, LNGVector<Literal> lwvars, int rhs) {
        int i;
        int limit;
        int i2;
        LNGVector<Literal> lupper = new LNGVector<Literal>();
        LNGVector<Literal> llower = new LNGVector<Literal>();
        LNGVector<Literal> rupper = new LNGVector<Literal>();
        LNGVector<Literal> rlower = new LNGVector<Literal>();
        assert (rhs > 1);
        int split = rhs / 2;
        int left = 1;
        int right = 1;
        if (split == 1) {
            assert (this.inlits.size() > 0);
            lupper.push(this.h0);
            llower.push(this.inlits.back());
            this.inlits.pop();
        } else {
            left = split / mod;
            for (i2 = 0; i2 < left; ++i2) {
                lupper.push(this.result.newVariable());
            }
            limit = mod - 1;
            if (left % mod == 0 && split < mod - 1) {
                limit = split;
            }
            for (i = 0; i < limit; ++i) {
                llower.push(this.result.newVariable());
            }
        }
        if (rhs - split == 1) {
            assert (this.inlits.size() > 0);
            rupper.push(this.h0);
            rlower.push(this.inlits.back());
            this.inlits.pop();
        } else {
            right = (rhs - split) / mod;
            for (i2 = 0; i2 < right; ++i2) {
                rupper.push(this.result.newVariable());
            }
            limit = mod - 1;
            if (right % mod == 0 && rhs - split < mod - 1) {
                limit = rhs - split;
            }
            for (i = 0; i < limit; ++i) {
                rlower.push(this.result.newVariable());
            }
        }
        if (lupper.size() == 0) {
            lupper.push(this.h0);
        }
        if (rupper.size() == 0) {
            rupper.push(this.h0);
        }
        this.adder(mod, ubvars, lwvars, rupper, rlower, lupper, llower);
        int val = left * mod + split - left * mod;
        if (val > 1) {
            this.toCNF(mod, lupper, llower, val);
        }
        if ((val = right * mod + (rhs - split) - right * mod) > 1) {
            this.toCNF(mod, rupper, rlower, val);
        }
    }

    private void adder(int mod, LNGVector<Literal> upper, LNGVector<Literal> lower, LNGVector<Literal> lupper, LNGVector<Literal> llower, LNGVector<Literal> rupper, LNGVector<Literal> rlower) {
        assert (upper.size() != 0);
        assert (lower.size() >= llower.size() && lower.size() >= rlower.size());
        Variable carry = this.varUndef;
        if (upper.get(0) != this.h0) {
            carry = this.result.newVariable();
        }
        for (int i = 0; i <= llower.size(); ++i) {
            for (int j = 0; j <= rlower.size(); ++j) {
                if (i + j > this.currentCardinalityRhs + 1 && this.currentCardinalityRhs + 1 < mod) continue;
                if (i + j < mod) {
                    if (i == 0 && j != 0) {
                        if (upper.get(0) != this.h0) {
                            this.result.addClause(rlower.get(j - 1).negate(), lower.get(i + j - 1), carry);
                            continue;
                        }
                        this.result.addClause(rlower.get(j - 1).negate(), lower.get(i + j - 1));
                        continue;
                    }
                    if (j == 0 && i != 0) {
                        if (upper.get(0) != this.h0) {
                            this.result.addClause(llower.get(i - 1).negate(), lower.get(i + j - 1), carry);
                            continue;
                        }
                        this.result.addClause(llower.get(i - 1).negate(), lower.get(i + j - 1));
                        continue;
                    }
                    if (i == 0) continue;
                    if (upper.get(0) != this.h0) {
                        this.result.addClause(llower.get(i - 1).negate(), rlower.get(j - 1).negate(), lower.get(i + j - 1), carry);
                        continue;
                    }
                    assert (i + j - 1 < lower.size());
                    this.result.addClause(llower.get(i - 1).negate(), rlower.get(j - 1).negate(), lower.get(i + j - 1));
                    continue;
                }
                if (i + j > mod) {
                    assert (i + j > 0);
                    this.result.addClause(llower.get(i - 1).negate(), rlower.get(j - 1).negate(), lower.get((i + j) % mod - 1));
                    continue;
                }
                assert (i + j == mod);
                assert (carry != this.varUndef);
                this.result.addClause(llower.get(i - 1).negate(), rlower.get(j - 1).negate(), carry);
            }
        }
        if (upper.get(0) != this.h0) {
            this.finalAdder(mod, upper, lupper, rupper, carry);
        }
    }

    private void finalAdder(int mod, LNGVector<Literal> upper, LNGVector<Literal> lupper, LNGVector<Literal> rupper, Variable carry) {
        for (int i = 0; i <= lupper.size(); ++i) {
            for (int j = 0; j <= rupper.size(); ++j) {
                LNGVector<Literal> clause;
                Literal a = this.varError;
                Literal b = this.varError;
                Literal c = this.varError;
                Literal d = this.varError;
                int closeMod = this.currentCardinalityRhs / mod;
                if (this.currentCardinalityRhs % mod != 0) {
                    ++closeMod;
                }
                if (mod * (i + j) > closeMod * mod) continue;
                if (i != 0) {
                    a = lupper.get(i - 1);
                }
                if (j != 0) {
                    b = rupper.get(j - 1);
                }
                if (i + j != 0 && i + j - 1 < upper.size()) {
                    c = upper.get(i + j - 1);
                }
                if (i + j < upper.size()) {
                    d = upper.get(i + j);
                }
                if (c != this.varUndef && c != this.varError) {
                    clause = new LNGVector();
                    if (a != this.varUndef && a != this.varError) {
                        clause.push(a.negate());
                    }
                    if (b != this.varUndef && b != this.varError) {
                        clause.push(b.negate());
                    }
                    clause.push(c);
                    if (clause.size() > 1) {
                        this.result.addClause(clause);
                    }
                }
                clause = new LNGVector<Literal>();
                clause.push(carry.negate());
                if (a != this.varUndef && a != this.varError) {
                    clause.push(a.negate());
                }
                if (b != this.varUndef && b != this.varError) {
                    clause.push(b.negate());
                }
                if (d != this.varError && d != this.varUndef) {
                    clause.push(d);
                }
                if (clause.size() <= 1) continue;
                this.result.addClause(clause);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

