/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import java.util.List;
import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;

public final class CCIncrementalData {
    private final EncodingResult result;
    private final CCConfig.AMK_ENCODER amkEncoder;
    private final CCConfig.ALK_ENCODER alkEncoder;
    private final LNGVector<? extends Literal> vector1;
    private final LNGVector<? extends Literal> vector2;
    private final int mod;
    private int nVars;
    private int currentRHS;

    CCIncrementalData(EncodingResult result, CCConfig.AMK_ENCODER amkEncoder, int rhs, LNGVector<? extends Literal> vector1, LNGVector<? extends Literal> vector2, int mod) {
        this.result = result;
        this.amkEncoder = amkEncoder;
        this.alkEncoder = null;
        this.currentRHS = rhs;
        this.vector1 = vector1;
        this.vector2 = vector2;
        this.mod = mod;
    }

    CCIncrementalData(EncodingResult result, CCConfig.AMK_ENCODER encoder, int rhs, LNGVector<? extends Literal> vector1) {
        this(result, encoder, rhs, vector1, null, -1);
    }

    CCIncrementalData(EncodingResult result, CCConfig.ALK_ENCODER alkEncoder, int rhs, int nVars, LNGVector<? extends Literal> vector1, LNGVector<? extends Literal> vector2, int mod) {
        this.result = result;
        this.alkEncoder = alkEncoder;
        this.amkEncoder = null;
        this.currentRHS = rhs;
        this.nVars = nVars;
        this.vector1 = vector1;
        this.vector2 = vector2;
        this.mod = mod;
    }

    CCIncrementalData(EncodingResult result, CCConfig.ALK_ENCODER alkEncoder, int rhs, int nVars, LNGVector<? extends Literal> vector1) {
        this(result, alkEncoder, rhs, nVars, vector1, null, -1);
    }

    public List<Formula> newUpperBound(int rhs) {
        this.result.reset();
        this.computeUBConstraint(this.result, rhs);
        return this.result.result();
    }

    public void newUpperBoundForSolver(int rhs) {
        this.computeUBConstraint(this.result, rhs);
    }

    private void computeUBConstraint(EncodingResult result, int rhs) {
        if (rhs >= this.currentRHS) {
            throw new IllegalArgumentException("New upper bound " + rhs + " + does not tighten the current bound of " + this.currentRHS);
        }
        this.currentRHS = rhs;
        if (this.amkEncoder == null) {
            throw new IllegalStateException("Cannot encode a new upper bound for an at-most-k constraint");
        }
        switch (this.amkEncoder) {
            case MODULAR_TOTALIZER: {
                int i;
                assert (this.vector1.size() != 0 || this.vector2.size() != 0);
                int ulimit = (rhs + 1) / this.mod;
                int llimit = rhs + 1 - ulimit * this.mod;
                assert (ulimit <= this.vector1.size());
                assert (llimit <= this.vector2.size());
                for (i = ulimit; i < this.vector1.size(); ++i) {
                    result.addClause(this.vector1.get(i).negate());
                }
                if (ulimit != 0 && llimit != 0) {
                    for (i = llimit - 1; i < this.vector2.size(); ++i) {
                        result.addClause(this.vector1.get(ulimit - 1).negate(), this.vector2.get(i).negate());
                    }
                    break;
                }
                if (ulimit == 0) {
                    assert (llimit != 0);
                    for (i = llimit - 1; i < this.vector2.size(); ++i) {
                        result.addClause(this.vector2.get(i).negate());
                    }
                    break;
                }
                result.addClause(this.vector1.get(ulimit - 1).negate());
                break;
            }
            case TOTALIZER: {
                for (int i = rhs; i < this.vector1.size(); ++i) {
                    result.addClause(this.vector1.get(i).negate());
                }
                break;
            }
            case CARDINALITY_NETWORK: {
                if (this.vector1.size() <= rhs) break;
                result.addClause(this.vector1.get(rhs).negate());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown at-most-k encoder: " + (Object)((Object)this.amkEncoder));
            }
        }
    }

    public List<Formula> newLowerBound(int rhs) {
        this.result.reset();
        this.computeLBConstraint(this.result, rhs);
        return this.result.result();
    }

    public void newLowerBoundForSolver(int rhs) {
        this.computeLBConstraint(this.result, rhs);
    }

    private void computeLBConstraint(EncodingResult result, int rhs) {
        if (rhs <= this.currentRHS) {
            throw new IllegalArgumentException("New lower bound " + rhs + " + does not tighten the current bound of " + this.currentRHS);
        }
        this.currentRHS = rhs;
        if (this.alkEncoder == null) {
            throw new IllegalStateException("Cannot encode a new lower bound for an at-least-k constraint");
        }
        switch (this.alkEncoder) {
            case TOTALIZER: {
                for (int i = 0; i < rhs; ++i) {
                    result.addClause(this.vector1.get(i));
                }
                break;
            }
            case MODULAR_TOTALIZER: {
                int i;
                int newRHS = this.nVars - rhs;
                assert (this.vector1.size() != 0 || this.vector2.size() != 0);
                int ulimit = (newRHS + 1) / this.mod;
                int llimit = newRHS + 1 - ulimit * this.mod;
                assert (ulimit <= this.vector1.size());
                assert (llimit <= this.vector2.size());
                for (i = ulimit; i < this.vector1.size(); ++i) {
                    result.addClause(this.vector1.get(i).negate());
                }
                if (ulimit != 0 && llimit != 0) {
                    for (i = llimit - 1; i < this.vector2.size(); ++i) {
                        result.addClause(this.vector1.get(ulimit - 1).negate(), this.vector2.get(i).negate());
                    }
                    break;
                }
                if (ulimit == 0) {
                    assert (llimit != 0);
                    for (i = llimit - 1; i < this.vector2.size(); ++i) {
                        result.addClause(this.vector2.get(i).negate());
                    }
                    break;
                }
                result.addClause(this.vector1.get(ulimit - 1).negate());
                break;
            }
            case CARDINALITY_NETWORK: {
                int newRHS = this.nVars - rhs;
                if (this.vector1.size() <= newRHS) break;
                result.addClause(this.vector1.get(newRHS).negate());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown at-least-k encoder: " + (Object)((Object)this.alkEncoder));
            }
        }
    }

    public int currentRHS() {
        return this.currentRHS;
    }

    public String toString() {
        return "CCIncrementalData{, amkEncoder=" + (Object)((Object)this.amkEncoder) + ", alkEncoder=" + (Object)((Object)this.alkEncoder) + ", vector1=" + this.vector1 + ", vector2=" + this.vector2 + ", mod=" + this.mod + ", currentRHS=" + this.currentRHS + '}';
    }
}

