/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import java.util.Collections;
import java.util.List;
import org.logicng.cardinalityconstraints.CCALKCardinalityNetwork;
import org.logicng.cardinalityconstraints.CCALKModularTotalizer;
import org.logicng.cardinalityconstraints.CCALKTotalizer;
import org.logicng.cardinalityconstraints.CCAMKCardinalityNetwork;
import org.logicng.cardinalityconstraints.CCAMKModularTotalizer;
import org.logicng.cardinalityconstraints.CCAMKTotalizer;
import org.logicng.cardinalityconstraints.CCAMOBimander;
import org.logicng.cardinalityconstraints.CCAMOBinary;
import org.logicng.cardinalityconstraints.CCAMOCommander;
import org.logicng.cardinalityconstraints.CCAMOLadder;
import org.logicng.cardinalityconstraints.CCAMONested;
import org.logicng.cardinalityconstraints.CCAMOProduct;
import org.logicng.cardinalityconstraints.CCAMOPure;
import org.logicng.cardinalityconstraints.CCAtLeastK;
import org.logicng.cardinalityconstraints.CCAtMostK;
import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.cardinalityconstraints.CCEXKCardinalityNetwork;
import org.logicng.cardinalityconstraints.CCEXKTotalizer;
import org.logicng.cardinalityconstraints.CCExactlyK;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.util.FormulaHelper;
import org.logicng.util.Pair;

public class CCEncoder {
    protected final FormulaFactory f;
    protected final CCConfig config;
    protected final CCConfig defaultConfig;
    protected CCAMOPure amoPure;
    protected CCAMOLadder amoLadder;
    protected CCAMOProduct amoProduct;
    protected CCAMONested amoNested;
    protected CCAMOCommander amoCommander;
    protected CCAMOBinary amoBinary;
    protected CCAMOBimander amoBimander;
    protected CCAMKCardinalityNetwork amkCardinalityNetwork;
    protected CCAMKModularTotalizer amkModularTotalizer;
    protected CCAMKTotalizer amkTotalizer;
    protected CCALKTotalizer alkTotalizer;
    protected CCALKModularTotalizer alkModularTotalizer;
    protected CCALKCardinalityNetwork alkCardinalityNetwork;
    protected CCEXKTotalizer exkTotalizer;
    protected CCEXKCardinalityNetwork exkCardinalityNetwork;

    public CCEncoder(FormulaFactory f, CCConfig config) {
        this.f = f;
        this.config = config;
        this.defaultConfig = CCConfig.builder().build();
    }

    public CCEncoder(FormulaFactory f) {
        this(f, null);
    }

    public List<Formula> encode(CardinalityConstraint cc) {
        EncodingResult result = EncodingResult.resultForFormula(this.f);
        this.encodeConstraint(cc, result);
        return Collections.unmodifiableList(result.result());
    }

    public void encode(CardinalityConstraint cc, EncodingResult result) {
        this.encodeConstraint(cc, result);
    }

    public Pair<List<Formula>, CCIncrementalData> encodeIncremental(CardinalityConstraint cc) {
        EncodingResult result = EncodingResult.resultForFormula(this.f);
        CCIncrementalData incData = this.encodeIncremental(cc, result);
        return new Pair<List<Formula>, CCIncrementalData>(Collections.unmodifiableList(result.result()), incData);
    }

    public CCIncrementalData encodeIncremental(CardinalityConstraint cc, EncodingResult result) {
        return this.encodeIncrementalConstraint(cc, result);
    }

    protected CCIncrementalData encodeIncrementalConstraint(CardinalityConstraint cc, EncodingResult result) {
        Variable[] ops = FormulaHelper.literalsAsVariables(cc.operands());
        if (cc.isAmo()) {
            throw new IllegalArgumentException("Incremental encodings are not supported for at-most-one constraints");
        }
        switch (cc.comparator()) {
            case LE: {
                return this.amkIncremental(result, ops, cc.rhs());
            }
            case LT: {
                return this.amkIncremental(result, ops, cc.rhs() - 1);
            }
            case GE: {
                return this.alkIncremental(result, ops, cc.rhs());
            }
            case GT: {
                return this.alkIncremental(result, ops, cc.rhs() + 1);
            }
        }
        throw new IllegalArgumentException("Incremental encodings are only supported for at-most-k and at-least k constraints.");
    }

    public CCConfig config() {
        if (this.config != null) {
            return this.config;
        }
        Configuration ccConfig = this.f.configurationFor(ConfigurationType.CC_ENCODER);
        return ccConfig != null ? (CCConfig)ccConfig : this.defaultConfig;
    }

    protected void encodeConstraint(CardinalityConstraint cc, EncodingResult result) {
        Variable[] ops = FormulaHelper.literalsAsVariables(cc.operands());
        switch (cc.comparator()) {
            case LE: {
                if (cc.rhs() == 1) {
                    this.amo(result, ops);
                    break;
                }
                this.amk(result, ops, cc.rhs());
                break;
            }
            case LT: {
                if (cc.rhs() == 2) {
                    this.amo(result, ops);
                    break;
                }
                this.amk(result, ops, cc.rhs() - 1);
                break;
            }
            case GE: {
                this.alk(result, ops, cc.rhs());
                break;
            }
            case GT: {
                this.alk(result, ops, cc.rhs() + 1);
                break;
            }
            case EQ: {
                if (cc.rhs() == 1) {
                    this.exo(result, ops);
                    break;
                }
                this.exk(result, ops, cc.rhs());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown pseudo-Boolean comparator: " + (Object)((Object)cc.comparator()));
            }
        }
    }

    protected void amo(EncodingResult result, Variable ... vars) {
        if (vars.length <= 1) {
            return;
        }
        switch (this.config().amoEncoder) {
            case PURE: {
                if (this.amoPure == null) {
                    this.amoPure = new CCAMOPure();
                }
                this.amoPure.build(result, vars);
                break;
            }
            case LADDER: {
                if (this.amoLadder == null) {
                    this.amoLadder = new CCAMOLadder();
                }
                this.amoLadder.build(result, vars);
                break;
            }
            case PRODUCT: {
                if (this.amoProduct == null) {
                    this.amoProduct = new CCAMOProduct(this.config().productRecursiveBound);
                }
                this.amoProduct.build(result, vars);
                break;
            }
            case NESTED: {
                if (this.amoNested == null) {
                    this.amoNested = new CCAMONested(this.config().nestingGroupSize);
                }
                this.amoNested.build(result, vars);
                break;
            }
            case COMMANDER: {
                if (this.amoCommander == null) {
                    this.amoCommander = new CCAMOCommander(this.config().commanderGroupSize);
                }
                this.amoCommander.build(result, vars);
                break;
            }
            case BINARY: {
                if (this.amoBinary == null) {
                    this.amoBinary = new CCAMOBinary();
                }
                this.amoBinary.build(result, vars);
                break;
            }
            case BIMANDER: {
                if (this.config().bimanderGroupSize != CCConfig.BIMANDER_GROUP_SIZE.FIXED || this.amoBimander == null) {
                    int groupSize;
                    switch (this.config().bimanderGroupSize) {
                        case FIXED: {
                            groupSize = this.config().bimanderFixedGroupSize;
                            break;
                        }
                        case HALF: {
                            groupSize = vars.length / 2;
                            break;
                        }
                        case SQRT: {
                            groupSize = (int)Math.sqrt(vars.length);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown bimander group size: " + (Object)((Object)this.config().bimanderGroupSize));
                        }
                    }
                    this.amoBimander = new CCAMOBimander(groupSize);
                }
                this.amoBimander.build(result, vars);
                break;
            }
            case BEST: {
                this.bestAMO(vars.length).build(result, vars);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown at-most-one encoder: " + (Object)((Object)this.config().amoEncoder));
            }
        }
    }

    protected void exo(EncodingResult result, Variable ... vars) {
        if (vars.length == 0) {
            result.addClause(new Literal[0]);
            return;
        }
        if (vars.length == 1) {
            result.addClause(vars[0]);
            return;
        }
        this.amo(result, vars);
        result.addClause(vars);
    }

    protected void amk(EncodingResult result, Variable[] vars, int rhs) {
        if (rhs < 0) {
            throw new IllegalArgumentException("Invalid right hand side of cardinality constraint: " + rhs);
        }
        if (rhs >= vars.length) {
            return;
        }
        if (rhs == 0) {
            for (Variable var : vars) {
                result.addClause(var.negate());
            }
            return;
        }
        switch (this.config().amkEncoder) {
            case TOTALIZER: {
                if (this.amkTotalizer == null) {
                    this.amkTotalizer = new CCAMKTotalizer();
                }
                this.amkTotalizer.build(result, vars, rhs);
                break;
            }
            case MODULAR_TOTALIZER: {
                if (this.amkModularTotalizer == null) {
                    this.amkModularTotalizer = new CCAMKModularTotalizer(this.f);
                }
                this.amkModularTotalizer.build(result, vars, rhs);
                break;
            }
            case CARDINALITY_NETWORK: {
                if (this.amkCardinalityNetwork == null) {
                    this.amkCardinalityNetwork = new CCAMKCardinalityNetwork();
                }
                this.amkCardinalityNetwork.build(result, vars, rhs);
                break;
            }
            case BEST: {
                this.bestAMK(vars.length).build(result, vars, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown at-most-k encoder: " + (Object)((Object)this.config().amkEncoder));
            }
        }
    }

    protected CCIncrementalData amkIncremental(EncodingResult result, Variable[] vars, int rhs) {
        if (rhs < 0) {
            throw new IllegalArgumentException("Invalid right hand side of cardinality constraint: " + rhs);
        }
        if (rhs >= vars.length) {
            return null;
        }
        if (rhs == 0) {
            for (Variable var : vars) {
                result.addClause(var.negate());
            }
            return null;
        }
        switch (this.config().amkEncoder) {
            case TOTALIZER: {
                if (this.amkTotalizer == null) {
                    this.amkTotalizer = new CCAMKTotalizer();
                }
                this.amkTotalizer.build(result, vars, rhs);
                return this.amkTotalizer.incrementalData();
            }
            case MODULAR_TOTALIZER: {
                if (this.amkModularTotalizer == null) {
                    this.amkModularTotalizer = new CCAMKModularTotalizer(this.f);
                }
                this.amkModularTotalizer.build(result, vars, rhs);
                return this.amkModularTotalizer.incrementalData();
            }
            case CARDINALITY_NETWORK: {
                if (this.amkCardinalityNetwork == null) {
                    this.amkCardinalityNetwork = new CCAMKCardinalityNetwork();
                }
                this.amkCardinalityNetwork.buildForIncremental(result, vars, rhs);
                return this.amkCardinalityNetwork.incrementalData();
            }
            case BEST: {
                this.bestAMK(vars.length).build(result, vars, rhs);
                return this.bestAMK(vars.length).incrementalData();
            }
        }
        throw new IllegalStateException("Unknown at-most-k encoder: " + (Object)((Object)this.config().amkEncoder));
    }

    protected void alk(EncodingResult result, Variable[] vars, int rhs) {
        if (rhs < 0) {
            throw new IllegalArgumentException("Invalid right hand side of cardinality constraint: " + rhs);
        }
        if (rhs > vars.length) {
            result.addClause(new Literal[0]);
            return;
        }
        if (rhs == 0) {
            return;
        }
        if (rhs == 1) {
            result.addClause(vars);
            return;
        }
        if (rhs == vars.length) {
            for (Variable var : vars) {
                result.addClause(var);
            }
            return;
        }
        switch (this.config().alkEncoder) {
            case TOTALIZER: {
                if (this.alkTotalizer == null) {
                    this.alkTotalizer = new CCALKTotalizer();
                }
                this.alkTotalizer.build(result, vars, rhs);
                break;
            }
            case MODULAR_TOTALIZER: {
                if (this.alkModularTotalizer == null) {
                    this.alkModularTotalizer = new CCALKModularTotalizer(this.f);
                }
                this.alkModularTotalizer.build(result, vars, rhs);
                break;
            }
            case CARDINALITY_NETWORK: {
                if (this.alkCardinalityNetwork == null) {
                    this.alkCardinalityNetwork = new CCALKCardinalityNetwork();
                }
                this.alkCardinalityNetwork.build(result, vars, rhs);
                break;
            }
            case BEST: {
                this.bestALK(vars.length).build(result, vars, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown at-least-k encoder: " + (Object)((Object)this.config().alkEncoder));
            }
        }
    }

    protected CCIncrementalData alkIncremental(EncodingResult result, Variable[] vars, int rhs) {
        if (rhs < 0) {
            throw new IllegalArgumentException("Invalid right hand side of cardinality constraint: " + rhs);
        }
        if (rhs > vars.length) {
            result.addClause(new Literal[0]);
            return null;
        }
        if (rhs == 0) {
            return null;
        }
        if (rhs == 1) {
            result.addClause(vars);
            return null;
        }
        if (rhs == vars.length) {
            for (Variable var : vars) {
                result.addClause(var);
            }
            return null;
        }
        switch (this.config().alkEncoder) {
            case TOTALIZER: {
                if (this.alkTotalizer == null) {
                    this.alkTotalizer = new CCALKTotalizer();
                }
                this.alkTotalizer.build(result, vars, rhs);
                return this.alkTotalizer.incrementalData();
            }
            case MODULAR_TOTALIZER: {
                if (this.alkModularTotalizer == null) {
                    this.alkModularTotalizer = new CCALKModularTotalizer(this.f);
                }
                this.alkModularTotalizer.build(result, vars, rhs);
                return this.alkModularTotalizer.incrementalData();
            }
            case CARDINALITY_NETWORK: {
                if (this.alkCardinalityNetwork == null) {
                    this.alkCardinalityNetwork = new CCALKCardinalityNetwork();
                }
                this.alkCardinalityNetwork.buildForIncremental(result, vars, rhs);
                return this.alkCardinalityNetwork.incrementalData();
            }
            case BEST: {
                this.bestALK(vars.length).build(result, vars, rhs);
                return this.bestALK(vars.length).incrementalData();
            }
        }
        throw new IllegalStateException("Unknown at-least-k encoder: " + (Object)((Object)this.config().alkEncoder));
    }

    protected void exk(EncodingResult result, Variable[] vars, int rhs) {
        if (rhs < 0) {
            throw new IllegalArgumentException("Invalid right hand side of cardinality constraint: " + rhs);
        }
        if (rhs > vars.length) {
            result.addClause(new Literal[0]);
            return;
        }
        if (rhs == 0) {
            for (Variable var : vars) {
                result.addClause(var.negate());
            }
            return;
        }
        if (rhs == vars.length) {
            for (Variable var : vars) {
                result.addClause(var);
            }
            return;
        }
        switch (this.config().exkEncoder) {
            case TOTALIZER: {
                if (this.exkTotalizer == null) {
                    this.exkTotalizer = new CCEXKTotalizer();
                }
                this.exkTotalizer.build(result, vars, rhs);
                break;
            }
            case CARDINALITY_NETWORK: {
                if (this.exkCardinalityNetwork == null) {
                    this.exkCardinalityNetwork = new CCEXKCardinalityNetwork();
                }
                this.exkCardinalityNetwork.build(result, vars, rhs);
                break;
            }
            case BEST: {
                this.bestEXK(vars.length).build(result, vars, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown exactly-k encoder: " + (Object)((Object)this.config().exkEncoder));
            }
        }
    }

    protected CCAtMostOne bestAMO(int n) {
        if (n <= 10) {
            if (this.amoPure == null) {
                this.amoPure = new CCAMOPure();
            }
            return this.amoPure;
        }
        if (this.amoProduct == null) {
            this.amoProduct = new CCAMOProduct(this.config().productRecursiveBound);
        }
        return this.amoProduct;
    }

    protected CCAtMostK bestAMK(int n) {
        if (this.amkModularTotalizer == null) {
            this.amkModularTotalizer = new CCAMKModularTotalizer(this.f);
        }
        return this.amkModularTotalizer;
    }

    protected CCAtLeastK bestALK(int n) {
        if (this.alkModularTotalizer == null) {
            this.alkModularTotalizer = new CCALKModularTotalizer(this.f);
        }
        return this.alkModularTotalizer;
    }

    protected CCExactlyK bestEXK(int n) {
        if (this.exkTotalizer == null) {
            this.exkTotalizer = new CCEXKTotalizer();
        }
        return this.exkTotalizer;
    }

    public String toString() {
        return this.config().toString();
    }
}

