/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class CCConfig
extends Configuration {
    final AMO_ENCODER amoEncoder;
    final AMK_ENCODER amkEncoder;
    final ALK_ENCODER alkEncoder;
    final EXK_ENCODER exkEncoder;
    final BIMANDER_GROUP_SIZE bimanderGroupSize;
    final int bimanderFixedGroupSize;
    final int nestingGroupSize;
    final int productRecursiveBound;
    final int commanderGroupSize;

    public static Builder builder() {
        return new Builder();
    }

    private CCConfig(Builder builder) {
        super(ConfigurationType.CC_ENCODER);
        this.amoEncoder = builder.amoEncoder;
        this.amkEncoder = builder.amkEncoder;
        this.alkEncoder = builder.alkEncoder;
        this.exkEncoder = builder.exkEncoder;
        this.bimanderGroupSize = builder.bimanderGroupSize;
        this.bimanderFixedGroupSize = builder.bimanderFixedGroupSize;
        this.nestingGroupSize = builder.nestingGroupSize;
        this.productRecursiveBound = builder.productRecursiveBound;
        this.commanderGroupSize = builder.commanderGroupSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CCConfig{").append(System.lineSeparator());
        sb.append("amoEncoder=").append((Object)this.amoEncoder).append(System.lineSeparator());
        sb.append("amkEncoder=").append((Object)this.amkEncoder).append(System.lineSeparator());
        sb.append("alkEncoder=").append((Object)this.alkEncoder).append(System.lineSeparator());
        sb.append("exkEncoder=").append((Object)this.exkEncoder).append(System.lineSeparator());
        sb.append("bimanderGroupSize=").append((Object)this.bimanderGroupSize).append(System.lineSeparator());
        sb.append("bimanderFixedGroupSize=").append(this.bimanderFixedGroupSize).append(System.lineSeparator());
        sb.append("nestingGroupSize=").append(this.nestingGroupSize).append(System.lineSeparator());
        sb.append("productRecursiveBound=").append(this.productRecursiveBound).append(System.lineSeparator());
        sb.append("commanderGroupSize=").append(this.commanderGroupSize).append(System.lineSeparator());
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public static class Builder {
        private AMO_ENCODER amoEncoder = AMO_ENCODER.BEST;
        private AMK_ENCODER amkEncoder = AMK_ENCODER.BEST;
        private ALK_ENCODER alkEncoder = ALK_ENCODER.BEST;
        private EXK_ENCODER exkEncoder = EXK_ENCODER.BEST;
        private BIMANDER_GROUP_SIZE bimanderGroupSize = BIMANDER_GROUP_SIZE.SQRT;
        private int bimanderFixedGroupSize = 3;
        private int nestingGroupSize = 4;
        private int productRecursiveBound = 20;
        private int commanderGroupSize = 3;

        private Builder() {
        }

        public Builder amoEncoding(AMO_ENCODER amoEncoder) {
            this.amoEncoder = amoEncoder;
            return this;
        }

        public Builder amkEncoding(AMK_ENCODER amkEncoder) {
            this.amkEncoder = amkEncoder;
            return this;
        }

        public Builder alkEncoding(ALK_ENCODER alkEncoder) {
            this.alkEncoder = alkEncoder;
            return this;
        }

        public Builder exkEncoding(EXK_ENCODER exkEncoder) {
            this.exkEncoder = exkEncoder;
            return this;
        }

        public Builder bimanderGroupSize(BIMANDER_GROUP_SIZE bimanderGroupSize) {
            this.bimanderGroupSize = bimanderGroupSize;
            return this;
        }

        public Builder bimanderFixedGroupSize(int bimanderFixedGroupSize) {
            this.bimanderFixedGroupSize = bimanderFixedGroupSize;
            return this;
        }

        public Builder nestingGroupSize(int nestingGroupSize) {
            this.nestingGroupSize = nestingGroupSize;
            return this;
        }

        public Builder productRecursiveBound(int productRecursiveBound) {
            this.productRecursiveBound = productRecursiveBound;
            return this;
        }

        public Builder commanderGroupSize(int commanderGroupSize) {
            this.commanderGroupSize = commanderGroupSize;
            return this;
        }

        public CCConfig build() {
            return new CCConfig(this);
        }
    }

    public static enum BIMANDER_GROUP_SIZE {
        HALF,
        SQRT,
        FIXED;

    }

    public static enum EXK_ENCODER {
        TOTALIZER,
        CARDINALITY_NETWORK,
        BEST;

    }

    public static enum ALK_ENCODER {
        TOTALIZER,
        MODULAR_TOTALIZER,
        CARDINALITY_NETWORK,
        BEST;

    }

    public static enum AMK_ENCODER {
        TOTALIZER,
        MODULAR_TOTALIZER,
        CARDINALITY_NETWORK,
        BEST;

    }

    public static enum AMO_ENCODER {
        PURE,
        LADDER,
        PRODUCT,
        NESTED,
        COMMANDER,
        BINARY,
        BIMANDER,
        BEST;

    }
}

