/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCConfig;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.cardinalityconstraints.CCSorting;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCCardinalityNetworks {
    private final CCSorting sorting = new CCSorting();
    private CCIncrementalData incData;

    CCCardinalityNetworks() {
    }

    void buildAMK(EncodingResult result, Variable[] vars, int rhs) {
        result.reset();
        LNGVector<Literal> input = new LNGVector<Literal>();
        LNGVector<Literal> output = new LNGVector<Literal>();
        if (rhs > vars.length / 2) {
            int geq = vars.length - rhs;
            for (Variable v : vars) {
                input.push(v.negate());
            }
            this.sorting.sort(geq, input, result, output, CCSorting.ImplicationDirection.OUTPUT_TO_INPUT);
            for (int i = 0; i < geq; ++i) {
                result.addClause(output.get(i));
            }
        } else {
            for (Variable v : vars) {
                input.push(v);
            }
            this.sorting.sort(rhs + 1, input, result, output, CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
            assert (output.size() > rhs);
            result.addClause(output.get(rhs).negate());
        }
    }

    void buildAMKForIncremental(EncodingResult result, Variable[] vars, int rhs) {
        LNGVector<Literal> input = new LNGVector<Literal>();
        LNGVector<Literal> output = new LNGVector<Literal>();
        for (Variable var : vars) {
            input.push(var);
        }
        this.sorting.sort(rhs + 1, input, result, output, CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
        assert (output.size() > rhs);
        result.addClause(output.get(rhs).negate());
        this.incData = new CCIncrementalData(result, CCConfig.AMK_ENCODER.CARDINALITY_NETWORK, rhs, output);
    }

    void buildALK(EncodingResult result, Variable[] vars, int rhs) {
        result.reset();
        LNGVector<Literal> input = new LNGVector<Literal>();
        LNGVector<Literal> output = new LNGVector<Literal>();
        int newRHS = vars.length - rhs;
        if (newRHS > vars.length / 2) {
            int geq = vars.length - newRHS;
            for (Variable v : vars) {
                input.push(v);
            }
            this.sorting.sort(geq, input, result, output, CCSorting.ImplicationDirection.OUTPUT_TO_INPUT);
            for (int i = 0; i < geq; ++i) {
                result.addClause(output.get(i));
            }
        } else {
            for (Variable v : vars) {
                input.push(v.negate());
            }
            this.sorting.sort(newRHS + 1, input, result, output, CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
            assert (output.size() > newRHS);
            result.addClause(output.get(newRHS).negate());
        }
    }

    void buildALKForIncremental(EncodingResult result, Variable[] vars, int rhs) {
        LNGVector<Literal> input = new LNGVector<Literal>();
        LNGVector<Literal> output = new LNGVector<Literal>();
        for (Variable var : vars) {
            input.push(var.negate());
        }
        int newRHS = vars.length - rhs;
        this.sorting.sort(newRHS + 1, input, result, output, CCSorting.ImplicationDirection.INPUT_TO_OUTPUT);
        assert (output.size() > newRHS);
        result.addClause(output.get(newRHS).negate());
        this.incData = new CCIncrementalData(result, CCConfig.ALK_ENCODER.CARDINALITY_NETWORK, rhs, vars.length, output);
    }

    void buildEXK(EncodingResult result, Variable[] vars, int rhs) {
        result.reset();
        LNGVector<Literal> input = new LNGVector<Literal>();
        LNGVector<Literal> output = new LNGVector<Literal>();
        for (Variable var : vars) {
            input.push(var);
        }
        this.sorting.sort(rhs + 1, input, result, output, CCSorting.ImplicationDirection.BOTH);
        assert (output.size() > rhs);
        result.addClause(output.get(rhs).negate());
        result.addClause(output.get(rhs - 1));
    }

    CCIncrementalData incrementalData() {
        return this.incData;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

