/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Variable;

public final class CCAMOProduct
implements CCAtMostOne {
    private final int recursiveBound;
    private EncodingResult result;

    CCAMOProduct(int recursiveBound) {
        this.recursiveBound = recursiveBound;
    }

    @Override
    public void build(EncodingResult result, Variable ... vars) {
        result.reset();
        this.result = result;
        this.productRec(vars);
    }

    private void productRec(Variable ... vars) {
        int i;
        int n = vars.length;
        int p = (int)Math.ceil(Math.sqrt(n));
        int q = (int)Math.ceil((double)n / (double)p);
        Variable[] us = new Variable[p];
        for (int i2 = 0; i2 < us.length; ++i2) {
            us[i2] = this.result.newVariable();
        }
        Variable[] vs = new Variable[q];
        for (i = 0; i < vs.length; ++i) {
            vs[i] = this.result.newVariable();
        }
        if (us.length <= this.recursiveBound) {
            this.buildPure(us);
        } else {
            this.productRec(us);
        }
        if (vs.length <= this.recursiveBound) {
            this.buildPure(vs);
        } else {
            this.productRec(vs);
        }
        for (i = 0; i < p; ++i) {
            for (int j = 0; j < q; ++j) {
                int k = i * q + j;
                if (k < 0 || k >= n) continue;
                this.result.addClause(vars[k].negate(), us[i]);
                this.result.addClause(vars[k].negate(), vs[j]);
            }
        }
    }

    private void buildPure(Variable ... vars) {
        for (int i = 0; i < vars.length; ++i) {
            for (int j = i + 1; j < vars.length; ++j) {
                this.result.addClause(vars[i].negate(), vars[j].negate());
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

