/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCAMONested
implements CCAtMostOne {
    private final int groupSize;
    private EncodingResult result;

    CCAMONested(int groupSize) {
        this.groupSize = groupSize;
    }

    @Override
    public void build(EncodingResult result, Variable ... vars) {
        result.reset();
        this.result = result;
        this.encodeIntern(new LNGVector<Literal>(vars));
    }

    private void encodeIntern(LNGVector<Literal> vars) {
        if (vars.size() <= this.groupSize) {
            int i = 0;
            while (i + 1 < vars.size()) {
                for (int j = i + 1; j < vars.size(); ++j) {
                    this.result.addClause(vars.get(i).negate(), vars.get(j).negate());
                }
                ++i;
            }
        } else {
            int i;
            LNGVector<Literal> l1 = new LNGVector<Literal>(vars.size() / 2);
            LNGVector<Literal> l2 = new LNGVector<Literal>(vars.size() / 2);
            for (i = 0; i < vars.size() / 2; ++i) {
                l1.push(vars.get(i));
            }
            while (i < vars.size()) {
                l2.push(vars.get(i));
                ++i;
            }
            Variable newVariable = this.result.newVariable();
            l1.push(newVariable);
            l2.push(newVariable.negate());
            this.encodeIntern(l1);
            this.encodeIntern(l2);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

