/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCAMOCommander
implements CCAtMostOne {
    private final int k;
    private final LNGVector<Literal> literals;
    private final LNGVector<Literal> nextLiterals;
    private final LNGVector<Literal> currentLiterals;
    private EncodingResult result;

    CCAMOCommander(int k) {
        this.k = k;
        this.literals = new LNGVector();
        this.nextLiterals = new LNGVector();
        this.currentLiterals = new LNGVector();
    }

    @Override
    public void build(EncodingResult result, Variable ... vars) {
        result.reset();
        this.result = result;
        this.currentLiterals.clear();
        this.nextLiterals.clear();
        for (Variable var : vars) {
            this.currentLiterals.push(var);
        }
        this.encodeRecursive();
    }

    private void encodeRecursive() {
        boolean isExactlyOne = false;
        while (this.currentLiterals.size() > this.k) {
            this.literals.clear();
            this.nextLiterals.clear();
            for (int i = 0; i < this.currentLiterals.size(); ++i) {
                this.literals.push(this.currentLiterals.get(i));
                if (i % this.k != this.k - 1 && i != this.currentLiterals.size() - 1) continue;
                this.encodeNonRecursive(this.literals);
                this.literals.push(this.result.newVariable());
                this.nextLiterals.push(this.literals.back().negate());
                if (isExactlyOne && this.literals.size() > 0) {
                    this.result.addClause(this.literals);
                }
                for (int j = 0; j < this.literals.size() - 1; ++j) {
                    this.result.addClause(this.literals.back().negate(), this.literals.get(j).negate());
                }
                this.literals.clear();
            }
            this.currentLiterals.replaceInplace(this.nextLiterals);
            isExactlyOne = true;
        }
        this.encodeNonRecursive(this.currentLiterals);
        if (isExactlyOne && this.currentLiterals.size() > 0) {
            this.result.addClause(this.currentLiterals);
        }
    }

    private void encodeNonRecursive(LNGVector<Literal> literals) {
        if (literals.size() > 1) {
            for (int i = 0; i < literals.size(); ++i) {
                for (int j = i + 1; j < literals.size(); ++j) {
                    this.result.addClause(literals.get(i).negate(), literals.get(j).negate());
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

