/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Variable;

public final class CCAMOBinary
implements CCAtMostOne {
    CCAMOBinary() {
    }

    @Override
    public void build(EncodingResult result, Variable ... vars) {
        int j;
        int grayCode;
        int i;
        result.reset();
        int numberOfBits = (int)Math.ceil(Math.log(vars.length) / Math.log(2.0));
        int twoPowNBits = (int)Math.pow(2.0, numberOfBits);
        int k = (twoPowNBits - vars.length) * 2;
        Variable[] bits = new Variable[numberOfBits];
        for (int i2 = 0; i2 < numberOfBits; ++i2) {
            bits[i2] = result.newVariable();
        }
        int index = -1;
        for (i = 0; i < k; ++i) {
            ++index;
            grayCode = i ^ i >> 1;
            int nextGray = ++i ^ i >> 1;
            for (j = 0; j < numberOfBits; ++j) {
                if ((grayCode & 1 << j) != (nextGray & 1 << j)) continue;
                if ((grayCode & 1 << j) != 0) {
                    result.addClause(vars[index].negate(), bits[j]);
                    continue;
                }
                result.addClause(vars[index].negate(), bits[j].negate());
            }
        }
        while (i < twoPowNBits) {
            ++index;
            grayCode = i ^ i >> 1;
            for (j = 0; j < numberOfBits; ++j) {
                if ((grayCode & 1 << j) != 0) {
                    result.addClause(vars[index].negate(), bits[j]);
                    continue;
                }
                result.addClause(vars[index].negate(), bits[j].negate());
            }
            ++i;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

