/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.cardinalityconstraints;

import org.logicng.cardinalityconstraints.CCAtMostOne;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class CCAMOBimander
implements CCAtMostOne {
    private final LNGVector<LNGVector<Literal>> groups;
    private final LNGVector<Literal> bits;
    private final int m;
    private EncodingResult result;
    private int numberOfBits;
    private int twoPowNBits;
    private int k;

    CCAMOBimander(int m) {
        this.m = m;
        this.groups = new LNGVector();
        this.bits = new LNGVector();
    }

    @Override
    public void build(EncodingResult result, Variable ... vars) {
        result.reset();
        this.result = result;
        this.encodeIntern(new LNGVector<Literal>(vars));
    }

    private void encodeIntern(LNGVector<Literal> vars) {
        int j;
        int grayCode;
        int i;
        this.initializeGroups(vars);
        this.initializeBits();
        int index = -1;
        for (i = 0; i < this.k; ++i) {
            ++index;
            grayCode = i ^ i >> 1;
            int nextGray = ++i ^ i >> 1;
            for (j = 0; j < this.numberOfBits; ++j) {
                if ((grayCode & 1 << j) != (nextGray & 1 << j)) continue;
                this.handleGrayCode(grayCode, index, j);
            }
        }
        while (i < this.twoPowNBits) {
            ++index;
            grayCode = i ^ i >> 1;
            for (j = 0; j < this.numberOfBits; ++j) {
                this.handleGrayCode(grayCode, index, j);
            }
            ++i;
        }
    }

    private void handleGrayCode(int grayCode, int index, int j) {
        if ((grayCode & 1 << j) != 0) {
            for (int p = 0; p < this.groups.get(index).size(); ++p) {
                this.result.addClause(this.groups.get(index).get(p).negate(), this.bits.get(j));
            }
        } else {
            for (int p = 0; p < this.groups.get(index).size(); ++p) {
                this.result.addClause(this.groups.get(index).get(p).negate(), this.bits.get(j).negate());
            }
        }
    }

    private void initializeGroups(LNGVector<Literal> vars) {
        int n = vars.size();
        this.groups.clear();
        for (int i = 0; i < this.m; ++i) {
            this.groups.push(new LNGVector());
        }
        int g = (int)Math.ceil((double)n / (double)this.m);
        int ig = 0;
        int i = 0;
        while (i < vars.size()) {
            while (i < g) {
                this.groups.get(ig).push(vars.get(i));
                ++i;
            }
            g += (int)Math.ceil((double)(n - i) / (double)(this.m - ++ig));
        }
        for (i = 0; i < this.groups.size(); ++i) {
            this.encodeNaive(this.groups.get(i));
        }
    }

    private void initializeBits() {
        this.bits.clear();
        this.numberOfBits = (int)Math.ceil(Math.log(this.m) / Math.log(2.0));
        this.twoPowNBits = (int)Math.pow(2.0, this.numberOfBits);
        this.k = (this.twoPowNBits - this.m) * 2;
        for (int i = 0; i < this.numberOfBits; ++i) {
            this.bits.push(this.result.newVariable());
        }
    }

    private void encodeNaive(LNGVector<Literal> vars) {
        if (vars.size() > 1) {
            for (int i = 0; i < vars.size(); ++i) {
                for (int j = i + 1; j < vars.size(); ++j) {
                    this.result.addClause(vars.get(i).negate(), vars.get(j).negate());
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

