/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.backbones;

import java.util.Collection;
import java.util.Collections;
import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.functions.BackboneFunction;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.util.FormulaHelper;

public final class BackboneGeneration {
    private BackboneGeneration() {
    }

    public static Backbone compute(Collection<Formula> formulas, Collection<Variable> variables, BackboneType type) {
        if (formulas == null || formulas.isEmpty()) {
            throw new IllegalArgumentException("Provide at least one formula for backbone computation");
        }
        FormulaFactory f = formulas.iterator().next().factory();
        MiniSat miniSat = MiniSat.miniSat(f, MiniSatConfig.builder().cnfMethod(MiniSatConfig.CNFMethod.PG_ON_SOLVER).build());
        miniSat.add(formulas);
        return miniSat.execute(BackboneFunction.builder().variables(variables).type(type).build());
    }

    public static Backbone compute(Collection<Formula> formulas, Collection<Variable> variables) {
        return BackboneGeneration.compute(formulas, variables, BackboneType.POSITIVE_AND_NEGATIVE);
    }

    public static Backbone compute(Collection<Formula> formulas, BackboneType type) {
        return BackboneGeneration.compute(formulas, FormulaHelper.variables(formulas), type);
    }

    public static Backbone compute(Collection<Formula> formulas) {
        return BackboneGeneration.compute(formulas, FormulaHelper.variables(formulas), BackboneType.POSITIVE_AND_NEGATIVE);
    }

    public static Backbone compute(Formula formula, Collection<Variable> variables, BackboneType type) {
        return BackboneGeneration.compute(Collections.singletonList(formula), variables, type);
    }

    public static Backbone compute(Formula formula, Collection<Variable> variables) {
        return BackboneGeneration.compute(formula, variables, BackboneType.POSITIVE_AND_NEGATIVE);
    }

    public static Backbone compute(Formula formula, BackboneType type) {
        return BackboneGeneration.compute(formula, formula.variables(), type);
    }

    public static Backbone compute(Formula formula) {
        return BackboneGeneration.compute(formula, formula.variables(), BackboneType.POSITIVE_AND_NEGATIVE);
    }

    public static Backbone computePositive(Collection<Formula> formulas, Collection<Variable> variables) {
        return BackboneGeneration.compute(formulas, variables, BackboneType.ONLY_POSITIVE);
    }

    public static Backbone computePositive(Collection<Formula> formulas) {
        return BackboneGeneration.compute(formulas, FormulaHelper.variables(formulas), BackboneType.ONLY_POSITIVE);
    }

    public static Backbone computePositive(Formula formula, Collection<Variable> variables) {
        return BackboneGeneration.compute(formula, variables, BackboneType.ONLY_POSITIVE);
    }

    public static Backbone computePositive(Formula formula) {
        return BackboneGeneration.compute(formula, formula.variables(), BackboneType.ONLY_POSITIVE);
    }

    public static Backbone computeNegative(Collection<Formula> formulas, Collection<Variable> variables) {
        return BackboneGeneration.compute(formulas, variables, BackboneType.ONLY_NEGATIVE);
    }

    public static Backbone computeNegative(Collection<Formula> formulas) {
        return BackboneGeneration.compute(formulas, FormulaHelper.variables(formulas), BackboneType.ONLY_NEGATIVE);
    }

    public static Backbone computeNegative(Formula formula, Collection<Variable> variables) {
        return BackboneGeneration.compute(formula, variables, BackboneType.ONLY_NEGATIVE);
    }

    public static Backbone computeNegative(Formula formula) {
        return BackboneGeneration.compute(formula, formula.variables(), BackboneType.ONLY_NEGATIVE);
    }
}

