/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.backbones;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class Backbone {
    private final boolean sat;
    private final SortedSet<Variable> positiveBackbone;
    private final SortedSet<Variable> negativeBackbone;
    private final SortedSet<Variable> optionalVariables;

    private Backbone(boolean sat, SortedSet<Variable> positiveBackbone, SortedSet<Variable> negativeBackbone, SortedSet<Variable> optionalVariables) {
        this.sat = sat;
        this.positiveBackbone = positiveBackbone == null ? Collections.emptySortedSet() : positiveBackbone;
        this.negativeBackbone = negativeBackbone == null ? Collections.emptySortedSet() : negativeBackbone;
        this.optionalVariables = optionalVariables == null ? Collections.emptySortedSet() : optionalVariables;
    }

    public static Backbone satBackbone(SortedSet<Variable> positiveBackbone, SortedSet<Variable> negativeBackbone, SortedSet<Variable> optionalVariables) {
        return new Backbone(true, positiveBackbone, negativeBackbone, optionalVariables);
    }

    public static Backbone unsatBackbone() {
        return new Backbone(false, null, null, null);
    }

    public boolean isSat() {
        return this.sat;
    }

    public SortedSet<Variable> getPositiveBackbone() {
        return Collections.unmodifiableSortedSet(this.positiveBackbone);
    }

    public SortedSet<Variable> getNegativeBackbone() {
        return Collections.unmodifiableSortedSet(this.negativeBackbone);
    }

    public SortedSet<Variable> getOptionalVariables() {
        return Collections.unmodifiableSortedSet(this.optionalVariables);
    }

    public SortedSet<Literal> getCompleteBackbone() {
        TreeSet<Variable> completeBackbone = new TreeSet<Variable>((Collection<Variable>)this.positiveBackbone);
        for (Variable var : this.negativeBackbone) {
            completeBackbone.add((Variable)var.negate());
        }
        return Collections.unmodifiableSortedSet(completeBackbone);
    }

    public Formula toFormula(FormulaFactory f) {
        return this.sat ? f.and(this.getCompleteBackbone()) : f.falsum();
    }

    public SortedMap<Variable, Tristate> toMap() {
        TreeMap<Variable, Tristate> map = new TreeMap<Variable, Tristate>();
        for (Variable var : this.positiveBackbone) {
            map.put(var, Tristate.TRUE);
        }
        for (Variable var : this.negativeBackbone) {
            map.put(var, Tristate.FALSE);
        }
        for (Variable var : this.optionalVariables) {
            map.put(var, Tristate.UNDEF);
        }
        return Collections.unmodifiableSortedMap(map);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Backbone backbone = (Backbone)other;
        return Objects.equals(this.positiveBackbone, backbone.positiveBackbone) && Objects.equals(this.negativeBackbone, backbone.negativeBackbone) && Objects.equals(this.optionalVariables, backbone.optionalVariables);
    }

    public int hashCode() {
        return Objects.hash(this.positiveBackbone, this.negativeBackbone, this.optionalVariables);
    }

    public String toString() {
        return "Backbone{positiveBackbone=" + this.positiveBackbone + ", negativeBackbone=" + this.negativeBackbone + ", optionalVariables=" + this.optionalVariables + '}';
    }
}

