/*
 * Decompiled with CFR 0.152.
 */
package org.logicng;

public final class LogicNGVersion {
    private LogicNGVersion() {
    }

    public static String version() {
        Package mainPackage = LogicNGVersion.class.getPackage();
        return mainPackage.getImplementationVersion();
    }

    public static int major() {
        return LogicNGVersion.major(LogicNGVersion.version());
    }

    private static int major(String version) {
        try {
            return Integer.parseInt(version.split("\\.")[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return -1;
        }
    }

    public static int minor() {
        return LogicNGVersion.minor(LogicNGVersion.version());
    }

    private static int minor(String version) {
        try {
            return Integer.parseInt(version.split("\\.")[1]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return -1;
        }
    }

    public static int patch() {
        return LogicNGVersion.patch(LogicNGVersion.version());
    }

    private static int patch(String version) {
        try {
            return Integer.parseInt(version.split("\\.")[2].split("-")[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return -1;
        }
    }

    public static boolean snapshot() {
        return LogicNGVersion.snapshot(LogicNGVersion.version());
    }

    private static boolean snapshot(String version) {
        return version.contains("-SNAPSHOT");
    }
}

