/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import java.io.Serializable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements AggregatableStatistic<SumOfSquares>,
Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public SumOfSquares() {
        this.n = 0L;
        this.value = 0.0;
    }

    public SumOfSquares(SumOfSquares original) throws NullArgumentException {
        MathUtils.checkNotNull((Object)original);
        this.n = original.n;
        this.value = original.value;
    }

    @Override
    public void increment(double d) {
        this.value += d * d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public void aggregate(SumOfSquares other) {
        MathUtils.checkNotNull((Object)other);
        if (other.n > 0L) {
            this.n += other.n;
            this.value += other.value;
        }
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double sumSq = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length, (boolean)true)) {
            sumSq = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumSq += values[i] * values[i];
            }
        }
        return sumSq;
    }

    @Override
    public SumOfSquares copy() {
        return new SumOfSquares(this);
    }
}

