/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class RandomPercentile
extends AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic,
AggregatableStatistic<RandomPercentile>,
Serializable {
    public static final double DEFAULT_EPSILON = 1.0E-4;
    private static final long serialVersionUID = 1L;
    private final int s;
    private final int h;
    private final BufferMap bufferMap;
    private final double epsilon;
    private final RandomGenerator randomGenerator;
    private long n;
    private Buffer currentBuffer;

    public RandomPercentile(double epsilon, RandomGenerator randomGenerator) {
        if (epsilon <= 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, new Object[]{epsilon, 0});
        }
        this.h = (int)FastMath.ceil((double)RandomPercentile.log2(1.0 / epsilon));
        this.s = (int)FastMath.ceil((double)(FastMath.sqrt((double)RandomPercentile.log2(1.0 / epsilon)) / epsilon));
        this.randomGenerator = randomGenerator;
        this.bufferMap = new BufferMap(this.h + 1, this.s, randomGenerator);
        this.currentBuffer = this.bufferMap.create(0);
        this.epsilon = epsilon;
    }

    public RandomPercentile(RandomGenerator randomGenerator) {
        this(1.0E-4, randomGenerator);
    }

    public RandomPercentile(double epsilon) {
        this(epsilon, (RandomGenerator)new Well19937c());
    }

    public RandomPercentile() {
        this(1.0E-4, (RandomGenerator)new Well19937c());
    }

    public RandomPercentile(RandomPercentile original) {
        this.h = original.h;
        this.n = original.n;
        this.s = original.s;
        this.epsilon = original.epsilon;
        this.bufferMap = new BufferMap(original.bufferMap);
        this.randomGenerator = original.randomGenerator;
        Iterator<Buffer> iterator = this.bufferMap.iterator();
        Buffer current = null;
        Buffer curr = null;
        while (current == null && iterator.hasNext()) {
            curr = iterator.next();
            if (!curr.hasCapacity()) continue;
            current = curr;
        }
        this.currentBuffer = current == null ? curr : current;
    }

    @Override
    public long getN() {
        return this.n;
    }

    public double evaluate(double percentile, double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length)) {
            RandomPercentile randomPercentile = new RandomPercentile(this.epsilon, this.randomGenerator);
            randomPercentile.incrementAll(values, begin, length);
            return randomPercentile.getResult(percentile);
        }
        return Double.NaN;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        return this.evaluate(50.0, values, begin, length);
    }

    public double evaluate(double percentile, double[] values) {
        return this.evaluate(percentile, values, 0, values.length);
    }

    @Override
    public RandomPercentile copy() {
        return new RandomPercentile(this);
    }

    @Override
    public void clear() {
        this.n = 0L;
        this.bufferMap.clear();
        this.currentBuffer = this.bufferMap.create(0);
    }

    @Override
    public double getResult() {
        return this.getResult(50.0);
    }

    public double getResult(double percentile) {
        double lower;
        double upper;
        if (percentile > 100.0 || percentile < 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE, new Object[]{percentile, 0, 100});
        }
        double q = percentile / 100.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Buffer buffer : this.bufferMap) {
            double bMax;
            double bMin = buffer.min();
            if (bMin < min) {
                min = bMin;
            }
            if (!((bMax = buffer.max()) > max)) continue;
            max = bMax;
        }
        if (Double.compare(q, 0.0) == 0 || this.n == 1L) {
            return min;
        }
        if (Double.compare(q, 1.0) == 0) {
            return max;
        }
        if (this.n == 0L) {
            return Double.NaN;
        }
        if (this.bufferMap.halfEmpty()) {
            return new Percentile(percentile).evaluate(this.bufferMap.levelZeroData());
        }
        double targetRank = q * (double)this.n;
        double estimate = min + q * (max - min);
        double estimateRank = this.getRank(estimate);
        if (estimateRank > targetRank) {
            upper = estimate;
            lower = min;
        } else if (estimateRank < targetRank) {
            lower = estimate;
            upper = max;
        } else {
            return estimate;
        }
        double eps = this.epsilon / 2.0;
        double rankTolerance = eps * (double)this.n;
        double minWidth = eps / (double)this.n;
        double intervalWidth = FastMath.abs((double)(upper - lower));
        while (FastMath.abs((double)(estimateRank - targetRank)) > rankTolerance && intervalWidth > minWidth) {
            if (estimateRank > targetRank) {
                upper = estimate;
            } else {
                lower = estimate;
            }
            intervalWidth = upper - lower;
            estimate = lower + intervalWidth / 2.0;
            estimateRank = this.getRank(estimate);
        }
        return estimate;
    }

    public double getRank(double value) {
        double rankSum = 0.0;
        for (Buffer buffer : this.bufferMap) {
            rankSum += (double)buffer.rankOf(value) * FastMath.pow((double)2.0, (int)buffer.level);
        }
        return rankSum;
    }

    public double getQuantileRank(double value) {
        return this.getRank(value) / (double)this.getN();
    }

    @Override
    public void increment(double d) {
        ++this.n;
        if (!this.currentBuffer.hasCapacity()) {
            if (this.bufferMap.canCreate()) {
                int level = (int)Math.ceil(Math.max(0.0, RandomPercentile.log2((double)this.n / ((double)this.s * FastMath.pow((double)2.0, (int)(this.h - 1))))));
                this.currentBuffer = this.bufferMap.create(level);
            } else {
                this.currentBuffer = this.bufferMap.merge();
            }
        }
        this.currentBuffer.consume(d);
    }

    private static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public double reduce(double percentile, Collection<RandomPercentile> aggregates) {
        double lower;
        double upper;
        if (percentile > 100.0 || percentile < 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE, new Object[]{percentile, 0, 100});
        }
        Iterator<RandomPercentile> iterator = aggregates.iterator();
        boolean small = true;
        while (small && iterator.hasNext()) {
            small = iterator.next().bufferMap.halfEmpty();
        }
        if (small) {
            iterator = aggregates.iterator();
            double[] combined = new double[]{};
            while (iterator.hasNext()) {
                combined = MathArrays.concatenate((double[][])new double[][]{combined, iterator.next().bufferMap.levelZeroData()});
            }
            Percentile exactP = new Percentile(percentile);
            return exactP.evaluate(combined);
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double combinedN = 0.0;
        for (RandomPercentile curr : aggregates) {
            double curMin = curr.getResult(0.0);
            double curMax = curr.getResult(100.0);
            if (curMin < min) {
                min = curMin;
            }
            if (curMax > max) {
                max = curMax;
            }
            combinedN += (double)curr.getN();
        }
        double q = percentile / 100.0;
        if (Double.compare(q, 0.0) == 0) {
            return min;
        }
        if (Double.compare(q, 1.0) == 0) {
            return max;
        }
        double targetRank = q * combinedN;
        double estimate = min + q * (max - min);
        double estimateRank = this.getAggregateRank(estimate, aggregates);
        if (estimateRank > targetRank) {
            upper = estimate;
            lower = min;
        } else if (estimateRank < targetRank) {
            lower = estimate;
            upper = max;
        } else {
            return estimate;
        }
        double eps = this.epsilon / 2.0;
        double intervalWidth = FastMath.abs((double)(upper - lower));
        while (FastMath.abs((double)(estimateRank / combinedN - q)) > eps && intervalWidth > eps / combinedN) {
            if (estimateRank == targetRank) {
                return estimate;
            }
            if (estimateRank > targetRank) {
                upper = estimate;
            } else {
                lower = estimate;
            }
            intervalWidth = FastMath.abs((double)(upper - lower));
            estimate = lower + intervalWidth / 2.0;
            estimateRank = this.getAggregateRank(estimate, aggregates);
        }
        return estimate;
    }

    public double getAggregateRank(double value, Collection<RandomPercentile> aggregates) {
        double result = 0.0;
        Iterator<RandomPercentile> iterator = aggregates.iterator();
        while (iterator.hasNext()) {
            result += iterator.next().getRank(value);
        }
        return result;
    }

    public double getAggregateQuantileRank(double value, Collection<RandomPercentile> aggregates) {
        return this.getAggregateRank(value, aggregates) / this.getAggregateN(aggregates);
    }

    public double getAggregateN(Collection<RandomPercentile> aggregates) {
        double result = 0.0;
        Iterator<RandomPercentile> iterator = aggregates.iterator();
        while (iterator.hasNext()) {
            result += (double)iterator.next().getN();
        }
        return result;
    }

    @Override
    public void aggregate(RandomPercentile other) throws NullArgumentException {
        if (other == null) {
            throw new NullArgumentException();
        }
        if (other.s != this.s) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
        }
        this.bufferMap.absorb(other.bufferMap);
        this.n += other.n;
    }

    public static long maxValuesRetained(double epsilon) {
        if (epsilon >= 1.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, new Object[]{epsilon, 1});
        }
        if (epsilon <= 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{epsilon, 0});
        }
        long h = (long)FastMath.ceil((double)RandomPercentile.log2(1.0 / epsilon));
        long s = (long)FastMath.ceil((double)(FastMath.sqrt((double)RandomPercentile.log2(1.0 / epsilon)) / epsilon));
        return (h + 1L) * s;
    }

    private static class BufferMap
    implements Iterable<Buffer>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;
        private final RandomGenerator randomGenerator;
        private int count;
        private final int bufferSize;
        private final Map<Integer, List<Buffer>> registry;
        private int maxLevel;

        BufferMap(int capacity, int bufferSize, RandomGenerator randomGenerator) {
            this.bufferSize = bufferSize;
            this.capacity = capacity;
            this.randomGenerator = randomGenerator;
            this.registry = new HashMap<Integer, List<Buffer>>();
        }

        BufferMap(BufferMap original) {
            this.bufferSize = original.bufferSize;
            this.capacity = original.capacity;
            this.count = 0;
            this.randomGenerator = original.randomGenerator;
            this.registry = new HashMap<Integer, List<Buffer>>();
            Iterator<Buffer> iterator = original.iterator();
            Buffer current = null;
            Buffer newCopy = null;
            while (iterator.hasNext()) {
                double[] data;
                current = iterator.next();
                newCopy = this.create(current.getLevel());
                for (double value : data = current.getData()) {
                    newCopy.consume(value);
                }
            }
        }

        public Buffer create(int level) {
            if (!this.canCreate()) {
                return null;
            }
            ++this.count;
            Buffer buffer = new Buffer(this.bufferSize, level, this.randomGenerator);
            List<Buffer> bufferList = this.registry.get(level);
            if (bufferList == null) {
                bufferList = new ArrayList<Buffer>();
                this.registry.put(level, bufferList);
            }
            bufferList.add(buffer);
            if (level > this.maxLevel) {
                this.maxLevel = level;
            }
            return buffer;
        }

        public boolean canCreate() {
            return this.count < this.capacity;
        }

        public boolean halfEmpty() {
            return this.count * 2 < this.capacity && this.registry.size() == 1 && this.registry.containsKey(0);
        }

        public double[] levelZeroData() {
            List<Buffer> levelZeroBuffers = this.registry.get(0);
            int length = 0;
            for (Buffer buffer : levelZeroBuffers) {
                if (!buffer.hasCapacity()) {
                    length += buffer.size;
                    continue;
                }
                length += buffer.next;
            }
            int pos = 0;
            double[] out = new double[length];
            for (Buffer buffer : levelZeroBuffers) {
                int currLen = !buffer.hasCapacity() ? buffer.size : buffer.next;
                System.arraycopy(buffer.data, 0, out, pos, currLen);
                pos += currLen;
            }
            return out;
        }

        public Buffer merge() {
            int l = 0;
            List<Buffer> mergeCandidates = null;
            while (mergeCandidates == null && l <= this.maxLevel) {
                List<Buffer> bufferList = this.registry.get(l);
                if (bufferList != null && bufferList.size() > 1) {
                    mergeCandidates = bufferList;
                    continue;
                }
                ++l;
            }
            if (mergeCandidates == null) {
                throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
            }
            Buffer buffer1 = (Buffer)mergeCandidates.get(0);
            Buffer buffer2 = (Buffer)mergeCandidates.get(1);
            mergeCandidates.remove(0);
            mergeCandidates.remove(0);
            if (this.registry.get(l).size() == 0) {
                this.registry.remove(l);
            }
            buffer1.mergeWith(buffer2);
            this.register(buffer1);
            this.register(buffer2);
            return buffer2;
        }

        public void clear() {
            for (List<Buffer> bufferList : this.registry.values()) {
                bufferList.clear();
            }
            this.registry.clear();
            this.count = 0;
        }

        public void register(Buffer buffer) {
            int level = buffer.getLevel();
            List<Buffer> list = this.registry.get(level);
            if (list == null) {
                list = new ArrayList<Buffer>();
                this.registry.put(level, list);
                if (level > this.maxLevel) {
                    this.maxLevel = level;
                }
            }
            list.add(buffer);
        }

        public void deRegister(Buffer buffer) {
            List<Buffer> bufferList = this.registry.get(buffer.getLevel());
            UUID targetId = buffer.getId();
            int i = 0;
            boolean found = false;
            while (i < bufferList.size() && !found) {
                if (!bufferList.get(i).getId().equals(targetId)) continue;
                bufferList.remove(i);
                found = true;
                buffer.clear();
            }
            if (!found) {
                throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
            }
        }

        @Override
        public Iterator<Buffer> iterator() {
            return new Iterator<Buffer>(){
                private final Iterator<Integer> levelIterator;
                private List<Buffer> currentList;
                private Iterator<Buffer> bufferIterator;
                {
                    this.levelIterator = registry.keySet().iterator();
                    this.currentList = (List)registry.get(this.levelIterator.next());
                    this.bufferIterator = this.currentList == null ? null : this.currentList.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.bufferIterator == null) {
                        return false;
                    }
                    if (this.bufferIterator.hasNext()) {
                        return true;
                    }
                    if (this.levelIterator.hasNext()) {
                        List currentList = (List)registry.get(this.levelIterator.next());
                        this.bufferIterator = currentList.iterator();
                        return true;
                    }
                    this.bufferIterator = null;
                    return false;
                }

                @Override
                public Buffer next() {
                    if (this.hasNext()) {
                        return this.bufferIterator.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void absorb(BufferMap other) {
            int fullCount = 0;
            Buffer notFull = null;
            for (Buffer buffer : other) {
                if (buffer.hasCapacity()) {
                    notFull = buffer;
                } else {
                    ++fullCount;
                }
                this.register(buffer);
                ++this.count;
            }
            int excess = fullCount + (notFull == null ? 0 : 1) + this.count - this.capacity;
            for (int i = 0; i < excess - 1; ++i) {
                this.mergeUp();
                --this.count;
            }
        }

        public void mergeUp() {
            Iterator<Buffer> bufferIterator = this.iterator();
            Buffer first = null;
            Buffer second = null;
            while ((first == null || second == null) && bufferIterator.hasNext()) {
                Buffer buffer = bufferIterator.next();
                if (buffer.hasCapacity()) continue;
                if (first == null) {
                    first = buffer;
                    continue;
                }
                second = buffer;
            }
            if (first == null || second == null || first.level > second.level) {
                throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
            }
            if (first.getLevel() == second.getLevel()) {
                second.mergeWith(first);
            } else {
                first.mergeInto(second);
            }
            this.deRegister(first);
        }
    }

    private static class Buffer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int size;
        private final double[] data;
        private final RandomGenerator randomGenerator;
        private int level;
        private long blockSize;
        private int next;
        private long consumed;
        private long nextToTake;
        private final UUID id;

        Buffer(int size, int level, RandomGenerator randomGenerator) {
            this.size = size;
            this.data = new double[size];
            this.level = level;
            this.randomGenerator = randomGenerator;
            this.id = UUID.randomUUID();
            this.computeBlockSize();
        }

        private void computeBlockSize() {
            if (this.level == 0) {
                this.blockSize = 1L;
            } else {
                long product = 1L;
                for (int i = 0; i < this.level; ++i) {
                    product *= 2L;
                }
                this.blockSize = product;
            }
            if (this.blockSize > 1L) {
                this.nextToTake = this.randomGenerator.nextLong(this.blockSize);
            }
        }

        public void consume(double value) {
            if (this.consumed == this.nextToTake) {
                this.data[this.next] = value;
                ++this.next;
            }
            ++this.consumed;
            if (this.consumed == this.blockSize) {
                if (this.next == this.size) {
                    Arrays.sort(this.data);
                } else {
                    this.consumed = 0L;
                    if (this.blockSize > 1L) {
                        this.nextToTake = this.randomGenerator.nextLong(this.blockSize);
                    }
                }
            }
        }

        public void mergeWith(Buffer other) {
            if (this.hasCapacity() || other.hasCapacity() || other.level != this.level) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
            }
            for (int i = 0; i < this.size; ++i) {
                if (!this.randomGenerator.nextBoolean()) continue;
                this.data[i] = other.data[i];
            }
            Arrays.sort(this.data);
            other.setLevel(this.level + 1);
            this.setLevel(this.level + 1);
            other.clear();
        }

        public void mergeInto(Buffer higher) {
            int i;
            if (this.size != higher.size || this.hasCapacity() || higher.hasCapacity() || this.level >= higher.level) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
            }
            int levelDifference = higher.level - this.level;
            int m = 1;
            for (i = 0; i < levelDifference; ++i) {
                m *= 2;
            }
            for (i = 0; i < this.size; ++i) {
                if (this.randomGenerator.nextInt(m + 1) != 0) continue;
                higher.data[i] = this.data[i];
            }
            Arrays.sort(higher.data);
        }

        public boolean hasCapacity() {
            return this.next < this.size || this.consumed < this.blockSize;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void clear() {
            this.consumed = 0L;
            this.next = 0;
            this.computeBlockSize();
        }

        public double[] getData() {
            double[] out = new double[this.next];
            System.arraycopy(this.data, 0, out, 0, this.next);
            return out;
        }

        public int rankOf(double value) {
            int ret = 0;
            if (!this.hasCapacity()) {
                ret = Arrays.binarySearch(this.data, value);
                if (ret < 0) {
                    return -ret - 1;
                }
                return ret;
            }
            for (int i = 0; i < this.next; ++i) {
                if (!(this.data[i] < value)) continue;
                ++ret;
            }
            return ret;
        }

        public double min() {
            if (!this.hasCapacity()) {
                return this.data[0];
            }
            return StatUtils.min(this.getData());
        }

        public double max() {
            if (!this.hasCapacity()) {
                return this.data[this.data.length - 1];
            }
            return StatUtils.max(this.getData());
        }

        public int getLevel() {
            return this.level;
        }

        public UUID getId() {
            return this.id;
        }
    }
}

