/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.thirdparty.com.google.common.base.Optional;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PlantUmlPatterns {
    private static final String COMPONENT_NAME_GROUP_NAME = "componentName";
    private static final String COMPONENT_NAME_FORMAT = "\\[" + PlantUmlPatterns.capture(PlantUmlPatterns.anythingBut("\\[\\]"), "componentName") + "]";
    private static final String STEREOTYPE_FORMAT = "(?:<<" + PlantUmlPatterns.capture(PlantUmlPatterns.anythingBut("<>")) + ">>\\s*)";
    private static final Pattern STEREOTYPE_PATTERN = Pattern.compile(STEREOTYPE_FORMAT);
    private static final String ALIAS_GROUP_NAME = "alias";
    private static final String ALIAS_FORMAT = "\\s*(?:as \"?" + PlantUmlPatterns.capture("[^\"]+", "alias") + "\"?)?";
    private static final Pattern PLANTUML_COMPONENT_PATTERN = Pattern.compile("^\\s*" + COMPONENT_NAME_FORMAT + "\\s*" + STEREOTYPE_FORMAT + "*" + ALIAS_FORMAT + "\\s*");

    PlantUmlPatterns() {
    }

    private static String capture(String pattern) {
        return "(" + pattern + ")";
    }

    private static String capture(String pattern, String name) {
        return "(?<" + name + ">" + pattern + ")";
    }

    private static String anythingBut(String charsJoined) {
        return "[^" + charsJoined + "]+";
    }

    FluentIterable<String> filterComponents(List<String> lines) {
        return FluentIterable.from(lines).filter(this.matches(PLANTUML_COMPONENT_PATTERN));
    }

    PlantUmlComponentMatcher matchComponent(String input) {
        return new PlantUmlComponentMatcher(input);
    }

    private Predicate<String> matches(final Pattern pattern) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        };
    }

    Iterable<PlantUmlDependencyMatcher> matchDependencies(List<String> diagramLines) {
        ArrayList<PlantUmlDependencyMatcher> result = new ArrayList<PlantUmlDependencyMatcher>();
        for (String line : diagramLines) {
            result.addAll(PlantUmlDependencyMatcher.tryParseFromLeftToRight(line));
            result.addAll(PlantUmlDependencyMatcher.tryParseFromRightToLeft(line));
        }
        return result;
    }

    static class PlantUmlDependencyMatcher {
        private static final String COLOR_REGEX = "\\[[^]]+]";
        private static final String DEPENDENCY_ARROW_CENTER_REGEX = "(left|right|up|down|\\[[^]]+])?";
        private static final Pattern DEPENDENCY_RIGHT_ARROW_PATTERN = Pattern.compile("\\s-+(left|right|up|down|\\[[^]]+])?-*>\\s");
        private static final Pattern DEPENDENCY_LEFT_ARROW_PATTERN = Pattern.compile("\\s<-*(left|right|up|down|\\[[^]]+])?-+\\s");
        private final String target;
        private String origin;

        PlantUmlDependencyMatcher(String origin, String target) {
            this.origin = Preconditions.checkNotNull(origin, "Origin must not be null");
            this.target = Preconditions.checkNotNull(target, "Target must not be null");
        }

        String matchOrigin() {
            return this.origin;
        }

        String matchTarget() {
            return this.target;
        }

        static Collection<PlantUmlDependencyMatcher> tryParseFromLeftToRight(String line) {
            return PlantUmlDependencyMatcher.isDependencyFromLeftToRight(line) ? Collections.singletonList(PlantUmlDependencyMatcher.parseDependencyFromLeftToRight(line)) : Collections.emptyList();
        }

        private static boolean isDependencyFromLeftToRight(String line) {
            return DEPENDENCY_RIGHT_ARROW_PATTERN.matcher(line).find();
        }

        private static PlantUmlDependencyMatcher parseDependencyFromLeftToRight(String line) {
            List<String> parts = PlantUmlDependencyMatcher.parseParts(line, DEPENDENCY_RIGHT_ARROW_PATTERN);
            return new PlantUmlDependencyMatcher(parts.get(0), parts.get(1));
        }

        static Collection<PlantUmlDependencyMatcher> tryParseFromRightToLeft(String line) {
            return PlantUmlDependencyMatcher.isDependencyFromRightToLeft(line) ? Collections.singletonList(PlantUmlDependencyMatcher.parseDependencyFromRightToLeft(line)) : Collections.emptyList();
        }

        private static boolean isDependencyFromRightToLeft(String line) {
            return DEPENDENCY_LEFT_ARROW_PATTERN.matcher(line).find();
        }

        private static PlantUmlDependencyMatcher parseDependencyFromRightToLeft(String line) {
            List<String> parts = PlantUmlDependencyMatcher.parseParts(line, DEPENDENCY_LEFT_ARROW_PATTERN);
            return new PlantUmlDependencyMatcher(parts.get(1), parts.get(0));
        }

        private static List<String> parseParts(String line, Pattern dependencyRightArrowPattern) {
            line = PlantUmlDependencyMatcher.removeOptionalDescription(line);
            return Splitter.on(dependencyRightArrowPattern).trimResults().limit(2).splitToList(line);
        }

        private static String removeOptionalDescription(String line) {
            return line.replaceAll(":.*", "");
        }
    }

    static class PlantUmlComponentMatcher {
        private final Matcher componentMatcher;
        private final Matcher stereotypeMatcher;

        PlantUmlComponentMatcher(String input) {
            this.componentMatcher = PLANTUML_COMPONENT_PATTERN.matcher(input);
            Preconditions.checkState(this.componentMatcher.matches(), "input %s does not match pattern %s", (Object)input, (Object)PLANTUML_COMPONENT_PATTERN);
            this.stereotypeMatcher = STEREOTYPE_PATTERN.matcher(input);
        }

        String matchComponentName() {
            return this.componentMatcher.group(PlantUmlPatterns.COMPONENT_NAME_GROUP_NAME);
        }

        Set<String> matchStereoTypes() {
            HashSet<String> result = new HashSet<String>();
            while (this.stereotypeMatcher.find()) {
                result.add(this.stereotypeMatcher.group(1));
            }
            return result;
        }

        Optional<String> matchAlias() {
            return Optional.fromNullable(this.componentMatcher.group(PlantUmlPatterns.ALIAS_GROUP_NAME));
        }
    }
}

