/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.library.plantuml.Alias;
import com.tngtech.archunit.library.plantuml.ComponentIdentifier;
import com.tngtech.archunit.library.plantuml.ComponentName;
import com.tngtech.archunit.library.plantuml.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.PlantUmlComponent;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class PlantUmlComponents {
    private final Map<ComponentName, PlantUmlComponent> componentsByName;
    private final Map<Alias, PlantUmlComponent> componentsByAlias;
    private static final Predicate<PlantUmlComponent> WITH_ALIAS = new Predicate<PlantUmlComponent>(){

        @Override
        public boolean apply(PlantUmlComponent input) {
            return input.getAlias().isPresent();
        }
    };

    PlantUmlComponents(Set<PlantUmlComponent> components) {
        this.componentsByName = FluentIterable.from(components).uniqueIndex(PlantUmlComponent.Functions.GET_COMPONENT_NAME);
        this.componentsByAlias = FluentIterable.from(components).filter(WITH_ALIAS).uniqueIndex(PlantUmlComponent.Functions.TO_EXISTING_ALIAS);
    }

    Collection<PlantUmlComponent> getAllComponents() {
        return this.componentsByName.values();
    }

    Collection<PlantUmlComponent> getComponentsWithAlias() {
        return this.componentsByAlias.values();
    }

    PlantUmlComponent findComponentWith(String nameOrAlias) {
        PlantUmlComponent result;
        ComponentName componentName = new ComponentName(nameOrAlias);
        Alias alias = new Alias(nameOrAlias);
        PlantUmlComponent plantUmlComponent = result = this.componentsByAlias.containsKey(alias) ? this.componentsByAlias.get(alias) : this.componentsByName.get(componentName);
        if (result == null) {
            throw new IllegalDiagramException("There is no Component with name or alias = '%s'. %s", nameOrAlias, "Components must be specified separately from dependencies.");
        }
        return result;
    }

    PlantUmlComponent findComponentWith(ComponentIdentifier identifier) {
        return this.componentsByName.get(identifier.getComponentName());
    }
}

