/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.library.plantuml.Alias;
import com.tngtech.archunit.library.plantuml.ComponentName;
import java.util.Objects;

class ComponentIdentifier {
    private final ComponentName componentName;
    private final Optional<Alias> alias;

    ComponentIdentifier(ComponentName componentName) {
        this(componentName, Optional.absent());
    }

    ComponentIdentifier(ComponentName componentName, Alias alias) {
        this(componentName, Optional.of(alias));
    }

    private ComponentIdentifier(ComponentName componentName, Optional<Alias> alias) {
        this.componentName = componentName;
        this.alias = alias;
    }

    ComponentName getComponentName() {
        return this.componentName;
    }

    public int hashCode() {
        return Objects.hash(this.componentName, this.alias);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentIdentifier other = (ComponentIdentifier)obj;
        return Objects.equals(this.componentName, other.componentName) && Objects.equals(this.alias, other.alias);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{componentName=" + this.componentName + ", alias=" + this.alias + '}';
    }
}

