/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.library.dependencies.PrimitiveDataTypes;
import com.tngtech.archunit.library.dependencies.PrimitiveGraph;
import java.util.Arrays;

class TarjanGraph {
    static final int[] LESS_THAN_TWO_VALUES = new int[0];
    private final PrimitiveGraph graph;
    private final PrimitiveDataTypes.IntArray visitationIndexes;
    private final PrimitiveDataTypes.IntArray lowLinks;
    private final PrimitiveDataTypes.IntStack nodeStack;
    private final boolean[] nodeOnStack;
    private final int[] tempArray;

    private TarjanGraph(PrimitiveGraph graph) {
        this.graph = graph;
        this.visitationIndexes = new PrimitiveDataTypes.IntArray(graph.getSize());
        this.lowLinks = new PrimitiveDataTypes.IntArray(graph.getSize());
        this.nodeStack = new PrimitiveDataTypes.IntStack(graph.getSize());
        this.nodeOnStack = new boolean[graph.getSize()];
        this.tempArray = new int[graph.getSize()];
    }

    int getSize() {
        return this.graph.getSize();
    }

    int[] getAdjacentNodesOf(int nodeIndex) {
        return this.graph.getAdjacentNodesOf(nodeIndex);
    }

    boolean isVisitationIndexUnset(int nodeIndex) {
        return !this.visitationIndexes.isSet(nodeIndex);
    }

    int getNodeVisitationIndex(int nodeIndex) {
        return this.visitationIndexes.get(nodeIndex);
    }

    void setNodeVisitationIndex(int nodeIndex, int visitationIndex) {
        this.visitationIndexes.set(nodeIndex, visitationIndex);
    }

    int getLowLink(int nodeIndex) {
        return this.lowLinks.get(nodeIndex);
    }

    void setLowLink(int nodeIndex, int lowLink) {
        this.lowLinks.set(nodeIndex, lowLink);
    }

    boolean isOnStack(int nodeIndex) {
        return this.nodeOnStack[nodeIndex];
    }

    void pushOnStack(int nodeIndex) {
        this.nodeStack.push(nodeIndex);
        this.nodeOnStack[nodeIndex] = true;
    }

    int[] popStackUntilEncountering(int nodeToVisit) {
        int current;
        int index = 0;
        do {
            current = this.nodeStack.pop();
            this.nodeOnStack[current] = false;
            this.tempArray[index++] = current;
        } while (current != nodeToVisit);
        return index > 1 ? Arrays.copyOf(this.tempArray, index) : LESS_THAN_TWO_VALUES;
    }

    void reset() {
        this.visitationIndexes.reset();
        this.lowLinks.reset();
        this.nodeStack.reset();
        Arrays.fill(this.nodeOnStack, false);
    }

    static TarjanGraph of(PrimitiveGraph graph) {
        return new TarjanGraph(graph);
    }
}

