/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.library.dependencies.PrimitiveGraph;
import com.tngtech.archunit.library.dependencies.TarjanGraph;
import com.tngtech.archunit.thirdparty.com.google.common.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Ordering;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TarjanComponentFinder {
    static final int[] NO_COMPONENT_FOUND = new int[0];
    private int nextIndex = 0;
    private final TarjanGraph graph;
    private static final Function<int[], Integer> MINIMUM_OF_INT_ARRAY = new Function<int[], Integer>(){

        @Override
        public Integer apply(int[] input) {
            return Ints.min(input);
        }
    };

    TarjanComponentFinder(PrimitiveGraph primitiveGraph) {
        this.graph = TarjanGraph.of(primitiveGraph);
    }

    private void reset() {
        this.nextIndex = 0;
        this.graph.reset();
    }

    int[] findNonTrivialStronglyConnectedComponentWithLowestNodeIndexAbove(int lowerIndexBound) {
        int[] nextComponent = this.findNonTrivialLowestStronglyConnectedComponentInSubGraphInducedByLowerBound(lowerIndexBound);
        this.reset();
        return nextComponent;
    }

    private int[] findNonTrivialLowestStronglyConnectedComponentInSubGraphInducedByLowerBound(int lowerIndexBound) {
        for (int j = lowerIndexBound; j < this.graph.getSize(); ++j) {
            List<int[]> components;
            if (!this.graph.isVisitationIndexUnset(j) || (components = this.findNonTrivialStronglyConnectedComponents(j, lowerIndexBound)).isEmpty()) continue;
            return this.findComponentWithLowestNode(components);
        }
        return NO_COMPONENT_FOUND;
    }

    private List<int[]> findNonTrivialStronglyConnectedComponents(int nodeToVisit, int lowerIndexBound) {
        int[] currentStack;
        int currentIndex = this.nextIndex++;
        this.graph.setNodeVisitationIndex(nodeToVisit, currentIndex);
        this.graph.setLowLink(nodeToVisit, currentIndex);
        this.graph.pushOnStack(nodeToVisit);
        List<int[]> result = this.findNonTrivialStronglyConnectedComponentsOfDescendants(nodeToVisit, lowerIndexBound);
        if (this.graph.getLowLink(nodeToVisit) == this.graph.getNodeVisitationIndex(nodeToVisit) && (currentStack = this.graph.popStackUntilEncountering(nodeToVisit)) != TarjanGraph.LESS_THAN_TWO_VALUES) {
            result.add(currentStack);
        }
        return result;
    }

    private List<int[]> findNonTrivialStronglyConnectedComponentsOfDescendants(int nodeToVisit, int lowerIndexBound) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int targetNode : this.graph.getAdjacentNodesOf(nodeToVisit)) {
            int newLowLink;
            if (targetNode < lowerIndexBound) continue;
            if (this.graph.isVisitationIndexUnset(targetNode)) {
                result.addAll(this.findNonTrivialStronglyConnectedComponents(targetNode, lowerIndexBound));
                newLowLink = Math.min(this.graph.getLowLink(nodeToVisit), this.graph.getLowLink(targetNode));
                this.graph.setLowLink(nodeToVisit, newLowLink);
                continue;
            }
            if (!this.graph.isOnStack(targetNode)) continue;
            newLowLink = Math.min(this.graph.getNodeVisitationIndex(targetNode), this.graph.getLowLink(nodeToVisit));
            this.graph.setLowLink(nodeToVisit, newLowLink);
        }
        return result;
    }

    private int[] findComponentWithLowestNode(List<int[]> component) {
        int[] componentWithLowestNodeIndex = Ordering.natural().onResultOf(MINIMUM_OF_INT_ARRAY).min(component);
        Arrays.sort(componentWithLowestNodeIndex);
        return componentWithLowestNodeIndex;
    }
}

