/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.library.dependencies.Edge;
import com.tngtech.archunit.library.dependencies.Path;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class Cycle<T, ATTACHMENT> {
    private final Path<T, ATTACHMENT> path;

    Cycle(List<Edge<T, ATTACHMENT>> edges) {
        this(new Path<T, ATTACHMENT>(ImmutableList.copyOf(edges)));
    }

    Cycle(Path<T, ATTACHMENT> path) {
        this.path = Preconditions.checkNotNull(path);
        this.validate(path);
    }

    List<Edge<T, ATTACHMENT>> getEdges() {
        return this.path.getEdges();
    }

    private void validate(Path<T, ATTACHMENT> path) {
        if (path.isEmpty()) {
            this.throwNoCycleException(path);
        }
        this.validateStartEqualsEnd(path);
    }

    private void validateStartEqualsEnd(Path<T, ATTACHMENT> path) {
        T edgeStart = path.getStart();
        T edgeEnd = path.getEnd();
        if (!edgeEnd.equals(edgeStart)) {
            this.throwNoCycleException(path);
        }
    }

    private void throwNoCycleException(Path<T, ATTACHMENT> path) {
        throw new IllegalArgumentException("The supplied edges do not form a cycle. Edges were " + path);
    }

    public int hashCode() {
        return Objects.hash(this.path.getSetOfEdges());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cycle other = (Cycle)obj;
        return Objects.equals(this.path.getSetOfEdges(), other.path.getSetOfEdges());
    }

    public String toString() {
        return "Cycle{" + this.path.edgesToString() + '}';
    }

    public static <T, ATTACHMENT> Cycle<T, ATTACHMENT> from(Path<T, ATTACHMENT> path) {
        return new Cycle<T, ATTACHMENT>(path);
    }
}

