/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.PredicateAggregator;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Architectures {
    private Architectures() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static LayeredArchitecture layeredArchitecture() {
        return new LayeredArchitecture();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static OnionArchitecture onionArchitecture() {
        return new OnionArchitecture();
    }

    public static final class OnionArchitecture
    implements ArchRule {
        private static final String DOMAIN_MODEL_LAYER = "domain model";
        private static final String DOMAIN_SERVICE_LAYER = "domain service";
        private static final String APPLICATION_SERVICE_LAYER = "application service";
        private static final String ADAPTER_LAYER = "adapter";
        private final Optional<String> overriddenDescription;
        private String[] domainModelPackageIdentifiers = new String[0];
        private String[] domainServicePackageIdentifiers = new String[0];
        private String[] applicationPackageIdentifiers = new String[0];
        private Map<String, String[]> adapterPackageIdentifiers = new LinkedHashMap<String, String[]>();
        private boolean optionalLayers = false;
        private List<IgnoredDependency> ignoredDependencies = new ArrayList<IgnoredDependency>();

        private OnionArchitecture() {
            this.overriddenDescription = Optional.absent();
        }

        private OnionArchitecture(String[] domainModelPackageIdentifiers, String[] domainServicePackageIdentifiers, String[] applicationPackageIdentifiers, Map<String, String[]> adapterPackageIdentifiers, Optional<String> overriddenDescription) {
            this.domainModelPackageIdentifiers = domainModelPackageIdentifiers;
            this.domainServicePackageIdentifiers = domainServicePackageIdentifiers;
            this.applicationPackageIdentifiers = applicationPackageIdentifiers;
            this.adapterPackageIdentifiers = adapterPackageIdentifiers;
            this.overriddenDescription = overriddenDescription;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainModels(String ... packageIdentifiers) {
            this.domainModelPackageIdentifiers = packageIdentifiers;
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainServices(String ... packageIdentifiers) {
            this.domainServicePackageIdentifiers = packageIdentifiers;
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture applicationServices(String ... packageIdentifiers) {
            this.applicationPackageIdentifiers = packageIdentifiers;
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture adapter(String name, String ... packageIdentifiers) {
            this.adapterPackageIdentifiers.put(name, packageIdentifiers);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture withOptionalLayers(boolean optionalLayers) {
            this.optionalLayers = optionalLayers;
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(Class<?> origin, Class<?> target) {
            return this.ignoreDependency(JavaClass.Predicates.equivalentTo(origin), JavaClass.Predicates.equivalentTo(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(String origin, String target) {
            return this.ignoreDependency(HasName.Predicates.name(origin), HasName.Predicates.name(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
            this.ignoredDependencies.add(new IgnoredDependency(origin, target));
            return this;
        }

        private LayeredArchitecture layeredArchitectureDelegate() {
            LayeredArchitecture layeredArchitectureDelegate = Architectures.layeredArchitecture().layer(DOMAIN_MODEL_LAYER).definedBy(this.domainModelPackageIdentifiers).layer(DOMAIN_SERVICE_LAYER).definedBy(this.domainServicePackageIdentifiers).layer(APPLICATION_SERVICE_LAYER).definedBy(this.applicationPackageIdentifiers).layer(ADAPTER_LAYER).definedBy(this.concatenateAll(this.adapterPackageIdentifiers.values())).whereLayer(DOMAIN_MODEL_LAYER).mayOnlyBeAccessedByLayers(DOMAIN_SERVICE_LAYER, APPLICATION_SERVICE_LAYER, ADAPTER_LAYER).whereLayer(DOMAIN_SERVICE_LAYER).mayOnlyBeAccessedByLayers(APPLICATION_SERVICE_LAYER, ADAPTER_LAYER).whereLayer(APPLICATION_SERVICE_LAYER).mayOnlyBeAccessedByLayers(ADAPTER_LAYER).withOptionalLayers(this.optionalLayers);
            for (Map.Entry<String, String[]> adapter : this.adapterPackageIdentifiers.entrySet()) {
                String adapterLayer = this.getAdapterLayer(adapter.getKey());
                layeredArchitectureDelegate = layeredArchitectureDelegate.layer(adapterLayer).definedBy(adapter.getValue()).whereLayer(adapterLayer).mayNotBeAccessedByAnyLayer();
            }
            for (IgnoredDependency ignoredDependency : this.ignoredDependencies) {
                layeredArchitectureDelegate = ignoredDependency.ignoreFor(layeredArchitectureDelegate);
            }
            return layeredArchitectureDelegate.as(this.getDescription());
        }

        private String[] concatenateAll(Collection<String[]> arrays) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String[] array : arrays) {
                resultList.addAll(Arrays.asList(array));
            }
            return resultList.toArray(new String[0]);
        }

        private String getAdapterLayer(String name) {
            return String.format("%s %s", name, ADAPTER_LAYER);
        }

        @Override
        public void check(JavaClasses classes) {
            this.layeredArchitectureDelegate().check(classes);
        }

        @Override
        public ArchRule because(String reason) {
            return ArchRule.Factory.withBecause(this, reason);
        }

        @Override
        public OnionArchitecture as(String newDescription) {
            return new OnionArchitecture(this.domainModelPackageIdentifiers, this.domainServicePackageIdentifiers, this.applicationPackageIdentifiers, this.adapterPackageIdentifiers, Optional.of(newDescription));
        }

        @Override
        public EvaluationResult evaluate(JavaClasses classes) {
            return this.layeredArchitectureDelegate().evaluate(classes);
        }

        @Override
        public String getDescription() {
            if (this.overriddenDescription.isPresent()) {
                return this.overriddenDescription.get();
            }
            ArrayList<String> lines = Lists.newArrayList("Onion architecture consisting of" + (this.optionalLayers ? " (optional)" : ""));
            if (this.domainModelPackageIdentifiers.length > 0) {
                lines.add(String.format("domain models ('%s')", Joiner.on("', '").join(this.domainModelPackageIdentifiers)));
            }
            if (this.domainServicePackageIdentifiers.length > 0) {
                lines.add(String.format("domain services ('%s')", Joiner.on("', '").join(this.domainServicePackageIdentifiers)));
            }
            if (this.applicationPackageIdentifiers.length > 0) {
                lines.add(String.format("application services ('%s')", Joiner.on("', '").join(this.applicationPackageIdentifiers)));
            }
            for (Map.Entry<String, String[]> adapter : this.adapterPackageIdentifiers.entrySet()) {
                lines.add(String.format("adapter '%s' ('%s')", adapter.getKey(), Joiner.on("', '").join(adapter.getValue())));
            }
            return Joiner.on(System.lineSeparator()).join(lines);
        }

        private static class IgnoredDependency {
            private final DescribedPredicate<? super JavaClass> origin;
            private final DescribedPredicate<? super JavaClass> target;

            IgnoredDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
                this.origin = origin;
                this.target = target;
            }

            LayeredArchitecture ignoreFor(LayeredArchitecture layeredArchitecture) {
                return layeredArchitecture.ignoreDependency(this.origin, this.target);
            }
        }
    }

    public static final class LayeredArchitecture
    implements ArchRule {
        private final LayerDefinitions layerDefinitions;
        private final Set<LayerDependencySpecification> dependencySpecifications;
        private final PredicateAggregator<Dependency> irrelevantDependenciesPredicate;
        private final Optional<String> overriddenDescription;
        private boolean optionalLayers;

        private LayeredArchitecture() {
            this(new LayerDefinitions(), new LinkedHashSet<LayerDependencySpecification>(), new PredicateAggregator().thatORs(), Optional.absent(), false);
        }

        private LayeredArchitecture(LayerDefinitions layerDefinitions, Set<LayerDependencySpecification> dependencySpecifications, PredicateAggregator<Dependency> irrelevantDependenciesPredicate, Optional<String> overriddenDescription, boolean optionalLayers) {
            this.layerDefinitions = layerDefinitions;
            this.dependencySpecifications = dependencySpecifications;
            this.irrelevantDependenciesPredicate = irrelevantDependenciesPredicate;
            this.overriddenDescription = overriddenDescription;
            this.optionalLayers = optionalLayers;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture withOptionalLayers(boolean optionalLayers) {
            this.optionalLayers = optionalLayers;
            return this;
        }

        private LayeredArchitecture addLayerDefinition(LayerDefinition definition) {
            this.layerDefinitions.add(definition);
            return this;
        }

        private LayeredArchitecture addDependencySpecification(LayerDependencySpecification dependencySpecification) {
            this.dependencySpecifications.add(dependencySpecification);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDefinition layer(String name) {
            return new LayerDefinition(name, false);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDefinition optionalLayer(String name) {
            return new LayerDefinition(name, true);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            if (this.overriddenDescription.isPresent()) {
                return this.overriddenDescription.get();
            }
            ArrayList<String> lines = Lists.newArrayList("Layered architecture consisting of" + (this.optionalLayers ? " (optional)" : ""));
            for (LayerDefinition definition : this.layerDefinitions) {
                lines.add(definition.toString());
            }
            for (LayerDependencySpecification specification : this.dependencySpecifications) {
                lines.add(specification.toString());
            }
            return Joiner.on(System.lineSeparator()).join(lines);
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public EvaluationResult evaluate(JavaClasses classes) {
            EvaluationResult result = new EvaluationResult(this, Priority.MEDIUM);
            this.checkEmptyLayers(classes, result);
            for (LayerDependencySpecification specification : this.dependencySpecifications) {
                result.add(this.evaluateDependenciesShouldBeSatisfied(classes, specification));
            }
            return result;
        }

        private void checkEmptyLayers(JavaClasses classes, EvaluationResult result) {
            if (!this.optionalLayers) {
                for (LayerDefinition layerDefinition : this.layerDefinitions) {
                    if (layerDefinition.isOptional()) continue;
                    result.add(this.evaluateLayersShouldNotBeEmpty(classes, layerDefinition));
                }
            }
        }

        private EvaluationResult evaluateLayersShouldNotBeEmpty(JavaClasses classes, LayerDefinition layerDefinition) {
            return ArchRuleDefinition.classes().that((DescribedPredicate<? super JavaClass>)this.layerDefinitions.containsPredicateFor(layerDefinition.name)).should((ArchCondition<? super JavaClass>)LayeredArchitecture.notBeEmptyFor(layerDefinition)).evaluate(classes);
        }

        private EvaluationResult evaluateDependenciesShouldBeSatisfied(JavaClasses classes, LayerDependencySpecification specification) {
            return ArchRuleDefinition.classes().that((DescribedPredicate<? super JavaClass>)this.layerDefinitions.containsPredicateFor(specification.layerName)).should((ArchCondition<? super JavaClass>)ArchConditions.onlyHaveDependentsWhere(this.originMatchesIfDependencyIsRelevant(specification.layerName, specification.allowedAccessors))).evaluate(classes);
        }

        private DescribedPredicate<Dependency> originMatchesIfDependencyIsRelevant(String ownLayer, Set<String> allowedAccessors) {
            DescribedPredicate<Dependency> originPackageMatches = Dependency.Predicates.dependencyOrigin(this.layerDefinitions.containsPredicateFor(allowedAccessors)).or(Dependency.Predicates.dependencyOrigin(this.layerDefinitions.containsPredicateFor(ownLayer)));
            return this.irrelevantDependenciesPredicate.isPresent() ? originPackageMatches.or(this.irrelevantDependenciesPredicate.get()) : originPackageMatches;
        }

        private static ArchCondition<JavaClass> notBeEmptyFor(LayerDefinition layerDefinition) {
            return new LayerShouldNotBeEmptyCondition(layerDefinition);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public void check(JavaClasses classes) {
            ArchRule.Assertions.check(this, classes);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ArchRule because(String reason) {
            return ArchRule.Factory.withBecause(this, reason);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture as(String newDescription) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.irrelevantDependenciesPredicate, Optional.of(newDescription), this.optionalLayers);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(Class<?> origin, Class<?> target) {
            return this.ignoreDependency(JavaClass.Predicates.equivalentTo(origin), JavaClass.Predicates.equivalentTo(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(String origin, String target) {
            return this.ignoreDependency(HasName.Predicates.name(origin), HasName.Predicates.name(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.irrelevantDependenciesPredicate.add(Dependency.Predicates.dependency(origin, target)), this.overriddenDescription, this.optionalLayers);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDependencySpecification whereLayer(String name) {
            this.checkLayerNamesExist(name);
            return new LayerDependencySpecification(name);
        }

        private void checkLayerNamesExist(String ... layerNames) {
            for (String layerName : layerNames) {
                Preconditions.checkArgument(this.layerDefinitions.containLayer(layerName), "There is no layer named '%s'", (Object)layerName);
            }
        }

        public final class LayerDependencySpecification {
            private final String layerName;
            private final Set<String> allowedAccessors = new LinkedHashSet<String>();
            private String descriptionSuffix;

            private LayerDependencySpecification(String layerName) {
                this.layerName = layerName;
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayNotBeAccessedByAnyLayer() {
                this.descriptionSuffix = "may not be accessed by any layer";
                return LayeredArchitecture.this.addDependencySpecification(this);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayOnlyBeAccessedByLayers(String ... layerNames) {
                LayeredArchitecture.this.checkLayerNamesExist(layerNames);
                this.allowedAccessors.addAll(Arrays.asList(layerNames));
                this.descriptionSuffix = String.format("may only be accessed by layers ['%s']", Joiner.on("', '").join(this.allowedAccessors));
                return LayeredArchitecture.this.addDependencySpecification(this);
            }

            public String toString() {
                return String.format("where layer '%s' %s", this.layerName, this.descriptionSuffix);
            }
        }

        public final class LayerDefinition {
            private final String name;
            private final boolean optional;
            private DescribedPredicate<JavaClass> containsPredicate;

            private LayerDefinition(String name, boolean optional) {
                Preconditions.checkState(!Strings.isNullOrEmpty(name), "Layer name must be present");
                this.name = name;
                this.optional = optional;
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture definedBy(DescribedPredicate<? super JavaClass> predicate) {
                Preconditions.checkNotNull(predicate, "Supplied predicate must not be null");
                this.containsPredicate = predicate.forSubType();
                return LayeredArchitecture.this.addLayerDefinition(this);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture definedBy(String ... packageIdentifiers) {
                String description = String.format("'%s'", Joiner.on("', '").join(packageIdentifiers));
                return this.definedBy(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers).as(description, new Object[0]));
            }

            boolean isOptional() {
                return this.optional;
            }

            DescribedPredicate<JavaClass> containsPredicate() {
                return this.containsPredicate;
            }

            public String toString() {
                return String.format("%slayer '%s' (%s)", this.optional ? "optional " : "", this.name, this.containsPredicate);
            }
        }

        private static final class LayerDefinitions
        implements Iterable<LayerDefinition> {
            private final Map<String, LayerDefinition> layerDefinitions = new LinkedHashMap<String, LayerDefinition>();

            private LayerDefinitions() {
            }

            void add(LayerDefinition definition) {
                this.layerDefinitions.put(definition.name, definition);
            }

            boolean containLayer(String layerName) {
                return this.layerDefinitions.containsKey(layerName);
            }

            DescribedPredicate<JavaClass> containsPredicateFor(String layerName) {
                return this.containsPredicateFor(Collections.singleton(layerName));
            }

            DescribedPredicate<JavaClass> containsPredicateFor(Collection<String> layerNames) {
                DescribedPredicate<JavaClass> result = DescribedPredicate.alwaysFalse();
                for (LayerDefinition definition : this.get(layerNames)) {
                    result = result.or(definition.containsPredicate());
                }
                return result;
            }

            private Iterable<LayerDefinition> get(Collection<String> layerNames) {
                HashSet<LayerDefinition> result = new HashSet<LayerDefinition>();
                for (String layerName : layerNames) {
                    result.add(this.layerDefinitions.get(layerName));
                }
                return result;
            }

            @Override
            public Iterator<LayerDefinition> iterator() {
                return this.layerDefinitions.values().iterator();
            }
        }

        private static class LayerShouldNotBeEmptyCondition
        extends ArchCondition<JavaClass> {
            private final LayerDefinition layerDefinition;
            private boolean empty = true;

            LayerShouldNotBeEmptyCondition(LayerDefinition layerDefinition) {
                super("not be empty", new Object[0]);
                this.layerDefinition = layerDefinition;
            }

            @Override
            public void check(JavaClass item, ConditionEvents events) {
                this.empty = false;
            }

            @Override
            public void finish(ConditionEvents events) {
                if (this.empty) {
                    events.add(SimpleConditionEvent.violated(this.layerDefinition, String.format("Layer '%s' is empty", this.layerDefinition.name)));
                }
            }
        }
    }
}

