/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.extension;

import com.tngtech.archunit.lang.extension.ArchUnitExtension;
import com.tngtech.archunit.lang.extension.ExtensionLoadingException;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchUnitExtensionLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ArchUnitExtensionLoader.class);
    private final Supplier<Iterable<ArchUnitExtension>> extensions = Suppliers.memoize(new Supplier<Iterable<ArchUnitExtension>>(){

        @Override
        public Iterable<ArchUnitExtension> get() {
            ServiceLoader<ArchUnitExtension> extensions = ServiceLoader.load(ArchUnitExtension.class);
            this.log(extensions);
            this.checkIdentifiersNonNull(extensions);
            this.checkIdentifiersValid(extensions);
            this.checkIdentifiersUnique(extensions);
            return extensions;
        }

        private void log(ServiceLoader<ArchUnitExtension> extensions) {
            for (ArchUnitExtension extension : extensions) {
                LOG.info("Loaded {} with id '{}'", (Object)ArchUnitExtension.class.getSimpleName(), (Object)extension.getUniqueIdentifier());
            }
        }

        private void checkIdentifiersNonNull(Iterable<ArchUnitExtension> extensions) {
            for (ArchUnitExtension extension : extensions) {
                if (extension.getUniqueIdentifier() != null) continue;
                this.throwLoadingException(extension, "Extension identifier must not be null", new Object[0]);
            }
        }

        private void checkIdentifiersValid(ServiceLoader<ArchUnitExtension> extensions) {
            for (ArchUnitExtension extension : extensions) {
                if (!extension.getUniqueIdentifier().contains(".")) continue;
                this.throwLoadingException(extension, "Extension identifier '%s' must not contain '.'", extension.getUniqueIdentifier());
            }
        }

        private void checkIdentifiersUnique(Iterable<ArchUnitExtension> extensions) {
            HashMap<String, ArchUnitExtension> alreadyPresent = new HashMap<String, ArchUnitExtension>();
            for (ArchUnitExtension extension : extensions) {
                if (alreadyPresent.containsKey(extension.getUniqueIdentifier())) {
                    String presentExtensionName = ((ArchUnitExtension)alreadyPresent.get(extension.getUniqueIdentifier())).getClass().getName();
                    this.throwLoadingException(extension, "Extension identifiers must be unique, but %s also has identifier '%s'", presentExtensionName, extension.getUniqueIdentifier());
                }
                alreadyPresent.put(extension.getUniqueIdentifier(), extension);
            }
        }

        private void throwLoadingException(ArchUnitExtension extension, String messageTemplate, Object ... args) {
            String loadingFailedMessage = String.format("Failed to load %s: ", extension.getClass().getName());
            String details = String.format(messageTemplate, args);
            throw new ExtensionLoadingException(loadingFailedMessage + details);
        }
    });

    ArchUnitExtensionLoader() {
    }

    Iterable<ArchUnitExtension> getAll() {
        return this.extensions.get();
    }
}

