/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;

class NeverCondition<T>
extends ArchCondition<T> {
    private final ArchCondition<T> condition;

    NeverCondition(ArchCondition<T> condition) {
        super("never " + condition.getDescription(), new Object[0]);
        this.condition = condition;
    }

    @Override
    public void init(Iterable<T> allObjectsToTest) {
        this.condition.init(allObjectsToTest);
    }

    @Override
    public void finish(ConditionEvents events) {
        ConditionEvents subEvents = new ConditionEvents();
        this.condition.finish(subEvents);
        for (ConditionEvent event : subEvents) {
            event.addInvertedTo(events);
        }
    }

    @Override
    public void check(T item, ConditionEvents events) {
        ConditionEvents subEvents = new ConditionEvents();
        this.condition.check(item, subEvents);
        for (ConditionEvent event : subEvents) {
            event.addInvertedTo(events);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{condition=" + this.condition + "}";
    }
}

