/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.PackageMatchers;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.AllAccessesCondition;
import com.tngtech.archunit.lang.conditions.AllAttributesMatchCondition;
import com.tngtech.archunit.lang.conditions.AllDependenciesCondition;
import com.tngtech.archunit.lang.conditions.AnyDependencyCondition;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.conditions.ClassAccessesCondition;
import com.tngtech.archunit.lang.conditions.ClassAccessesFieldCondition;
import com.tngtech.archunit.lang.conditions.ClassOnlyAccessesCondition;
import com.tngtech.archunit.lang.conditions.ContainAnyCondition;
import com.tngtech.archunit.lang.conditions.ContainsOnlyCondition;
import com.tngtech.archunit.lang.conditions.JavaAccessPackagePredicate;
import com.tngtech.archunit.lang.conditions.NeverCondition;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ArchConditions {
    private static final IsConditionByPredicate<JavaClass> BE_TOP_LEVEL_CLASSES = new IsConditionByPredicate<JavaClass>("a top level class", JavaClass.Predicates.TOP_LEVEL_CLASSES);
    private static final IsConditionByPredicate<JavaClass> BE_NESTED_CLASSES = new IsConditionByPredicate<JavaClass>("a nested class", JavaClass.Predicates.NESTED_CLASSES);
    private static final IsConditionByPredicate<JavaClass> BE_MEMBER_CLASSES = new IsConditionByPredicate<JavaClass>("a member class", JavaClass.Predicates.MEMBER_CLASSES);
    private static final IsConditionByPredicate<JavaClass> BE_INNER_CLASSES = new IsConditionByPredicate<JavaClass>("an inner class", JavaClass.Predicates.INNER_CLASSES);
    private static final IsConditionByPredicate<JavaClass> BE_ANONYMOUS_CLASSES = new IsConditionByPredicate<JavaClass>("an anonymous class", JavaClass.Predicates.ANONYMOUS_CLASSES);
    private static final IsConditionByPredicate<JavaClass> BE_LOCAL_CLASSES = new IsConditionByPredicate<JavaClass>("a local class", JavaClass.Predicates.LOCAL_CLASSES);

    private ArchConditions() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getField(Class<?> owner, String fieldName) {
        return ArchConditions.getField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getField(String ownerName, String fieldName) {
        return ArchConditions.getFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("get field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition.ClassGetsFieldCondition(predicate).as("get field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setField(Class<?> owner, String fieldName) {
        return ArchConditions.setField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setField(String ownerName, String fieldName) {
        return ArchConditions.setFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("set field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition.ClassSetsFieldCondition(predicate).as("set field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessField(Class<?> owner, String fieldName) {
        return ArchConditions.accessField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessField(String ownerName, String fieldName) {
        return ArchConditions.accessFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("access field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition(predicate).as("access field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessFieldsThat(DescribedPredicate<? super JavaField> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(AccessTarget.FieldAccessTarget.Functions.RESOLVE).is(DescribedPredicate.anyElementThat(predicate.forSubType()).or(DescribedPredicate.empty()));
        return new ClassOnlyAccessesCondition<JavaFieldAccess>(accessPredicate, JavaClass.Functions.GET_FIELD_ACCESSES_FROM_SELF).as("only access fields that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethod(Class<?> owner, String methodName, Class<?> ... parameterTypes) {
        return ArchConditions.callMethodWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(JavaClass.Predicates.type(owner))).and(JavaCall.Predicates.target(HasName.Predicates.name(methodName))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes)))).as("call method %s", Formatters.formatMethodSimple(owner.getSimpleName(), methodName, JavaClass.namesOf(parameterTypes)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethod(String ownerName, String methodName, String ... parameterTypeNames) {
        return ArchConditions.callMethodWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaCall.Predicates.target(HasName.Predicates.name(methodName))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames)))).as("call method %s", Formatters.formatMethodSimple(Formatters.ensureSimpleName(ownerName), methodName, Arrays.asList(parameterTypeNames)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethodWhere(DescribedPredicate<? super JavaMethodCall> predicate) {
        return new ClassAccessesCondition<JavaMethodCall>(predicate, JavaClass.Functions.GET_METHOD_CALLS_FROM_SELF).as("call method where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallMethodsThat(DescribedPredicate<? super JavaMethod> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.MethodCallTarget.Functions.RESOLVE).is(DescribedPredicate.anyElementThat(predicate.forSubType()).or(DescribedPredicate.empty()));
        return new ClassOnlyAccessesCondition<JavaMethodCall>(callPredicate, JavaClass.Functions.GET_METHOD_CALLS_FROM_SELF).as("only call methods that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructor(Class<?> owner, Class<?> ... parameterTypes) {
        return ArchConditions.callConstructorWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(JavaClass.Predicates.type(owner))).and(JavaCall.Predicates.target(HasName.Predicates.name("<init>"))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes)))).as("call constructor %s", Formatters.formatMethodSimple(owner.getSimpleName(), "<init>", JavaClass.namesOf(parameterTypes)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructor(String ownerName, String ... parameterTypeNames) {
        return ArchConditions.callConstructorWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaCall.Predicates.target(HasName.Predicates.name("<init>"))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames)))).as("call constructor %s", Formatters.formatMethodSimple(Formatters.ensureSimpleName(ownerName), "<init>", Arrays.asList(parameterTypeNames)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructorWhere(DescribedPredicate<? super JavaConstructorCall> predicate) {
        return new ClassAccessesCondition<JavaConstructorCall>(predicate, JavaClass.Functions.GET_CONSTRUCTOR_CALLS_FROM_SELF).as("call constructor where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallConstructorsThat(DescribedPredicate<? super JavaConstructor> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.ConstructorCallTarget.Functions.RESOLVE).is(DescribedPredicate.anyElementThat(predicate.forSubType()).or(DescribedPredicate.empty()));
        return new ClassOnlyAccessesCondition<JavaConstructorCall>(callPredicate, JavaClass.Functions.GET_CONSTRUCTOR_CALLS_FROM_SELF).as("only call constructors that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callCodeUnitWhere(DescribedPredicate<? super JavaCall<?>> predicate) {
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_CALLS_FROM_SELF).as("call code unit where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallCodeUnitsThat(DescribedPredicate<? super JavaCodeUnit> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.CodeUnitCallTarget.Functions.RESOLVE).is(DescribedPredicate.anyElementThat(predicate.forSubType()).or(DescribedPredicate.empty()));
        return new ClassOnlyAccessesCondition(callPredicate, JavaClass.Functions.GET_CALLS_FROM_SELF).as("only call code units that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessMembersThat(DescribedPredicate<? super JavaMember> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(AccessTarget.Functions.RESOLVE).is(DescribedPredicate.anyElementThat(predicate.forSubType()).or(DescribedPredicate.empty()));
        return new ClassOnlyAccessesCondition(accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("only access members that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessTargetWhere(DescribedPredicate<? super JavaAccess<?>> predicate) {
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(HasOwner.Functions.Get.owner()).is(predicate);
        return new ClassAccessesCondition(accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("access classes that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate<JavaAccess<?>> accessPredicate = getTarget.then(HasOwner.Functions.Get.owner()).is(predicate);
        return new AllAccessesCondition("only access classes that", accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> dependOnClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AnyDependencyCondition("depend on classes that " + predicate.getDescription(), Dependency.Functions.GET_TARGET_CLASS.is(predicate), JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyDependOnClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AllDependenciesCondition("only depend on classes that " + predicate.getDescription(), Dependency.Functions.GET_TARGET_CLASS.is(predicate), JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyBeAccessedByClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AllAccessesCondition("only be accessed by classes that", JavaAccess.Functions.Get.origin().then(HasOwner.Functions.Get.owner()).is(predicate), JavaClass.Functions.GET_ACCESSES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThatResideIn(String packageIdentifier) {
        return ArchConditions.accessClassesThatResideInAnyPackage(packageIdentifier).as("access classes that reside in package '%s'", packageIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThatResideInAnyPackage(String ... packageIdentifiers) {
        JavaAccessPackagePredicate predicate = JavaAccessPackagePredicate.forAccessTarget().matching(packageIdentifiers);
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("access classes that reside in " + predicate, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyBeAccessedByAnyPackage(String ... packageIdentifiers) {
        return new AllAccessesCondition("only be accessed by", JavaAccessPackagePredicate.forAccessOrigin().matching(packageIdentifiers), JavaClass.Functions.GET_ACCESSES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentsInAnyPackage(String ... packageIdentifiers) {
        String description = String.format("only have dependents in any package ['%s']", Joiner.on("', '").join(packageIdentifiers));
        return ArchConditions.onlyHaveDependentsWhere(Dependency.Predicates.dependencyOrigin(JavaClass.Functions.GET_PACKAGE_NAME.is(PackageMatchers.of(packageIdentifiers)))).as(description, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.onlyHaveDependentsWhere(Dependency.Functions.GET_ORIGIN_CLASS.is(predicate)).as("only have dependent classes that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentsWhere(DescribedPredicate<? super Dependency> predicate) {
        String description = "only have dependents where " + predicate.getDescription();
        return new AllDependenciesCondition(description, predicate, JavaClass.Functions.GET_DIRECT_DEPENDENCIES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static AllDependenciesCondition onlyHaveDependenciesInAnyPackage(String ... packageIdentifiers) {
        String description = String.format("only have dependencies in any package ['%s']", Joiner.on("', '").join(packageIdentifiers));
        return ArchConditions.onlyHaveDependenciesWhere(Dependency.Predicates.dependencyTarget(JavaClass.Functions.GET_PACKAGE_NAME.is(PackageMatchers.of(packageIdentifiers)))).as(description, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static AllDependenciesCondition onlyHaveDependenciesWhere(DescribedPredicate<? super Dependency> predicate) {
        String description = "only have dependencies where " + predicate.getDescription();
        return new AllDependenciesCondition(description, predicate, JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> never(ArchCondition<T> condition) {
        return new NeverCondition<T>(condition);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> not(ArchCondition<T> condition) {
        return ArchConditions.never(condition).as("not " + condition.getDescription(), new Object[0]);
    }

    static <T> ArchCondition<Collection<? extends T>> containAnyElementThat(ArchCondition<T> condition) {
        return new ContainAnyCondition<T>(condition);
    }

    static <T> ArchCondition<Collection<? extends T>> containOnlyElementsThat(ArchCondition<T> condition) {
        return new ContainsOnlyCondition<T>(condition);
    }

    private static DescribedPredicate<? super JavaFieldAccess> ownerAndNameAre(String ownerName, String fieldName) {
        return JavaFieldAccess.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaFieldAccess.Predicates.target(HasName.Predicates.name(fieldName))).as(ownerName + "." + fieldName, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> be(Class<?> clazz) {
        return ArchConditions.be(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBe(Class<?> clazz) {
        return ArchConditions.not(ArchConditions.be(clazz));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> be(String className) {
        return new BeClassCondition(className);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBe(String className) {
        return ArchConditions.not(ArchConditions.be(className));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveName(String name) {
        return new HaveConditionByPredicate<HasName>(HasName.Predicates.name(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> notHaveName(String name) {
        return ArchConditions.not(ArchConditions.haveName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullName(String fullName) {
        return new HaveConditionByPredicate<HasName.AndFullName>(HasName.AndFullName.Predicates.fullName(fullName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> notHaveFullName(String fullName) {
        return ArchConditions.not(new HaveConditionByPredicate<HasName.AndFullName>(HasName.AndFullName.Predicates.fullName(fullName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveFullyQualifiedName(String name) {
        return new HaveConditionByPredicate<HasName>(ArchConditions.fullyQualifiedName(name));
    }

    @Internal
    public static DescribedPredicate<HasName> fullyQualifiedName(String name) {
        DescribedPredicate<HasName> predicate = HasName.Predicates.name(name);
        return predicate.as("fully qualified " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notHaveFullyQualifiedName(String name) {
        return ArchConditions.not(ArchConditions.haveFullyQualifiedName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleName(String name) {
        DescribedPredicate<JavaClass> haveSimpleName = ArchPredicates.have(JavaClass.Predicates.simpleName(name));
        return new SimpleNameCondition(haveSimpleName, name);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notHaveSimpleName(String name) {
        return ArchConditions.not(ArchConditions.haveSimpleName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameStartingWith(String prefix) {
        DescribedPredicate<JavaClass> predicate = ArchPredicates.have(JavaClass.Predicates.simpleNameStartingWith(prefix));
        return new SimpleNameStartingWithCondition(predicate, prefix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotStartingWith(String prefix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameStartingWith(prefix)).as("have simple name not starting with '%s'", prefix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameContaining(String infix) {
        DescribedPredicate<JavaClass> predicate = ArchPredicates.have(JavaClass.Predicates.simpleNameContaining(infix));
        return new SimpleNameContainingCondition(predicate, infix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotContaining(String infix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameContaining(infix)).as("have simple name not containing '%s'", infix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameEndingWith(String suffix) {
        DescribedPredicate<JavaClass> predicate = ArchPredicates.have(JavaClass.Predicates.simpleNameEndingWith(suffix));
        return new SimpleNameEndingWithCondition(predicate, suffix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotEndingWith(String suffix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameEndingWith(suffix)).as("have simple name not ending with '%s'", suffix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameMatching(String regex) {
        DescribedPredicate haveNameMatching = ArchPredicates.have(HasName.Predicates.nameMatching(regex)).forSubType();
        return new MatchingCondition(haveNameMatching, regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameNotMatching(String regex) {
        return ArchConditions.not(ArchConditions.haveNameMatching(regex)).as("have name not matching '%s'", regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullNameMatching(String regex) {
        DescribedPredicate haveFullNameMatching = ArchPredicates.have(HasName.AndFullName.Predicates.fullNameMatching(regex)).forSubType();
        return new MatchingCondition(haveFullNameMatching, regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullNameNotMatching(String regex) {
        return ArchConditions.not(ArchConditions.haveFullNameMatching(regex)).as("have full name not matching '%s'", regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideInAPackage(String packageIdentifier) {
        return new DoesConditionByPredicate<JavaClass>(JavaClass.Predicates.resideInAPackage(packageIdentifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideInAnyPackage(String ... packageIdentifiers) {
        return new DoesConditionByPredicate<JavaClass>(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideOutsideOfPackage(String packageIdentifier) {
        return new DoesConditionByPredicate<JavaClass>(JavaClass.Predicates.resideOutsideOfPackage(packageIdentifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideOutsideOfPackages(String ... packageIdentifiers) {
        return new DoesConditionByPredicate<JavaClass>(JavaClass.Predicates.resideOutsideOfPackages(packageIdentifiers));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> haveModifier(JavaModifier modifier) {
        return new HaveConditionByPredicate<HasModifiers>(HasModifiers.Predicates.modifier(modifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notHaveModifier(JavaModifier modifier) {
        return ArchConditions.not(ArchConditions.haveModifier(modifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePublic() {
        return ArchConditions.haveModifier(JavaModifier.PUBLIC).as("be public", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePublic() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PUBLIC)).as("not be public", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beProtected() {
        return ArchConditions.haveModifier(JavaModifier.PROTECTED).as("be protected", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeProtected() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PROTECTED)).as("not be protected", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePackagePrivate() {
        return ArchConditions.not(ArchConditions.notBePackagePrivate()).as("be package private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePackagePrivate() {
        return ArchConditions.haveModifier(JavaModifier.PUBLIC).or(ArchConditions.haveModifier(JavaModifier.PROTECTED)).or(ArchConditions.haveModifier(JavaModifier.PRIVATE)).as("not be package private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePrivate() {
        return ArchConditions.haveModifier(JavaModifier.PRIVATE).as("be private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePrivate() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PRIVATE)).as("not be private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beStatic() {
        return ArchConditions.haveModifier(JavaModifier.STATIC).as("be static", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeStatic() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.STATIC).as("be static", new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beFinal() {
        return ArchConditions.haveModifier(JavaModifier.FINAL).as("be final", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeFinal() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.FINAL).as("be final", new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveOnlyFinalFields() {
        return new HaveOnlyModifiersCondition<JavaField>("final fields", JavaModifier.FINAL, JavaClass.Functions.GET_FIELDS);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveOnlyPrivateConstructors() {
        return new HaveOnlyModifiersCondition<JavaConstructor>("private constructors", JavaModifier.PRIVATE, JavaClass.Functions.GET_CONSTRUCTORS);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(Class<? extends Annotation> type) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.annotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(String typeName) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.annotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(String typeName) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.annotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(Class<? extends Annotation> type) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.metaAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(String typeName) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.metaAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(String typeName) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return new IsConditionByPredicate<CanBeAnnotated>(CanBeAnnotated.Predicates.metaAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(Class<?> interfaceType) {
        return new ImplementsCondition(JavaClass.Predicates.implement(interfaceType));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(Class<?> interfaceType) {
        return ArchConditions.not(ArchConditions.implement(interfaceType));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(String interfaceTypeName) {
        return new ImplementsCondition(JavaClass.Predicates.implement(interfaceTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(String interfaceTypeName) {
        return ArchConditions.not(ArchConditions.implement(interfaceTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(DescribedPredicate<? super JavaClass> predicate) {
        return new ImplementsCondition(JavaClass.Predicates.implement(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.implement(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(Class<?> type) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableTo(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(Class<?> type) {
        return ArchConditions.not(ArchConditions.beAssignableTo(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(String typeName) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableTo(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(String typeName) {
        return ArchConditions.not(ArchConditions.beAssignableTo(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableTo(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.beAssignableTo(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(Class<?> type) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableFrom(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(Class<?> type) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(String typeName) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableFrom(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(String typeName) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        return new IsConditionByPredicate<JavaClass>(JavaClass.Predicates.assignableFrom(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beInterfaces() {
        return InterfacesCondition.BE_INTERFACES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeInterfaces() {
        return ArchConditions.not(InterfacesCondition.BE_INTERFACES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beEnums() {
        return EnumsCondition.BE_ENUMS;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeEnums() {
        return ArchConditions.not(EnumsCondition.BE_ENUMS);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beTopLevelClasses() {
        return BE_TOP_LEVEL_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeTopLevelClasses() {
        return ArchConditions.not(BE_TOP_LEVEL_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beNestedClasses() {
        return BE_NESTED_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeNestedClasses() {
        return ArchConditions.not(BE_NESTED_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beMemberClasses() {
        return BE_MEMBER_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeMemberClasses() {
        return ArchConditions.not(BE_MEMBER_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beInnerClasses() {
        return BE_INNER_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeInnerClasses() {
        return ArchConditions.not(BE_INNER_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAnonymousClasses() {
        return BE_ANONYMOUS_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAnonymousClasses() {
        return ArchConditions.not(BE_ANONYMOUS_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beLocalClasses() {
        return BE_LOCAL_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeLocalClasses() {
        return ArchConditions.not(BE_LOCAL_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> containNumberOfElements(DescribedPredicate<? super Integer> predicate) {
        return new NumberOfElementsCondition(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredIn(Class<?> owner) {
        return new IsConditionByPredicate<JavaMember>(JavaMember.Predicates.declaredIn(owner));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> notBeDeclaredIn(Class<?> owner) {
        return ArchConditions.not(ArchConditions.beDeclaredIn(owner));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredIn(String ownerTypeName) {
        return new IsConditionByPredicate<JavaMember>(JavaMember.Predicates.declaredIn(ownerTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> notBeDeclaredIn(String ownerTypeName) {
        return ArchConditions.not(ArchConditions.beDeclaredIn(ownerTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredInClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        DescribedPredicate<JavaMember> declaredIn = JavaMember.Predicates.declaredIn(predicate.as("classes that " + predicate.getDescription(), new Object[0]));
        return new IsConditionByPredicate<JavaMember>(declaredIn);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(Class<?> type) {
        return new HaveConditionByPredicate<HasType>(HasType.Predicates.rawType(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(String typeName) {
        return new HaveConditionByPredicate<HasType>(HasType.Predicates.rawType(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(DescribedPredicate<? super JavaClass> predicate) {
        return new HaveConditionByPredicate<HasType>(HasType.Predicates.rawType(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(Class<?> ... parameterTypes) {
        return new HaveConditionByPredicate<HasParameterTypes>(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(String ... parameterTypeNames) {
        return new HaveConditionByPredicate<HasParameterTypes>(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(DescribedPredicate<? super List<JavaClass>> predicate) {
        return new HaveConditionByPredicate<HasParameterTypes>(HasParameterTypes.Predicates.rawParameterTypes(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(Class<?> type) {
        return new HaveConditionByPredicate<HasReturnType>(HasReturnType.Predicates.rawReturnType(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(String typeName) {
        return new HaveConditionByPredicate<HasReturnType>(HasReturnType.Predicates.rawReturnType(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(DescribedPredicate<? super JavaClass> predicate) {
        return new HaveConditionByPredicate<HasReturnType>(HasReturnType.Predicates.rawReturnType(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(Class<? extends Throwable> type) {
        return ArchConditions.declareThrowableOfType(JavaClass.Predicates.equivalentTo(type).as(type.getName(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(String typeName) {
        return ArchConditions.declareThrowableOfType(HasName.Predicates.name(typeName).as(typeName, new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(DescribedPredicate<? super JavaClass> predicate) {
        DescribedPredicate<HasThrowsClause<?>> declareThrowableOfType = HasThrowsClause.Predicates.throwsClauseContainingType(predicate).as("declare throwable of type " + predicate.getDescription(), new Object[0]);
        return new DoesConditionByPredicate(declareThrowableOfType);
    }

    private static <T extends HasDescription & HasSourceCodeLocation> String createMessage(T object, String message) {
        return object.getDescription() + " " + message + " in " + ((HasSourceCodeLocation)object).getSourceCodeLocation();
    }

    private static class HaveConditionByPredicate<T extends HasDescription & HasSourceCodeLocation>
    extends ArchCondition<T> {
        private final DescribedPredicate<T> rawType;

        HaveConditionByPredicate(DescribedPredicate<? super T> rawType) {
            super(ArchPredicates.have(rawType).getDescription(), new Object[0]);
            this.rawType = rawType.forSubType();
        }

        @Override
        public void check(T object, ConditionEvents events) {
            boolean satisfied = this.rawType.apply(object);
            String message = ArchConditions.createMessage(object, (satisfied ? "has " : "does not have ") + this.rawType.getDescription());
            events.add(new SimpleConditionEvent(object, satisfied, message));
        }
    }

    private static class IsConditionByPredicate<T extends HasDescription & HasSourceCodeLocation>
    extends ArchCondition<T> {
        private final String eventDescription;
        private final DescribedPredicate<T> predicate;

        IsConditionByPredicate(DescribedPredicate<? super T> predicate) {
            this(predicate.getDescription(), predicate);
        }

        IsConditionByPredicate(String eventDescription, DescribedPredicate<? super T> predicate) {
            super(ArchPredicates.be(predicate).getDescription(), new Object[0]);
            this.eventDescription = eventDescription;
            this.predicate = predicate.forSubType();
        }

        @Override
        public void check(T member, ConditionEvents events) {
            boolean satisfied = this.predicate.apply(member);
            String message = ArchConditions.createMessage(member, (satisfied ? "is " : "is not ") + this.eventDescription);
            events.add(new SimpleConditionEvent(member, satisfied, message));
        }
    }

    private static class DoesConditionByPredicate<T extends HasDescription & HasSourceCodeLocation>
    extends ArchCondition<T> {
        private final DescribedPredicate<? super T> predicate;

        DoesConditionByPredicate(DescribedPredicate<? super T> predicate) {
            super(predicate.getDescription(), new Object[0]);
            this.predicate = predicate;
        }

        @Override
        public void check(T item, ConditionEvents events) {
            boolean satisfied = this.predicate.apply(item);
            String message = ArchConditions.createMessage(item, (satisfied ? "does " : "does not ") + this.predicate.getDescription());
            events.add(new SimpleConditionEvent(item, satisfied, message));
        }
    }

    private static class MatchingCondition<T extends HasDescription & HasSourceCodeLocation>
    extends ArchCondition<T> {
        private final DescribedPredicate<T> matcher;
        private final String regex;

        MatchingCondition(DescribedPredicate<T> matcher, String regex) {
            super(matcher.getDescription(), new Object[0]);
            this.matcher = matcher;
            this.regex = regex;
        }

        @Override
        public void check(T item, ConditionEvents events) {
            boolean satisfied = this.matcher.apply(item);
            String message = ArchConditions.createMessage(item, String.format("%s '%s'", satisfied ? "matches" : "does not match", this.regex));
            events.add(new SimpleConditionEvent(item, satisfied, message));
        }
    }

    private static class SimpleNameEndingWithCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<JavaClass> predicate;
        private final String suffix;

        SimpleNameEndingWithCondition(DescribedPredicate<JavaClass> predicate, String suffix) {
            super(predicate.getDescription(), new Object[0]);
            this.predicate = predicate;
            this.suffix = suffix;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean satisfied = this.predicate.apply(javaClass);
            String message = String.format("simple name of %s %s with '%s' in %s", javaClass.getName(), satisfied ? "ends" : "does not end", this.suffix, javaClass.getSourceCodeLocation());
            events.add(new SimpleConditionEvent(javaClass, satisfied, message));
        }
    }

    private static class SimpleNameContainingCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<JavaClass> predicate;
        private final String infix;

        SimpleNameContainingCondition(DescribedPredicate<JavaClass> predicate, String infix) {
            super(predicate.getDescription(), new Object[0]);
            this.predicate = predicate;
            this.infix = infix;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean satisfied = this.predicate.apply(javaClass);
            String message = String.format("simple name of %s %s '%s' in %s", javaClass.getName(), satisfied ? "contains" : "does not contain", this.infix, javaClass.getSourceCodeLocation());
            events.add(new SimpleConditionEvent(javaClass, satisfied, message));
        }
    }

    private static class SimpleNameStartingWithCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<JavaClass> predicate;
        private final String prefix;

        SimpleNameStartingWithCondition(DescribedPredicate<JavaClass> predicate, String prefix) {
            super(predicate.getDescription(), new Object[0]);
            this.predicate = predicate;
            this.prefix = prefix;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean satisfied = this.predicate.apply(javaClass);
            String message = String.format("simple name of %s %s with '%s' in %s", javaClass.getName(), satisfied ? "starts" : "does not start", this.prefix, javaClass.getSourceCodeLocation());
            events.add(new SimpleConditionEvent(javaClass, satisfied, message));
        }
    }

    private static class SimpleNameCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<JavaClass> haveSimpleName;
        private final String name;

        SimpleNameCondition(DescribedPredicate<JavaClass> haveSimpleName, String name) {
            super(haveSimpleName.getDescription(), new Object[0]);
            this.haveSimpleName = haveSimpleName;
            this.name = name;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean satisfied = this.haveSimpleName.apply(javaClass);
            String message = ArchConditions.createMessage(javaClass, String.format("%s simple name '%s'", satisfied ? "has" : "does not have", this.name));
            events.add(new SimpleConditionEvent(javaClass, satisfied, message));
        }
    }

    private static class BeClassCondition
    extends ArchCondition<JavaClass> {
        private final String className;

        BeClassCondition(String className) {
            super("be " + className, new Object[0]);
            this.className = className;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean itemEquivalentToClazz = javaClass.getName().equals(this.className);
            String message = ArchConditions.createMessage(javaClass, (itemEquivalentToClazz ? "is " : "is not ") + this.className);
            events.add(new SimpleConditionEvent(javaClass, itemEquivalentToClazz, message));
        }
    }

    private static class NumberOfElementsCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<Integer> predicate;
        private SortedSet<String> allClassNames;

        NumberOfElementsCondition(DescribedPredicate<? super Integer> predicate) {
            super("contain number of elements " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubType();
            this.allClassNames = new TreeSet<String>();
        }

        @Override
        public void check(JavaClass item, ConditionEvents events) {
            this.allClassNames.add(item.getName());
        }

        @Override
        public void finish(ConditionEvents events) {
            int size = this.allClassNames.size();
            boolean conditionSatisfied = this.predicate.apply(size);
            String message = String.format("there is/are %d element(s) in classes %s", size, this.join(this.allClassNames));
            events.add(new SimpleConditionEvent(size, conditionSatisfied, message));
        }

        private String join(SortedSet<String> strings) {
            return "[" + Joiner.on(", ").join(strings) + "]";
        }
    }

    private static class EnumsCondition
    extends ArchCondition<JavaClass> {
        private static final EnumsCondition BE_ENUMS = new EnumsCondition();

        EnumsCondition() {
            super("be enums", new Object[0]);
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean isEnum = javaClass.isEnum();
            String message = ArchConditions.createMessage(javaClass, (isEnum ? "is an" : "is not an") + " enum");
            events.add(new SimpleConditionEvent(javaClass, isEnum, message));
        }
    }

    private static class InterfacesCondition
    extends ArchCondition<JavaClass> {
        private static final InterfacesCondition BE_INTERFACES = new InterfacesCondition();

        InterfacesCondition() {
            super("be interfaces", new Object[0]);
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean isInterface = javaClass.isInterface();
            String message = ArchConditions.createMessage(javaClass, (isInterface ? "is an" : "is not an") + " interface");
            events.add(new SimpleConditionEvent(javaClass, isInterface, message));
        }
    }

    private static class ImplementsCondition
    extends ArchCondition<JavaClass> {
        private final DescribedPredicate<? super JavaClass> implement;

        ImplementsCondition(DescribedPredicate<? super JavaClass> implement) {
            super(implement.getDescription(), new Object[0]);
            this.implement = implement;
        }

        @Override
        public void check(JavaClass javaClass, ConditionEvents events) {
            boolean satisfied = this.implement.apply(javaClass);
            String description = satisfied ? this.implement.getDescription().replace("implement", "implements") : this.implement.getDescription().replace("implement", "does not implement");
            String message = ArchConditions.createMessage(javaClass, description);
            events.add(new SimpleConditionEvent(javaClass, satisfied, message));
        }
    }

    private static class ModifierCondition<T extends HasModifiers & HasDescription>
    extends ArchCondition<T> {
        private final JavaModifier modifier;

        ModifierCondition(JavaModifier modifier) {
            super("modifier " + (Object)((Object)modifier), new Object[0]);
            this.modifier = modifier;
        }

        @Override
        public void check(T hasModifiers, ConditionEvents events) {
            boolean satisfied = hasModifiers.getModifiers().contains((Object)this.modifier);
            String infix = (satisfied ? "is " : "is not ") + this.modifier.toString().toLowerCase();
            events.add(new SimpleConditionEvent(hasModifiers, satisfied, ArchConditions.createMessage((HasDescription)hasModifiers, infix)));
        }
    }

    private static class HaveOnlyModifiersCondition<T extends HasModifiers & HasDescription>
    extends AllAttributesMatchCondition<T> {
        private final Function<JavaClass, ? extends Collection<T>> getHasModifiers;

        HaveOnlyModifiersCondition(String description, JavaModifier modifier, Function<JavaClass, ? extends Collection<T>> getHasModifiers) {
            super("have only " + description, new ModifierCondition(modifier));
            this.getHasModifiers = getHasModifiers;
        }

        @Override
        Collection<T> relevantAttributes(JavaClass javaClass) {
            return this.getHasModifiers.apply(javaClass);
        }
    }
}

