/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.lang.ConfiguredMessageFormat;
import com.tngtech.archunit.lang.FailureMessages;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;

public final class FailureReport {
    private final FailureMessages failureMessages;
    private final HasDescription rule;
    private final Priority priority;

    FailureReport(HasDescription rule, Priority priority, FailureMessages failureMessages) {
        this.rule = rule;
        this.priority = priority;
        this.failureMessages = failureMessages;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEmpty() {
        return this.failureMessages.isEmpty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<String> getDetails() {
        return ImmutableList.copyOf(this.failureMessages);
    }

    public String toString() {
        return ConfiguredMessageFormat.get().formatFailure(this.rule, this.failureMessages, this.priority);
    }

    FailureReport filter(Predicate<String> predicate) {
        return new FailureReport(this.rule, this.priority, this.failureMessages.filter(predicate));
    }
}

