/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingList;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicate;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public class FailureMessages
extends ForwardingList<String> {
    private final List<String> failures;
    private final Optional<String> informationAboutNumberOfViolations;

    FailureMessages(Collection<String> failures, Optional<String> informationAboutNumberOfViolations) {
        this.failures = ImmutableList.copyOf(failures);
        this.informationAboutNumberOfViolations = informationAboutNumberOfViolations;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getInformationAboutNumberOfViolations() {
        return this.informationAboutNumberOfViolations.or(this.failures.size() + " times");
    }

    FailureMessages filter(Predicate<String> predicate) {
        ImmutableList.Builder filtered = ImmutableList.builder();
        for (String message : this.failures) {
            if (!predicate.apply(message)) continue;
            filtered.add(message);
        }
        return new FailureMessages(filtered.build(), this.informationAboutNumberOfViolations);
    }

    @Override
    protected List<String> delegate() {
        return this.failures;
    }
}

