/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.FailureMessages;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;

class ConfiguredMessageFormat {
    private static final ConfiguredMessageFormat instance = new ConfiguredMessageFormat();

    ConfiguredMessageFormat() {
    }

    static ConfiguredMessageFormat get() {
        return instance;
    }

    String formatFailure(HasDescription rule, FailureMessages failureMessages, Priority priority) {
        String violationTexts = Joiner.on(System.lineSeparator()).join(failureMessages);
        return String.format("Architecture Violation [Priority: %s] - Rule '%s' was violated (%s):%n%s", priority.asString(), rule.getDescription(), failureMessages.getInformationAboutNumberOfViolations(), violationTexts);
    }

    <T> String formatRuleText(HasDescription itemsUnderTest, ArchCondition<T> condition) {
        return String.format("%s should %s", itemsUnderTest.getDescription(), condition.getDescription());
    }
}

