/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasDescriptor;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.importer.JavaTypeImporter;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

class RawAccessRecord {
    final CodeUnit caller;
    final TargetInfo target;
    final int lineNumber;

    RawAccessRecord(CodeUnit caller, TargetInfo target, int lineNumber) {
        this.caller = Preconditions.checkNotNull(caller);
        this.target = Preconditions.checkNotNull(target);
        this.lineNumber = lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.caller, this.target, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RawAccessRecord other = (RawAccessRecord)obj;
        return Objects.equals(this.caller, other.caller) && Objects.equals(this.target, other.target) && Objects.equals(this.lineNumber, other.lineNumber);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.fieldsAsString() + '}';
    }

    private String fieldsAsString() {
        return "caller=" + this.caller + ", target=" + this.target + ", lineNumber=" + this.lineNumber;
    }

    static class ForField
    extends RawAccessRecord {
        final JavaFieldAccess.AccessType accessType;

        private ForField(CodeUnit caller, TargetInfo target, int lineNumber, JavaFieldAccess.AccessType accessType) {
            super(caller, target, lineNumber);
            this.accessType = accessType;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(new Object[]{this.accessType});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ForField other = (ForField)obj;
            return Objects.equals((Object)this.accessType, (Object)other.accessType);
        }

        static class Builder
        extends BaseBuilder<Builder> {
            private JavaFieldAccess.AccessType accessType;

            Builder() {
            }

            Builder withAccessType(JavaFieldAccess.AccessType accessType) {
                this.accessType = accessType;
                return this;
            }

            @Override
            ForField build() {
                return new ForField(this.caller, this.target, this.lineNumber, this.accessType);
            }
        }
    }

    static class BaseBuilder<SELF extends BaseBuilder<SELF>> {
        CodeUnit caller;
        TargetInfo target;
        int lineNumber = -1;

        BaseBuilder() {
        }

        SELF withCaller(CodeUnit caller) {
            this.caller = caller;
            return this.self();
        }

        SELF withTarget(TargetInfo target) {
            this.target = target;
            return this.self();
        }

        SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        SELF self() {
            return (SELF)this;
        }

        RawAccessRecord build() {
            return new RawAccessRecord(this.caller, this.target, this.lineNumber);
        }
    }

    static class Builder
    extends BaseBuilder<Builder> {
        Builder() {
        }
    }

    static class MethodTargetInfo
    extends TargetInfo {
        MethodTargetInfo(String owner, String name, String desc) {
            super(owner, name, desc);
        }

        @Override
        protected boolean signatureExistsIn(JavaClass javaClass) {
            for (JavaMethod method : javaClass.getMethods()) {
                if (!this.hasMatchingSignatureTo(method)) continue;
                return true;
            }
            return false;
        }
    }

    static class ConstructorTargetInfo
    extends TargetInfo {
        ConstructorTargetInfo(String owner, String name, String desc) {
            super(owner, name, desc);
        }

        @Override
        protected boolean signatureExistsIn(JavaClass javaClass) {
            for (JavaConstructor constructor : javaClass.getConstructors()) {
                if (!this.hasMatchingSignatureTo(constructor)) continue;
                return true;
            }
            return false;
        }
    }

    static class FieldTargetInfo
    extends TargetInfo {
        FieldTargetInfo(String owner, String name, String desc) {
            super(owner, name, desc);
        }

        @Override
        protected boolean signatureExistsIn(JavaClass javaClass) {
            Optional<JavaField> field = javaClass.tryGetField(this.name);
            return field.isPresent() && this.desc.equals(field.get().getDescriptor());
        }
    }

    static abstract class TargetInfo {
        final JavaType owner;
        final String name;
        final String desc;

        TargetInfo(String owner, String name, String desc) {
            this.owner = JavaTypeImporter.createFromAsmObjectTypeName(owner);
            this.name = name;
            this.desc = desc;
        }

        <T extends HasName & HasDescriptor> boolean matches(T member) {
            if (!this.name.equals(member.getName()) || !this.desc.equals(((HasDescriptor)member).getDescriptor())) {
                return false;
            }
            return this.owner.getName().equals(((JavaClass)((HasOwner)member).getOwner()).getName()) || this.classHierarchyFrom(member).hasExactlyOneMatchFor(this);
        }

        private <T extends HasName & HasDescriptor> ClassHierarchyPath classHierarchyFrom(T member) {
            return new ClassHierarchyPath(this.owner, (JavaClass)((HasOwner)member).getOwner());
        }

        protected abstract boolean signatureExistsIn(JavaClass var1);

        boolean hasMatchingSignatureTo(JavaMethod method) {
            return method.getName().equals(this.name) && method.getDescriptor().equals(this.desc);
        }

        boolean hasMatchingSignatureTo(JavaConstructor constructor) {
            return "<init>".equals(this.name) && constructor.getDescriptor().equals(this.desc);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.name, this.desc);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TargetInfo other = (TargetInfo)obj;
            return Objects.equals(this.owner, other.owner) && Objects.equals(this.name, other.name) && Objects.equals(this.desc, other.desc);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{owner='" + this.owner.getName() + "', name='" + this.name + "', desc='" + this.desc + "'}";
        }

        private static class ClassHierarchyPath {
            private final List<JavaClass> path = new ArrayList<JavaClass>();

            private ClassHierarchyPath(JavaType childType, JavaClass parent) {
                Sets.SetView<JavaClass> classesToSearchForChild = Sets.union(Collections.singleton(parent), parent.getAllSubClasses());
                Optional<HasName> child = ClassHierarchyPath.tryFind(classesToSearchForChild, HasName.Predicates.nameMatching(Pattern.quote(childType.getName())));
                if (child.isPresent()) {
                    this.createPath((JavaClass)child.get(), parent);
                }
            }

            private static <T> Optional<T> tryFind(Iterable<T> collection, DescribedPredicate<? super T> predicate) {
                for (T elem : collection) {
                    if (!predicate.apply(elem)) continue;
                    return Optional.of(elem);
                }
                return Optional.absent();
            }

            private void createPath(JavaClass child, JavaClass parent) {
                HierarchyResolutionStrategy hierarchyResolutionStrategy = this.hierarchyResolutionStrategyFrom(child).to(parent);
                this.path.add(child);
                while (hierarchyResolutionStrategy.hasNext()) {
                    this.path.add(hierarchyResolutionStrategy.next());
                }
            }

            boolean hasExactlyOneMatchFor(TargetInfo target) {
                HashSet<JavaClass> matching = new HashSet<JavaClass>();
                for (JavaClass javaClass : this.path) {
                    if (!target.signatureExistsIn(javaClass)) continue;
                    matching.add(javaClass);
                }
                return matching.size() == 1;
            }

            private HierarchyResolutionStrategyCreator hierarchyResolutionStrategyFrom(JavaClass child) {
                return new HierarchyResolutionStrategyCreator(child);
            }

            private static class Node {
                private final JavaClass child;
                private final Set<Node> parents = new HashSet<Node>();

                private Node(JavaClass child) {
                    this.child = child;
                    for (JavaClass i : child.getInterfaces()) {
                        this.parents.add(new Node(i));
                    }
                }

                public List<JavaClass> to(JavaClass target) {
                    if (this.child.equals(target)) {
                        return Collections.singletonList(this.child);
                    }
                    LinkedHashSet<JavaClass> result = new LinkedHashSet<JavaClass>();
                    for (Node parent : this.parents) {
                        if (!parent.contains(target)) continue;
                        result.add(this.child);
                        result.addAll(parent.to(target));
                    }
                    return new ArrayList<JavaClass>(result);
                }

                public boolean contains(JavaClass target) {
                    if (this.child.equals(target)) {
                        return true;
                    }
                    for (Node parent : this.parents) {
                        if (!parent.contains(target)) continue;
                        return true;
                    }
                    return false;
                }
            }

            private static class InterfaceHierarchyResolutionStrategy
            implements HierarchyResolutionStrategy {
                private final Iterator<JavaClass> interfaces;
                private final JavaClass parent;
                private JavaClass current;

                private InterfaceHierarchyResolutionStrategy(JavaClass child, JavaClass parent) {
                    this.interfaces = this.interfacesBetween(child, parent);
                    this.parent = parent;
                    this.current = child;
                }

                private Iterator<JavaClass> interfacesBetween(JavaClass from, JavaClass target) {
                    Node node = new Node(from);
                    ArrayList<JavaClass> result = new ArrayList<JavaClass>();
                    for (Node parent : node.parents) {
                        result.addAll(parent.to(target));
                    }
                    return result.iterator();
                }

                @Override
                public boolean hasNext() {
                    return !this.current.equals(this.parent) && this.interfaces.hasNext();
                }

                @Override
                public JavaClass next() {
                    this.current = this.interfaces.next();
                    return this.current;
                }
            }

            private static class ClassHierarchyResolutionStrategy
            implements HierarchyResolutionStrategy {
                private final JavaClass parent;
                private JavaClass current;

                private ClassHierarchyResolutionStrategy(JavaClass child, JavaClass parent) {
                    this.current = child;
                    this.parent = parent;
                }

                @Override
                public boolean hasNext() {
                    return !this.current.equals(this.parent) && this.current.getSuperClass().isPresent();
                }

                @Override
                public JavaClass next() {
                    this.current = this.current.getSuperClass().get();
                    return this.current;
                }
            }

            private static class HierarchyResolutionStrategyCreator {
                private final JavaClass child;

                private HierarchyResolutionStrategyCreator(JavaClass child) {
                    this.child = child;
                }

                public HierarchyResolutionStrategy to(JavaClass parent) {
                    return parent.isInterface() ? new InterfaceHierarchyResolutionStrategy(this.child, parent) : new ClassHierarchyResolutionStrategy(this.child, parent);
                }
            }

            private static interface HierarchyResolutionStrategy {
                public boolean hasNext();

                public JavaClass next();
            }
        }
    }

    static class CodeUnit {
        private final String name;
        private final List<String> parameters;
        private final String declaringClassName;
        private final int hashCode;

        CodeUnit(String name, List<String> parameters, String declaringClassName) {
            this.name = name;
            this.parameters = parameters;
            this.declaringClassName = declaringClassName;
            this.hashCode = Objects.hash(name, parameters, declaringClassName);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        String getDeclaringClassName() {
            return this.declaringClassName;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeUnit codeUnit = (CodeUnit)o;
            return Objects.equals(this.name, codeUnit.name) && Objects.equals(this.parameters, codeUnit.parameters) && Objects.equals(this.declaringClassName, codeUnit.declaringClassName);
        }

        public String toString() {
            return "CodeUnit{name='" + this.name + '\'' + ", parameters=" + this.parameters + ", declaringClassName='" + this.declaringClassName + '\'' + '}';
        }

        public boolean is(JavaCodeUnit method) {
            return this.getName().equals(method.getName()) && this.getParameters().equals(method.getRawParameterTypes().getNames()) && this.getDeclaringClassName().equals(method.getOwner().getName());
        }
    }
}

