/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import java.net.URI;
import java.util.List;
import java.util.Objects;

class NormalizedUri {
    private final URI uri;
    private final String firstSegment;
    private final String tailSegments;

    private NormalizedUri(URI uri) {
        String uriString = uri.normalize().toString();
        uriString = uriString.replaceAll("://*", ":/");
        uriString = !uriString.endsWith("/") && !uriString.endsWith(".class") ? uriString + "/" : uriString;
        this.uri = URI.create(uriString);
        List<String> path = Splitter.on("/").omitEmptyStrings().splitToList(this.uri.toString().replaceAll("^.*:", ""));
        this.firstSegment = path.get(0);
        this.tailSegments = path.size() < 2 ? "" : Joiner.on("/").join(path.subList(1, path.size()));
    }

    URI toURI() {
        return this.uri;
    }

    String getScheme() {
        return this.uri.getScheme();
    }

    public String getFirstSegment() {
        return this.firstSegment;
    }

    public String getTailSegments() {
        return this.tailSegments;
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizedUri other = (NormalizedUri)obj;
        return Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        return this.uri.toString();
    }

    static NormalizedUri from(URI uri) {
        return new NormalizedUri(uri);
    }

    static NormalizedUri from(String uriString) {
        return NormalizedUri.from(URI.create(uriString));
    }
}

