/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.importer.LocationResolver;
import com.tngtech.archunit.core.importer.UrlSource;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.lang.module.ModuleFinder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.stream.Collectors;

class ModuleLocationResolver
implements LocationResolver {
    ModuleLocationResolver() {
    }

    @Override
    public UrlSource resolveClassPath() {
        UrlSource classpath = UrlSource.From.classPathSystemProperties();
        Iterable modulepath = ModuleFinder.ofSystem().findAll().stream().flatMap(moduleReference -> moduleReference.location().stream()).map(this::toUrl).collect(Collectors.toList());
        return UrlSource.From.iterable(Iterables.concat(classpath, modulepath));
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

