/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.importer.ClassFileLocation;
import com.tngtech.archunit.core.importer.ClassFileSource;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.NormalizedResourceName;
import com.tngtech.archunit.core.importer.NormalizedUri;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ModuleLocationFactory
implements Location.Factory {
    ModuleLocationFactory() {
    }

    @Override
    public boolean supports(String scheme) {
        return "jrt".equals(scheme);
    }

    @Override
    public Location create(URI uri) {
        return new ModuleLocation(NormalizedUri.from(uri));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T doWithModuleReader(ModuleReference moduleReference, ModuleReaderProcessor<T> readerProcessor) {
        try (ModuleReader moduleReader = moduleReference.open();){
            T t = readerProcessor.process(moduleReader);
            return t;
        }
        catch (IOException e) {
            String message = String.format("Unexpected error while processing module %s", moduleReference);
            throw new RuntimeException(message, e);
        }
    }

    @FunctionalInterface
    private static interface ModuleReaderProcessor<T> {
        public T process(ModuleReader var1) throws IOException;
    }

    private static class ModuleClassFileLocation
    implements ClassFileLocation {
        private final ModuleReference moduleReference;
        private final NormalizedResourceName entry;
        private final ModuleLocation location;

        ModuleClassFileLocation(ModuleReference moduleReference, String entry) {
            this(moduleReference, NormalizedResourceName.from(entry));
        }

        ModuleClassFileLocation(ModuleReference moduleReference, NormalizedResourceName entry) {
            this.moduleReference = moduleReference;
            this.entry = entry;
            this.location = new ModuleLocation(moduleReference, entry);
        }

        @Override
        public InputStream openStream() {
            return (InputStream)ModuleLocationFactory.doWithModuleReader(this.moduleReference, moduleReader -> moduleReader.open(this.entry.toString()).orElseThrow(() -> new IllegalStateException(String.format("Entry %s parsed from JRT location %s could not be opened. This is most likely a bug.", this.entry, this.location))));
        }

        @Override
        public URI getUri() {
            return this.location.asURI();
        }

        boolean isIncludedBy(ImportOptions importOptions) {
            return importOptions.include(this.location);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{uri=" + this.getUri() + "}";
        }
    }

    private static class ModuleClassFileSource
    implements ClassFileSource {
        private final Stream<ClassFileLocation> locations;

        ModuleClassFileSource(ModuleReference moduleReference, NormalizedResourceName resourceName, ImportOptions importOptions) {
            Set<String> entries = this.loadEntries(moduleReference, resourceName);
            this.locations = entries.stream().map(entry -> new ModuleClassFileLocation(moduleReference, (String)entry)).filter(classFileLocation -> classFileLocation.isIncludedBy(importOptions)).map(Function.identity());
        }

        private Set<String> loadEntries(ModuleReference moduleReference, NormalizedResourceName resourceName) {
            return (Set)ModuleLocationFactory.doWithModuleReader(moduleReference, moduleReader -> moduleReader.list().filter(resourceName::isStartOf).filter(ClassFileSource.FileToImport::isRelevant).map(entry -> "/" + entry).collect(Collectors.toSet()));
        }

        @Override
        public Iterator<ClassFileLocation> iterator() {
            return this.locations.iterator();
        }
    }

    private static class ModuleLocation
    extends Location {
        private static final String SCHEME = "jrt";
        private final ModuleReference moduleReference;
        private final NormalizedResourceName resourceName;

        ModuleLocation(NormalizedUri uri) {
            super(uri);
            this.checkScheme(SCHEME, uri);
            this.moduleReference = this.findModuleReference(uri);
            this.resourceName = this.parseResourceName(uri);
        }

        ModuleLocation(ModuleReference moduleReference, NormalizedResourceName resourceName) {
            super(ModuleLocation.createUri(moduleReference, resourceName));
            this.moduleReference = moduleReference;
            this.resourceName = resourceName;
        }

        private static NormalizedUri createUri(ModuleReference moduleReference, NormalizedResourceName resourceName) {
            Preconditions.checkState(moduleReference.location().isPresent(), "We only consider module references with location, so something went wrong here");
            return NormalizedUri.from(moduleReference.location().get() + resourceName.toAbsolutePath());
        }

        private ModuleReference findModuleReference(NormalizedUri uri) {
            String moduleName = uri.getFirstSegment();
            Optional<ModuleReference> moduleReference = ModuleFinder.ofSystem().find(moduleName);
            Preconditions.checkState(moduleReference.isPresent(), "Couldn't find module %s of URI %s", (Object)moduleName, (Object)uri);
            return moduleReference.get();
        }

        private NormalizedResourceName parseResourceName(NormalizedUri uri) {
            return NormalizedResourceName.from(uri.getTailSegments());
        }

        @Override
        public boolean isJar() {
            return false;
        }

        @Override
        public boolean isArchive() {
            return true;
        }

        @Override
        Iterable<NormalizedResourceName> iterateEntriesInternal() {
            return (Iterable)ModuleLocationFactory.doWithModuleReader(this.moduleReference, moduleReader -> moduleReader.list().filter(this.resourceName::isStartOf).map(NormalizedResourceName::from).collect(Collectors.toList()));
        }

        @Override
        ClassFileSource asClassFileSource(ImportOptions importOptions) {
            if (!importOptions.include(this)) {
                return Collections::emptyListIterator;
            }
            return new ModuleClassFileSource(this.moduleReference, this.resourceName, importOptions);
        }
    }
}

