/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.core.InitialConfiguration;
import com.tngtech.archunit.core.importer.ImportPlugin;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.LocationResolver;
import com.tngtech.archunit.core.importer.NormalizedResourceName;
import com.tngtech.archunit.core.importer.UrlSource;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Locations {
    private static final InitialConfiguration<LocationResolver> locationResolver = new InitialConfiguration();

    private Locations() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<Location> of(Iterable<URL> urls) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (URL url : urls) {
            result.add(Location.of(url));
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<Location> ofPackage(String pkg) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Location location : Locations.getLocationsOf(Locations.asResourceName(pkg))) {
            result.add(location);
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<Location> ofClass(Class<?> clazz) {
        return Locations.getLocationsOf(Locations.asResourceName(clazz.getName()) + ".class");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<Location> inClassPath() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (URL url : locationResolver.get().resolveClassPath()) {
            result.add(Location.of(url));
        }
        return result.build();
    }

    private static String asResourceName(String qualifiedName) {
        return qualifiedName.replace('.', '/');
    }

    private static Set<Location> getLocationsOf(String resourceName) {
        UrlSource classpath = locationResolver.get().resolveClassPath();
        NormalizedResourceName normalizedResourceName = NormalizedResourceName.from(resourceName);
        return ImmutableSet.copyOf(Locations.getResourceLocations(ClassLoaders.getCurrentClassLoader(Locations.class), normalizedResourceName, classpath));
    }

    private static Collection<Location> getResourceLocations(ClassLoader loader, NormalizedResourceName resourceName, Iterable<URL> classpath) {
        HashSet<Location> result = Sets.newHashSet(Locations.of(Locations.getResources(loader, resourceName)));
        for (Location location : Locations.of(classpath)) {
            if (!Locations.containsEntryWithPrefix(location, resourceName)) continue;
            result.add(location.append(resourceName.toString()));
        }
        return result;
    }

    private static List<URL> getResources(ClassLoader loader, NormalizedResourceName resourceName) {
        try {
            return Collections.list(loader.getResources(resourceName.toString()));
        }
        catch (IOException e) {
            throw new ArchUnitException.LocationException(e);
        }
    }

    private static boolean containsEntryWithPrefix(Location location, NormalizedResourceName searchedJarEntryPrefix) {
        for (NormalizedResourceName name : location.iterateEntries()) {
            if (!name.startsWith(searchedJarEntryPrefix)) continue;
            return true;
        }
        return false;
    }

    static {
        ImportPlugin.Loader.loadForCurrentPlatform().plugInLocationResolver(locationResolver);
    }
}

