/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.util.List;

class JavaTypeImporter {
    JavaTypeImporter() {
    }

    static JavaType createFromAsmObjectTypeName(String objectTypeName) {
        return JavaTypeImporter.importAsmType(Type.getObjectType(objectTypeName));
    }

    static JavaType importAsmType(Type type) {
        return JavaType.From.name(type.getClassName());
    }

    static Object importAsmTypeIfPossible(Object value) {
        return value instanceof Type ? JavaTypeImporter.importAsmType((Type)value) : value;
    }

    static JavaType importAsmType(String typeDescriptor) {
        return JavaTypeImporter.importAsmType(Type.getType(typeDescriptor));
    }

    static List<JavaType> importAsmMethodArgumentTypes(String methodDescriptor) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : Type.getArgumentTypes(methodDescriptor)) {
            result.add(JavaTypeImporter.importAsmType(type));
        }
        return result.build();
    }

    static JavaType importAsmMethodReturnType(String methodDescriptor) {
        return JavaTypeImporter.importAsmType(Type.getReturnType(methodDescriptor));
    }
}

