/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.importer.ClassesByTypeName;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.JavaTypeImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Booleans;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Bytes;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Chars;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Doubles;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Floats;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Ints;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Longs;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Shorts;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.AnnotationVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.ClassVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.FieldVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Label;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.MethodVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaClassProcessor
extends ClassVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClassProcessor.class);
    private static final AccessHandler NO_OP = new AccessHandler.NoOp();
    private DomainBuilders.JavaClassBuilder javaClassBuilder;
    private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();
    private final URI sourceURI;
    private final DeclarationHandler declarationHandler;
    private final AccessHandler accessHandler;
    private String className;

    JavaClassProcessor(URI sourceURI, DeclarationHandler declarationHandler) {
        this(sourceURI, declarationHandler, NO_OP);
    }

    JavaClassProcessor(URI sourceURI, DeclarationHandler declarationHandler, AccessHandler accessHandler) {
        super(458752);
        this.sourceURI = sourceURI;
        this.declarationHandler = declarationHandler;
        this.accessHandler = accessHandler;
    }

    Optional<JavaClass> createJavaClass() {
        return this.javaClassBuilder != null ? Optional.of(this.javaClassBuilder.build()) : Optional.absent();
    }

    @Override
    public void visitSource(String source, String debug) {
        if (!this.importAborted() && source != null) {
            this.javaClassBuilder.withSourceFileName(source);
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug("Analyzing class '{}'", (Object)name);
        JavaType javaType = JavaTypeImporter.createFromAsmObjectTypeName(name);
        if (this.alreadyImported(javaType)) {
            return;
        }
        ImmutableSet<String> interfaceNames = this.createInterfaceNames(interfaces);
        LOG.trace("Found interfaces {} on class '{}'", interfaceNames, (Object)name);
        boolean opCodeForInterfaceIsPresent = (access & 0x200) != 0;
        boolean opCodeForEnumIsPresent = (access & 0x4000) != 0;
        Optional<String> superClassName = this.getSuperClassName(superName, opCodeForInterfaceIsPresent);
        LOG.trace("Found superclass {} on class '{}'", (Object)superClassName.orNull(), (Object)name);
        this.javaClassBuilder = new DomainBuilders.JavaClassBuilder().withSourceUri(this.sourceURI).withType(javaType).withInterface(opCodeForInterfaceIsPresent).withEnum(opCodeForEnumIsPresent).withModifiers(JavaModifier.getModifiersForClass(access));
        this.className = javaType.getName();
        this.declarationHandler.onNewClass(this.className, superClassName, interfaceNames);
    }

    private boolean alreadyImported(JavaType javaType) {
        return !this.declarationHandler.isNew(javaType.getName());
    }

    private Optional<String> getSuperClassName(String superName, boolean isInterface) {
        return superName != null && !isInterface ? Optional.of(this.createTypeName(superName)) : Optional.absent();
    }

    private boolean importAborted() {
        return this.javaClassBuilder == null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.importAborted()) {
            return;
        }
        String innerTypeName = this.createTypeName(name);
        if (!this.visitingCurrentClass(innerTypeName)) {
            return;
        }
        this.javaClassBuilder.withSimpleName(Strings.nullToEmpty(innerName));
        boolean isAnonymousClass = innerName == null;
        this.javaClassBuilder.withAnonymousClass(isAnonymousClass);
        boolean isMemberClass = outerName != null;
        this.javaClassBuilder.withMemberClass(isMemberClass);
        if (isMemberClass) {
            this.javaClassBuilder.withModifiers(JavaModifier.getModifiersForClass(access));
            this.declarationHandler.registerEnclosingClass(innerTypeName, this.createTypeName(outerName));
        }
    }

    private boolean visitingCurrentClass(String innerTypeName) {
        return innerTypeName.equals(this.className);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (this.importAborted()) {
            return;
        }
        this.declarationHandler.registerEnclosingClass(this.className, this.createTypeName(owner));
    }

    private ImmutableSet<String> createInterfaceNames(String[] interfaces) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String i : interfaces) {
            result.add(this.createTypeName(i));
        }
        return result.build();
    }

    private String createTypeName(String name) {
        return name.replace("/", ".");
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.importAborted()) {
            return super.visitField(access, name, desc, signature, value);
        }
        DomainBuilders.JavaFieldBuilder fieldBuilder = (DomainBuilders.JavaFieldBuilder)((DomainBuilders.JavaFieldBuilder)((DomainBuilders.JavaFieldBuilder)new DomainBuilders.JavaFieldBuilder().withName(name)).withType(JavaTypeImporter.importAsmType(desc)).withModifiers(JavaModifier.getModifiersForField(access))).withDescriptor(desc);
        this.declarationHandler.onDeclaredField(fieldBuilder);
        return new FieldProcessor(fieldBuilder);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.importAborted()) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        LOG.trace("Analyzing method {}.{}:{}", new Object[]{this.className, name, desc});
        List<JavaType> parameters = JavaTypeImporter.importAsmMethodArgumentTypes(desc);
        this.accessHandler.setContext(new RawAccessRecord.CodeUnit(name, JavaClassProcessor.namesOf(parameters), this.className));
        DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder = this.addCodeUnitBuilder(name);
        ((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaMemberBuilder)((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaCodeUnitBuilder)codeUnitBuilder.withName(name)).withModifiers(JavaModifier.getModifiersForMethod(access))).withParameters(parameters)).withReturnType(JavaTypeImporter.importAsmMethodReturnType(desc))).withDescriptor(desc)).withThrowsClause(this.typesFrom(exceptions));
        return new MethodProcessor(this.className, this.accessHandler, codeUnitBuilder);
    }

    private List<JavaType> typesFrom(String[] throwsDeclarations) {
        ArrayList<JavaType> result = new ArrayList<JavaType>();
        if (throwsDeclarations != null) {
            for (String throwsDeclaration : throwsDeclarations) {
                result.add(JavaTypeImporter.createFromAsmObjectTypeName(throwsDeclaration));
            }
        }
        return result;
    }

    private DomainBuilders.JavaCodeUnitBuilder<?, ?> addCodeUnitBuilder(String name) {
        if ("<init>".equals(name)) {
            DomainBuilders.JavaConstructorBuilder builder = new DomainBuilders.JavaConstructorBuilder();
            this.declarationHandler.onDeclaredConstructor(builder);
            return builder;
        }
        if ("<clinit>".equals(name)) {
            DomainBuilders.JavaStaticInitializerBuilder builder = new DomainBuilders.JavaStaticInitializerBuilder();
            this.declarationHandler.onDeclaredStaticInitializer(builder);
            return builder;
        }
        DomainBuilders.JavaMethodBuilder builder = new DomainBuilders.JavaMethodBuilder();
        this.declarationHandler.onDeclaredMethod(builder);
        return builder;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.importAborted()) {
            return super.visitAnnotation(desc, visible);
        }
        return new AnnotationProcessor(JavaClassProcessor.addAnnotationTo(this.annotations), JavaClassProcessor.annotationBuilderFor(desc));
    }

    @Override
    public void visitEnd() {
        if (this.importAborted()) {
            return;
        }
        this.declarationHandler.onDeclaredAnnotations(this.annotations);
        LOG.trace("Done analyzing {}", (Object)this.className);
    }

    private static List<String> namesOf(Iterable<JavaType> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (JavaType type : types) {
            result.add(type.getName());
        }
        return result.build();
    }

    private static DomainBuilders.JavaAnnotationBuilder annotationBuilderFor(String desc) {
        return new DomainBuilders.JavaAnnotationBuilder().withType(JavaTypeImporter.importAsmType(desc));
    }

    private static TakesAnnotationBuilder addAnnotationTo(final Collection<? super DomainBuilders.JavaAnnotationBuilder> collection) {
        return new TakesAnnotationBuilder(){

            @Override
            public void add(DomainBuilders.JavaAnnotationBuilder annotation) {
                collection.add(annotation);
            }
        };
    }

    private static TakesAnnotationBuilder addAnnotationAsProperty(final String name, final DomainBuilders.JavaAnnotationBuilder annotationBuilder) {
        return new TakesAnnotationBuilder(){

            @Override
            public void add(DomainBuilders.JavaAnnotationBuilder builder) {
                annotationBuilder.addProperty(name, DomainBuilders.JavaAnnotationBuilder.ValueBuilder.from(builder));
            }
        };
    }

    private static DomainBuilders.JavaAnnotationBuilder.ValueBuilder javaEnumBuilder(final String desc, final String value) {
        return new DomainBuilders.JavaAnnotationBuilder.ValueBuilder(){

            @Override
            public <T extends HasDescription> Optional<Object> build(T owner, ClassesByTypeName importedClasses) {
                return Optional.of(new DomainBuilders.JavaEnumConstantBuilder().withDeclaringClass(importedClasses.get(JavaTypeImporter.importAsmType(desc).getName())).withName(value).build());
            }
        };
    }

    private static class AnnotationTypeConversion {
        private AnnotationTypeConversion() {
        }

        static DomainBuilders.JavaAnnotationBuilder.ValueBuilder convert(Object input) {
            final Object value = JavaTypeImporter.importAsmTypeIfPossible(input);
            if (value instanceof JavaType) {
                return new DomainBuilders.JavaAnnotationBuilder.ValueBuilder(){

                    @Override
                    public <T extends HasDescription> Optional<Object> build(T owner, ClassesByTypeName importedClasses) {
                        return Optional.of(importedClasses.get(((JavaType)value).getName()));
                    }
                };
            }
            return DomainBuilders.JavaAnnotationBuilder.ValueBuilder.ofFinished(value);
        }
    }

    private static interface AnnotationArrayContext {
        public String getDeclaringAnnotationTypeName();

        public String getDeclaringAnnotationMemberName();

        public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder var1);
    }

    private static class AnnotationArrayProcessor
    extends AnnotationVisitor {
        private final AnnotationArrayContext annotationArrayContext;
        private Class<?> derivedComponentType;
        private final List<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> values = new ArrayList<DomainBuilders.JavaAnnotationBuilder.ValueBuilder>();

        private AnnotationArrayProcessor(AnnotationArrayContext annotationArrayContext) {
            super(458752);
            this.annotationArrayContext = annotationArrayContext;
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.setDerivedComponentType(JavaClass.class);
            } else {
                this.setDerivedComponentType(value.getClass());
            }
            this.values.add(AnnotationTypeConversion.convert(value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.setDerivedComponentType(JavaAnnotation.class);
            return new AnnotationProcessor(new TakesAnnotationBuilder(){

                @Override
                public void add(DomainBuilders.JavaAnnotationBuilder annotationBuilder) {
                    AnnotationArrayProcessor.this.values.add(DomainBuilders.JavaAnnotationBuilder.ValueBuilder.from(annotationBuilder));
                }
            }, JavaClassProcessor.annotationBuilderFor(desc));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.setDerivedComponentType(JavaEnumConstant.class);
            this.values.add(JavaClassProcessor.javaEnumBuilder(desc, value));
        }

        private void setDerivedComponentType(Class<?> type) {
            Preconditions.checkState(this.derivedComponentType == null || this.derivedComponentType.equals(type), "Found mixed component types while importing array, this is most likely a bug");
            this.derivedComponentType = type;
        }

        @Override
        public void visitEnd() {
            this.annotationArrayContext.setArrayResult(new ArrayValueBuilder());
        }

        private class ArrayValueBuilder
        extends DomainBuilders.JavaAnnotationBuilder.ValueBuilder {
            private ArrayValueBuilder() {
            }

            @Override
            public <T extends HasDescription> Optional<Object> build(T owner, ClassesByTypeName importedClasses) {
                Optional<Class<?>> componentType = this.determineComponentType(importedClasses);
                if (!componentType.isPresent()) {
                    return Optional.absent();
                }
                return Optional.of(this.toArray(componentType.get(), this.buildValues(owner, importedClasses)));
            }

            private Object toArray(Class<?> componentType, List<Object> values) {
                if (componentType == Boolean.TYPE) {
                    return Booleans.toArray(values);
                }
                if (componentType == Byte.TYPE) {
                    return Bytes.toArray(values);
                }
                if (componentType == Short.TYPE) {
                    return Shorts.toArray(values);
                }
                if (componentType == Integer.TYPE) {
                    return Ints.toArray(values);
                }
                if (componentType == Long.TYPE) {
                    return Longs.toArray(values);
                }
                if (componentType == Float.TYPE) {
                    return Floats.toArray(values);
                }
                if (componentType == Double.TYPE) {
                    return Doubles.toArray(values);
                }
                if (componentType == Character.TYPE) {
                    return Chars.toArray(values);
                }
                return values.toArray((Object[])Array.newInstance(componentType, values.size()));
            }

            private <T extends HasDescription> List<Object> buildValues(T owner, ClassesByTypeName importedClasses) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (DomainBuilders.JavaAnnotationBuilder.ValueBuilder value : AnnotationArrayProcessor.this.values) {
                    result.addAll(value.build(owner, importedClasses).asSet());
                }
                return result;
            }

            private Optional<Class<?>> determineComponentType(ClassesByTypeName importedClasses) {
                if (AnnotationArrayProcessor.this.derivedComponentType != null) {
                    return Optional.of(AnnotationArrayProcessor.this.derivedComponentType);
                }
                JavaClass annotationType = importedClasses.get(AnnotationArrayProcessor.this.annotationArrayContext.getDeclaringAnnotationTypeName());
                Optional<JavaMethod> method = annotationType.tryGetMethod(AnnotationArrayProcessor.this.annotationArrayContext.getDeclaringAnnotationMemberName());
                return method.isPresent() ? this.determineComponentTypeFromReturnValue(method.get()) : Optional.absent();
            }

            private Optional<Class<?>> determineComponentTypeFromReturnValue(JavaMethod method) {
                if (method.getRawReturnType().isEquivalentTo(Class[].class)) {
                    return Optional.of(JavaClass.class);
                }
                return this.resolveComponentTypeFrom(method.getRawReturnType().getName());
            }

            @MayResolveTypesViaReflection(reason="Resolving primitives does not really use reflection")
            private Optional<Class<?>> resolveComponentTypeFrom(String arrayTypeName) {
                JavaType type = JavaType.From.name(arrayTypeName);
                JavaType componentType = this.getComponentType(type);
                if (componentType.isPrimitive()) {
                    return Optional.of(componentType.resolveClass());
                }
                if (String.class.getName().equals(componentType.getName())) {
                    return Optional.of(String.class);
                }
                return Optional.of(Object.class);
            }

            private JavaType getComponentType(JavaType type) {
                Optional<JavaType> result = type.tryGetComponentType();
                Preconditions.checkState(result.isPresent(), "Couldn't determine component type of array return type %s, this is most likely a bug", (Object)type.getName());
                return result.get();
            }
        }
    }

    private static interface TakesAnnotationBuilder {
        public void add(DomainBuilders.JavaAnnotationBuilder var1);
    }

    private static class AnnotationProcessor
    extends AnnotationVisitor {
        private final TakesAnnotationBuilder takesAnnotationBuilder;
        private final DomainBuilders.JavaAnnotationBuilder annotationBuilder;

        private AnnotationProcessor(TakesAnnotationBuilder takesAnnotationBuilder, DomainBuilders.JavaAnnotationBuilder annotationBuilder) {
            super(458752);
            this.takesAnnotationBuilder = takesAnnotationBuilder;
            this.annotationBuilder = annotationBuilder;
        }

        @Override
        public void visit(String name, Object value) {
            this.annotationBuilder.addProperty(name, AnnotationTypeConversion.convert(value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.annotationBuilder.addProperty(name, JavaClassProcessor.javaEnumBuilder(desc, value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationProcessor(JavaClassProcessor.addAnnotationAsProperty(name, this.annotationBuilder), JavaClassProcessor.annotationBuilderFor(desc));
        }

        @Override
        public AnnotationVisitor visitArray(final String name) {
            return new AnnotationArrayProcessor(new AnnotationArrayContext(){

                @Override
                public String getDeclaringAnnotationTypeName() {
                    return AnnotationProcessor.this.annotationBuilder.getJavaType().getName();
                }

                @Override
                public String getDeclaringAnnotationMemberName() {
                    return name;
                }

                @Override
                public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
                    AnnotationProcessor.this.annotationBuilder.addProperty(name, valueBuilder);
                }
            });
        }

        @Override
        public void visitEnd() {
            this.takesAnnotationBuilder.add(this.annotationBuilder);
        }
    }

    private static class FieldProcessor
    extends FieldVisitor {
        private final DomainBuilders.JavaFieldBuilder fieldBuilder;
        private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();

        private FieldProcessor(DomainBuilders.JavaFieldBuilder fieldBuilder) {
            super(458752);
            this.fieldBuilder = fieldBuilder;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(JavaClassProcessor.addAnnotationTo(this.annotations), JavaClassProcessor.annotationBuilderFor(desc));
        }

        @Override
        public void visitEnd() {
            this.fieldBuilder.withAnnotations(this.annotations);
        }
    }

    static interface AccessHandler {
        public void handleFieldInstruction(int var1, String var2, String var3, String var4);

        public void setContext(RawAccessRecord.CodeUnit var1);

        public void setLineNumber(int var1);

        public void handleMethodInstruction(String var1, String var2, String var3);

        @Internal
        public static class NoOp
        implements AccessHandler {
            @Override
            public void handleFieldInstruction(int opcode, String owner, String name, String desc) {
            }

            @Override
            public void setContext(RawAccessRecord.CodeUnit codeUnit) {
            }

            @Override
            public void setLineNumber(int lineNumber) {
            }

            @Override
            public void handleMethodInstruction(String owner, String name, String desc) {
            }
        }
    }

    static interface DeclarationHandler {
        public boolean isNew(String var1);

        public void onNewClass(String var1, Optional<String> var2, Set<String> var3);

        public void onDeclaredField(DomainBuilders.JavaFieldBuilder var1);

        public void onDeclaredConstructor(DomainBuilders.JavaConstructorBuilder var1);

        public void onDeclaredMethod(DomainBuilders.JavaMethodBuilder var1);

        public void onDeclaredStaticInitializer(DomainBuilders.JavaStaticInitializerBuilder var1);

        public void onDeclaredAnnotations(Set<DomainBuilders.JavaAnnotationBuilder> var1);

        public void registerEnclosingClass(String var1, String var2);
    }

    private static class SetAsAnnotationDefault
    implements TakesAnnotationBuilder,
    AnnotationArrayContext {
        private final String annotationTypeName;
        private final DomainBuilders.JavaMethodBuilder methodBuilder;

        private SetAsAnnotationDefault(String annotationTypeName, DomainBuilders.JavaMethodBuilder methodBuilder) {
            this.annotationTypeName = annotationTypeName;
            this.methodBuilder = methodBuilder;
        }

        @Override
        public void add(DomainBuilders.JavaAnnotationBuilder annotation) {
            this.setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder.from(annotation));
        }

        @Override
        public String getDeclaringAnnotationTypeName() {
            return this.annotationTypeName;
        }

        @Override
        public String getDeclaringAnnotationMemberName() {
            return this.methodBuilder.getName();
        }

        @Override
        public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
            this.methodBuilder.withAnnotationDefaultValue(valueBuilder);
        }
    }

    private static class MethodProcessor
    extends MethodVisitor {
        private final String declaringClassName;
        private final AccessHandler accessHandler;
        private final DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder;
        private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();
        private int actualLineNumber;

        MethodProcessor(String declaringClassName, AccessHandler accessHandler, DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder) {
            super(458752);
            this.declaringClassName = declaringClassName;
            this.accessHandler = accessHandler;
            this.codeUnitBuilder = codeUnitBuilder;
        }

        @Override
        public void visitCode() {
            this.actualLineNumber = 0;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            LOG.trace("Examining line number {}", (Object)line);
            this.codeUnitBuilder.recordLineNumber(line);
            this.actualLineNumber = line;
            this.accessHandler.setLineNumber(this.actualLineNumber);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.accessHandler.handleFieldInstruction(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.accessHandler.handleMethodInstruction(owner, name, desc);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(JavaClassProcessor.addAnnotationTo(this.annotations), JavaClassProcessor.annotationBuilderFor(desc));
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationDefaultProcessor(this.declaringClassName, this.codeUnitBuilder);
        }

        @Override
        public void visitEnd() {
            this.codeUnitBuilder.withAnnotations(this.annotations);
        }

        private static class AnnotationDefaultProcessor
        extends AnnotationVisitor {
            private final String annotationTypeName;
            private final DomainBuilders.JavaMethodBuilder methodBuilder;

            AnnotationDefaultProcessor(String annotationTypeName, DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder) {
                super(458752);
                this.annotationTypeName = annotationTypeName;
                Preconditions.checkArgument(codeUnitBuilder instanceof DomainBuilders.JavaMethodBuilder, "tried to import annotation defaults for code unit '%s' that is not a method (as any annotation.property() is assumed to be), this is likely a bug", (Object)codeUnitBuilder.getName());
                this.methodBuilder = (DomainBuilders.JavaMethodBuilder)codeUnitBuilder;
            }

            @Override
            public void visit(String name, Object value) {
                this.methodBuilder.withAnnotationDefaultValue(AnnotationTypeConversion.convert(value));
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                this.methodBuilder.withAnnotationDefaultValue(JavaClassProcessor.javaEnumBuilder(desc, value));
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationProcessor(new SetAsAnnotationDefault(this.annotationTypeName, this.methodBuilder), JavaClassProcessor.annotationBuilderFor(desc));
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                return new AnnotationArrayProcessor(new SetAsAnnotationDefault(this.annotationTypeName, this.methodBuilder));
            }
        }
    }
}

