/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.importer.ClassesByTypeName;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;

class ImportedClasses {
    private static final ImmutableSet<JavaModifier> PRIMITIVE_AND_ARRAY_TYPE_MODIFIERS = Sets.immutableEnumSet((Enum)JavaModifier.PUBLIC, (Enum[])new JavaModifier[]{JavaModifier.ABSTRACT, JavaModifier.FINAL});
    private final ImmutableMap<String, JavaClass> directlyImported;
    private final Map<String, JavaClass> additionalClasses = new HashMap<String, JavaClass>();
    private final ClassResolver resolver;

    ImportedClasses(Map<String, JavaClass> directlyImported, ClassResolver resolver) {
        this.directlyImported = ImmutableMap.copyOf(directlyImported);
        this.resolver = resolver;
    }

    Map<String, JavaClass> getDirectlyImported() {
        return this.directlyImported;
    }

    JavaClass getOrResolve(String typeName) {
        this.ensurePresent(typeName);
        return this.directlyImported.containsKey(typeName) ? this.directlyImported.get(typeName) : this.additionalClasses.get(typeName);
    }

    void ensurePresent(String typeName) {
        if (!this.contain(typeName)) {
            Optional<JavaClass> resolved = this.resolver.tryResolve(typeName);
            JavaClass newClass = resolved.isPresent() ? resolved.get() : ImportedClasses.simpleClassOf(typeName);
            this.additionalClasses.put(typeName, newClass);
        }
    }

    private boolean contain(String name) {
        return this.directlyImported.containsKey(name) || this.additionalClasses.containsKey(name);
    }

    Map<String, JavaClass> getAll() {
        return ImmutableMap.builder().putAll(this.directlyImported).putAll(this.additionalClasses).build();
    }

    ClassesByTypeName byTypeName() {
        return new ClassesByTypeName(){

            @Override
            public JavaClass get(String typeName) {
                return ImportedClasses.this.getOrResolve(typeName);
            }
        };
    }

    private static JavaClass simpleClassOf(String typeName) {
        JavaType type = JavaType.From.name(typeName);
        DomainBuilders.JavaClassBuilder builder = new DomainBuilders.JavaClassBuilder().withType(type);
        ImportedClasses.addModifiersIfPossible(builder, type);
        return builder.build();
    }

    private static void addModifiersIfPossible(DomainBuilders.JavaClassBuilder builder, JavaType type) {
        if (type.isPrimitive() || type.isArray()) {
            builder.withModifiers(PRIMITIVE_AND_ARRAY_TYPE_MODIFIERS);
        }
    }
}

