/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public interface ImportOption {
    public boolean includes(Location var1);

    public static final class DoNotIncludeArchives
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isArchive();
        }
    }

    public static final class DoNotIncludeJars
    implements ImportOption {
        @Override
        public boolean includes(Location location) {
            return !location.isJar();
        }
    }

    public static final class DoNotIncludeTests
    implements ImportOption {
        private static final Pattern MAVEN_PATTERN = Pattern.compile(".*/target/test-classes/.*");
        private static final Pattern GRADLE_PATTERN = Pattern.compile(".*/build/classes/([^/]+/)?test/.*");
        private static final Pattern INTELLIJ_PATTERN = Pattern.compile(".*/out/test/classes/.*");
        private static final Set<Pattern> EXCLUDED_PATTERN = ImmutableSet.of(MAVEN_PATTERN, GRADLE_PATTERN, INTELLIJ_PATTERN);

        @Override
        public boolean includes(Location location) {
            for (Pattern pattern : EXCLUDED_PATTERN) {
                if (!location.matches(pattern)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum Predefined implements ImportOption
    {
        DO_NOT_INCLUDE_TESTS{
            private final DoNotIncludeTests doNotIncludeTests = new DoNotIncludeTests();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeTests.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_JARS{
            private final DoNotIncludeJars doNotIncludeJars = new DoNotIncludeJars();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeJars.includes(location);
            }
        }
        ,
        DO_NOT_INCLUDE_ARCHIVES{
            private final DoNotIncludeArchives doNotIncludeArchives = new DoNotIncludeArchives();

            @Override
            public boolean includes(Location location) {
                return this.doNotIncludeArchives.includes(location);
            }
        };

    }
}

