/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassList;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.importer.ClassesByTypeName;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public final class DomainBuilders {
    private DomainBuilders() {
    }

    static <T extends HasDescription> Map<String, JavaAnnotation<T>> buildAnnotations(T owner, Set<JavaAnnotationBuilder> annotations, ClassesByTypeName importedClasses) {
        ImmutableMap.Builder<String, JavaAnnotation<T>> result = ImmutableMap.builder();
        for (JavaAnnotationBuilder annotationBuilder : annotations) {
            JavaAnnotation<T> javaAnnotation = annotationBuilder.build(owner, importedClasses);
            result.put(javaAnnotation.getRawType().getName(), javaAnnotation);
        }
        return result.build();
    }

    @Internal
    public static final class MethodCallTargetBuilder
    extends CodeUnitCallTargetBuilder<MethodCallTargetBuilder> {
        private Supplier<Set<JavaMethod>> methods;

        MethodCallTargetBuilder() {
        }

        MethodCallTargetBuilder withMethods(Supplier<Set<JavaMethod>> methods) {
            this.methods = methods;
            return this;
        }

        public Supplier<Set<JavaMethod>> getMethods() {
            return this.methods;
        }

        AccessTarget.MethodCallTarget build() {
            return DomainObjectCreationContext.createMethodCallTarget(this);
        }
    }

    @Internal
    public static final class ConstructorCallTargetBuilder
    extends CodeUnitCallTargetBuilder<ConstructorCallTargetBuilder> {
        private Supplier<Optional<JavaConstructor>> constructor;

        ConstructorCallTargetBuilder() {
            this.withName("<init>");
        }

        ConstructorCallTargetBuilder withConstructor(Supplier<Optional<JavaConstructor>> constructor) {
            this.constructor = constructor;
            return (ConstructorCallTargetBuilder)this.self();
        }

        public Supplier<Optional<JavaConstructor>> getConstructor() {
            return this.constructor;
        }

        AccessTarget.ConstructorCallTarget build() {
            return DomainObjectCreationContext.createConstructorCallTarget(this);
        }
    }

    @Internal
    public static abstract class CodeUnitCallTargetBuilder<SELF extends CodeUnitCallTargetBuilder<SELF>>
    extends AccessTargetBuilder<SELF> {
        private JavaClassList parameters;
        private JavaClass returnType;

        private CodeUnitCallTargetBuilder() {
        }

        SELF withParameters(JavaClassList parameters) {
            this.parameters = parameters;
            return (SELF)((CodeUnitCallTargetBuilder)this.self());
        }

        SELF withReturnType(JavaClass returnType) {
            this.returnType = returnType;
            return (SELF)((CodeUnitCallTargetBuilder)this.self());
        }

        public JavaClassList getParameters() {
            return this.parameters;
        }

        public JavaClass getReturnType() {
            return this.returnType;
        }

        public String getFullName() {
            return Formatters.formatMethod(this.getOwner().getName(), this.getName(), this.parameters);
        }
    }

    @Internal
    public static final class FieldAccessTargetBuilder
    extends AccessTargetBuilder<FieldAccessTargetBuilder> {
        private JavaClass type;
        private Supplier<Optional<JavaField>> field;

        FieldAccessTargetBuilder() {
        }

        FieldAccessTargetBuilder withType(JavaClass type) {
            this.type = type;
            return this;
        }

        FieldAccessTargetBuilder withField(Supplier<Optional<JavaField>> field) {
            this.field = field;
            return this;
        }

        public JavaClass getType() {
            return this.type;
        }

        public Supplier<Optional<JavaField>> getField() {
            return this.field;
        }

        public String getFullName() {
            return this.getOwner().getName() + "." + this.getName();
        }

        AccessTarget.FieldAccessTarget build() {
            return DomainObjectCreationContext.createFieldAccessTarget(this);
        }
    }

    static abstract class AccessTargetBuilder<SELF extends AccessTargetBuilder<SELF>> {
        private JavaClass owner;
        private String name;

        private AccessTargetBuilder() {
        }

        SELF withOwner(JavaClass owner) {
            this.owner = owner;
            return this.self();
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        SELF self() {
            return (SELF)this;
        }
    }

    @Internal
    public static class JavaConstructorCallBuilder
    extends JavaAccessBuilder<AccessTarget.ConstructorCallTarget, JavaConstructorCallBuilder> {
        JavaConstructorCallBuilder() {
        }

        JavaConstructorCall build() {
            return DomainObjectCreationContext.createJavaConstructorCall(this);
        }
    }

    @Internal
    public static final class JavaMethodCallBuilder
    extends JavaAccessBuilder<AccessTarget.MethodCallTarget, JavaMethodCallBuilder> {
        JavaMethodCallBuilder() {
        }

        JavaMethodCall build() {
            return DomainObjectCreationContext.createJavaMethodCall(this);
        }
    }

    @Internal
    public static class JavaFieldAccessBuilder
    extends JavaAccessBuilder<AccessTarget.FieldAccessTarget, JavaFieldAccessBuilder> {
        private JavaFieldAccess.AccessType accessType;

        JavaFieldAccessBuilder() {
        }

        JavaFieldAccessBuilder withAccessType(JavaFieldAccess.AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public JavaFieldAccess.AccessType getAccessType() {
            return this.accessType;
        }

        JavaFieldAccess build() {
            return DomainObjectCreationContext.createJavaFieldAccess(this);
        }
    }

    @Internal
    public static abstract class JavaAccessBuilder<TARGET extends AccessTarget, SELF extends JavaAccessBuilder<TARGET, SELF>> {
        private JavaCodeUnit origin;
        private TARGET target;
        private int lineNumber;

        private JavaAccessBuilder() {
        }

        SELF withOrigin(JavaCodeUnit origin) {
            this.origin = origin;
            return this.self();
        }

        SELF withTarget(TARGET target) {
            this.target = target;
            return this.self();
        }

        SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        public JavaCodeUnit getOrigin() {
            return this.origin;
        }

        public TARGET getTarget() {
            return this.target;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        private SELF self() {
            return (SELF)this;
        }
    }

    @Internal
    static interface BuilderWithBuildParameter<PARAMETER, VALUE> {
        public VALUE build(PARAMETER var1, ClassesByTypeName var2);

        @Internal
        public static class BuildFinisher {
            static <PARAMETER, VALUE> Set<VALUE> build(Set<? extends BuilderWithBuildParameter<PARAMETER, ? extends VALUE>> builders, PARAMETER parameter, ClassesByTypeName importedClasses) {
                Preconditions.checkNotNull(builders);
                Preconditions.checkNotNull(parameter);
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (BuilderWithBuildParameter<PARAMETER, VALUE> builder : builders) {
                    result.add(builder.build(parameter, importedClasses));
                }
                return result.build();
            }
        }
    }

    @Internal
    public static final class JavaStaticInitializerBuilder
    extends JavaCodeUnitBuilder<JavaStaticInitializer, JavaStaticInitializerBuilder> {
        JavaStaticInitializerBuilder() {
            this.withReturnType(JavaType.From.name(Void.TYPE.getName()));
            this.withParameters(Collections.emptyList());
            this.withName("<clinit>");
            this.withDescriptor("()V");
            this.withAnnotations(Collections.emptySet());
            this.withModifiers(Collections.emptySet());
            this.withThrowsClause(Collections.emptyList());
        }

        @Override
        JavaStaticInitializer construct(JavaStaticInitializerBuilder builder, ClassesByTypeName importedClasses) {
            return DomainObjectCreationContext.createJavaStaticInitializer(builder);
        }
    }

    @Internal
    public static final class JavaAnnotationBuilder {
        private JavaType type;
        private final Map<String, ValueBuilder> values = new LinkedHashMap<String, ValueBuilder>();
        private ClassesByTypeName importedClasses;

        JavaAnnotationBuilder() {
        }

        JavaAnnotationBuilder withType(JavaType type) {
            this.type = type;
            return this;
        }

        JavaType getJavaType() {
            return this.type;
        }

        JavaAnnotationBuilder addProperty(String key, ValueBuilder valueBuilder) {
            this.values.put(key, valueBuilder);
            return this;
        }

        public JavaClass getType() {
            return this.importedClasses.get(this.type.getName());
        }

        public <T extends HasDescription> Map<String, Object> getValues(T owner) {
            ImmutableMap.Builder<String, Object> result = ImmutableMap.builder();
            for (Map.Entry<String, ValueBuilder> entry : this.values.entrySet()) {
                Optional<Object> value = entry.getValue().build(owner, this.importedClasses);
                if (!value.isPresent()) continue;
                result.put(entry.getKey(), value.get());
            }
            this.addDefaultValues(result, this.importedClasses);
            return result.build();
        }

        private void addDefaultValues(ImmutableMap.Builder<String, Object> result, ClassesByTypeName importedClasses) {
            for (JavaMethod method : importedClasses.get(this.type.getName()).getMethods()) {
                if (this.values.containsKey(method.getName()) || !method.getDefaultValue().isPresent()) continue;
                result.put(method.getName(), method.getDefaultValue().get());
            }
        }

        public <T extends HasDescription> JavaAnnotation<T> build(T owner, ClassesByTypeName importedClasses) {
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createJavaAnnotation(owner, this);
        }

        static abstract class ValueBuilder {
            ValueBuilder() {
            }

            abstract <T extends HasDescription> Optional<Object> build(T var1, ClassesByTypeName var2);

            static ValueBuilder ofFinished(final Object value) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ClassesByTypeName importedClasses) {
                        return Optional.of(value);
                    }
                };
            }

            static ValueBuilder from(JavaAnnotationBuilder builder) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ClassesByTypeName importedClasses) {
                        return Optional.of(JavaAnnotationBuilder.this.build(owner, importedClasses));
                    }
                };
            }
        }
    }

    @Internal
    public static final class JavaClassBuilder {
        private Optional<URI> sourceURI = Optional.absent();
        private Optional<String> sourceFileName = Optional.absent();
        private JavaType javaType;
        private boolean isInterface;
        private boolean isEnum;
        private boolean isAnonymousClass;
        private boolean isMemberClass;
        private Set<JavaModifier> modifiers = new HashSet<JavaModifier>();

        JavaClassBuilder() {
        }

        JavaClassBuilder withSourceUri(URI sourceUri) {
            this.sourceURI = Optional.of(sourceUri);
            return this;
        }

        JavaClassBuilder withSourceFileName(String sourceFileName) {
            this.sourceFileName = Optional.of(sourceFileName);
            return this;
        }

        JavaClassBuilder withType(JavaType javaType) {
            this.javaType = javaType;
            return this;
        }

        JavaClassBuilder withInterface(boolean isInterface) {
            this.isInterface = isInterface;
            return this;
        }

        JavaClassBuilder withAnonymousClass(boolean isAnonymousClass) {
            this.isAnonymousClass = isAnonymousClass;
            return this;
        }

        JavaClassBuilder withMemberClass(boolean isMemberClass) {
            this.isMemberClass = isMemberClass;
            return this;
        }

        JavaClassBuilder withEnum(boolean isEnum) {
            this.isEnum = isEnum;
            return this;
        }

        JavaClassBuilder withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        JavaClassBuilder withSimpleName(String simpleName) {
            this.javaType = this.javaType.withSimpleName(simpleName);
            return this;
        }

        JavaClass build() {
            return DomainObjectCreationContext.createJavaClass(this);
        }

        public Optional<Source> getSource() {
            return this.sourceURI.isPresent() ? Optional.of(DomainObjectCreationContext.createSource(this.sourceURI.get(), this.sourceFileName)) : Optional.absent();
        }

        public JavaType getJavaType() {
            return this.javaType;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isEnum() {
            return this.isEnum;
        }

        public boolean isAnonymousClass() {
            return this.isAnonymousClass;
        }

        public boolean isMemberClass() {
            return this.isMemberClass;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }
    }

    @Internal
    public static final class JavaConstructorBuilder
    extends JavaCodeUnitBuilder<JavaConstructor, JavaConstructorBuilder> {
        JavaConstructorBuilder() {
        }

        @Override
        JavaConstructor construct(JavaConstructorBuilder builder, ClassesByTypeName importedClasses) {
            return DomainObjectCreationContext.createJavaConstructor(builder);
        }
    }

    @Internal
    public static final class JavaMethodBuilder
    extends JavaCodeUnitBuilder<JavaMethod, JavaMethodBuilder> {
        private Optional<JavaAnnotationBuilder.ValueBuilder> annotationDefaultValueBuilder = Optional.absent();
        private Supplier<Optional<Object>> annotationDefaultValue = Suppliers.ofInstance(Optional.absent());

        JavaMethodBuilder() {
        }

        JavaMethodBuilder withAnnotationDefaultValue(JavaAnnotationBuilder.ValueBuilder defaultValue) {
            this.annotationDefaultValueBuilder = Optional.of(defaultValue);
            return this;
        }

        public Supplier<Optional<Object>> getAnnotationDefaultValue() {
            return this.annotationDefaultValue;
        }

        @Override
        JavaMethod construct(JavaMethodBuilder builder, ClassesByTypeName importedClasses) {
            if (this.annotationDefaultValueBuilder.isPresent()) {
                this.annotationDefaultValue = Suppliers.memoize(new DefaultValueSupplier(this.getOwner(), this.annotationDefaultValueBuilder.get(), importedClasses));
            }
            return DomainObjectCreationContext.createJavaMethod(builder);
        }

        private static class DefaultValueSupplier
        implements Supplier<Optional<Object>> {
            private final JavaClass owner;
            private final JavaAnnotationBuilder.ValueBuilder valueBuilder;
            private final ClassesByTypeName importedClasses;

            DefaultValueSupplier(JavaClass owner, JavaAnnotationBuilder.ValueBuilder valueBuilder, ClassesByTypeName importedClasses) {
                this.owner = owner;
                this.valueBuilder = valueBuilder;
                this.importedClasses = importedClasses;
            }

            @Override
            public Optional<Object> get() {
                return this.valueBuilder.build(this.owner, this.importedClasses);
            }
        }
    }

    @Internal
    public static abstract class JavaCodeUnitBuilder<OUTPUT, SELF extends JavaCodeUnitBuilder<OUTPUT, SELF>>
    extends JavaMemberBuilder<OUTPUT, SELF> {
        private JavaType returnType;
        private List<JavaType> parameters;
        private List<JavaType> throwsDeclarations;

        private JavaCodeUnitBuilder() {
        }

        SELF withReturnType(JavaType type) {
            this.returnType = type;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withParameters(List<JavaType> parameters) {
            this.parameters = parameters;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withThrowsClause(List<JavaType> throwsDeclarations) {
            this.throwsDeclarations = throwsDeclarations;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        public JavaClass getReturnType() {
            return this.get(this.returnType.getName());
        }

        public JavaClassList getParameters() {
            return DomainObjectCreationContext.createJavaClassList(this.asJavaClasses(this.parameters));
        }

        public <CODE_UNIT extends JavaCodeUnit> ThrowsClause<CODE_UNIT> getThrowsClause(CODE_UNIT codeUnit) {
            return DomainObjectCreationContext.createThrowsClause(codeUnit, this.asJavaClasses(this.throwsDeclarations));
        }

        private List<JavaClass> asJavaClasses(List<JavaType> javaTypes) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaType javaType : javaTypes) {
                result.add(this.get(javaType.getName()));
            }
            return result.build();
        }
    }

    @Internal
    public static final class JavaFieldBuilder
    extends JavaMemberBuilder<JavaField, JavaFieldBuilder> {
        private JavaType type;

        JavaFieldBuilder() {
        }

        JavaFieldBuilder withType(JavaType type) {
            this.type = type;
            return (JavaFieldBuilder)this.self();
        }

        public JavaClass getType() {
            return this.get(this.type.getName());
        }

        @Override
        JavaField construct(JavaFieldBuilder builder, ClassesByTypeName importedClasses) {
            return DomainObjectCreationContext.createJavaField(builder);
        }
    }

    @Internal
    public static abstract class JavaMemberBuilder<OUTPUT, SELF extends JavaMemberBuilder<OUTPUT, SELF>>
    implements BuilderWithBuildParameter<JavaClass, OUTPUT> {
        private String name;
        private String descriptor;
        private Set<JavaAnnotationBuilder> annotations;
        private Set<JavaModifier> modifiers;
        private JavaClass owner;
        private ClassesByTypeName importedClasses;
        private int firstLineNumber;

        private JavaMemberBuilder() {
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        SELF withDescriptor(String descriptor) {
            this.descriptor = descriptor;
            return this.self();
        }

        SELF withAnnotations(Set<JavaAnnotationBuilder> annotations) {
            this.annotations = annotations;
            return this.self();
        }

        SELF withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this.self();
        }

        void recordLineNumber(int lineNumber) {
            this.firstLineNumber = this.firstLineNumber == 0 ? lineNumber : Math.min(this.firstLineNumber, lineNumber);
        }

        SELF self() {
            return (SELF)this;
        }

        abstract OUTPUT construct(SELF var1, ClassesByTypeName var2);

        JavaClass get(String typeName) {
            return this.importedClasses.get(typeName);
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Map<String, JavaAnnotation<JavaMember>>> getAnnotations(final JavaMember owner) {
            return Suppliers.memoize(new Supplier<Map<String, JavaAnnotation<JavaMember>>>(){

                @Override
                public Map<String, JavaAnnotation<JavaMember>> get() {
                    return DomainBuilders.buildAnnotations(owner, JavaMemberBuilder.this.annotations, JavaMemberBuilder.this.importedClasses);
                }
            });
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public int getFirstLineNumber() {
            return this.firstLineNumber;
        }

        @Override
        public final OUTPUT build(JavaClass owner, ClassesByTypeName importedClasses) {
            this.owner = owner;
            this.importedClasses = importedClasses;
            return this.construct(this.self(), importedClasses);
        }
    }

    @Internal
    public static final class JavaEnumConstantBuilder {
        private JavaClass declaringClass;
        private String name;

        JavaEnumConstantBuilder() {
        }

        JavaEnumConstantBuilder withDeclaringClass(JavaClass declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        JavaEnumConstantBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public JavaClass getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        JavaEnumConstant build() {
            return DomainObjectCreationContext.createJavaEnumConstant(this);
        }
    }
}

